/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiException;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.messages.InvocationMessage;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.messages.InvocationReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.rmi.Remote;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class PeerRmiDispatcher
implements PeerDispatcher<InvocationMessage> {
    private static final String TAG = PeerRmiDispatcher.class.getSimpleName();
    private final Executor fExecutor;
    private final ObjectRegistry fObjectRegistry;
    private ReturnGroup fReturnGroup;

    public PeerRmiDispatcher(ObjectRegistry objectRegistry) {
        this.fObjectRegistry = objectRegistry;
        NamedThreadFactory namedThreadFactory = NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fExecutor-"), (Logger)Log.LOGGER);
        this.fExecutor = Executors.newCachedThreadPool((ThreadFactory)namedThreadFactory);
        ((ThreadPoolExecutor)this.fExecutor).allowCoreThreadTimeOut(true);
        ((ThreadPoolExecutor)this.fExecutor).setCorePoolSize(8);
        ((ThreadPoolExecutor)this.fExecutor).setKeepAliveTime(60L, TimeUnit.SECONDS);
    }

    public PeerRmiDispatcher(ObjectRegistry objectRegistry, Executor executor) {
        this.fObjectRegistry = objectRegistry;
        this.fExecutor = executor;
    }

    @Override
    public void dispatch(final InvocationMessage invocationMessage, final Instance instance) {
        final long l = invocationMessage.getSequenceNumber();
        Log.LOGGER.fine(TAG + ": Dispatching InvocationMessage " + l + " from " + instance);
        this.fExecutor.execute(new Runnable(){

            @Override
            public void run() {
                InvocationReturnMessage invocationReturnMessage;
                try {
                    Remote remote2 = PeerRmiDispatcher.this.lookupObject(invocationMessage.getObjectId());
                    invocationReturnMessage = invocationMessage.invoke(remote2, l);
                }
                catch (PeerRmiException peerRmiException) {
                    invocationReturnMessage = new InvocationReturnMessage(l, peerRmiException);
                }
                catch (RuntimeException runtimeException) {
                    Log.LOGGER.severe(TAG + ": Runtime exception in dispatch " + runtimeException.getMessage());
                    throw runtimeException;
                }
                PeerRmiDispatcher.this.sendReturnMessage(instance, invocationReturnMessage);
            }
        });
    }

    private void sendReturnMessage(Instance instance, InvocationReturnMessage invocationReturnMessage) {
        Log.LOGGER.fine(TAG + ": Returning " + invocationReturnMessage + " to " + instance);
        this.fReturnGroup.returnTo(instance, (ReturnMessage)invocationReturnMessage);
    }

    private Remote lookupObject(ObjectRegistry.ID iD) throws PeerRmiException {
        Remote remote2 = this.fObjectRegistry.lookup(iD);
        if (remote2 == null) {
            throw new NoSuchObjectInRegistryException(iD);
        }
        return remote2;
    }

    @Override
    public void initReturnGroup(ReturnGroup returnGroup) {
        this.fReturnGroup = returnGroup;
    }

    private static class NoSuchObjectInRegistryException
    extends PeerRmiException {
        private NoSuchObjectInRegistryException(ObjectRegistry.ID iD) {
            super("No object with id " + iD + " in registry");
        }
    }
}

