/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.ClientOutputGroupFactory;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.PeerRmiException;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.messages.InvocationMessage;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.messages.InvocationReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageFuture;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class RemoteMethodInvocationHandler
implements InvocationHandler,
Serializable {
    private static final String TAG = RemoteMethodInvocationHandler.class.getSimpleName();
    private final ObjectRegistry.ID fObjectID;
    private final ClientOutputGroupFactory fClientOutputGroupFactory;
    private final Instance fRemoteInstance;
    private final long fMethodCallTimeout;

    public RemoteMethodInvocationHandler(ObjectRegistry.ID iD, Instance instance, ClientOutputGroupFactory clientOutputGroupFactory, long l) {
        this.fObjectID = iD;
        this.fRemoteInstance = instance;
        this.fClientOutputGroupFactory = clientOutputGroupFactory;
        this.fMethodCallTimeout = l;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        ObservableMessageFuture<InvocationReturnMessage> observableMessageFuture = new ObservableMessageFuture<InvocationReturnMessage>(InvocationReturnMessage.class);
        this.invokeAsync(method, objectArray, observableMessageFuture);
        InvocationReturnMessage invocationReturnMessage = this.getReturnMessage(observableMessageFuture);
        Throwable throwable = invocationReturnMessage.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
        return invocationReturnMessage.getResult();
    }

    private InvocationReturnMessage getReturnMessage(ObservableMessageFuture<InvocationReturnMessage> observableMessageFuture) throws PeerRmiException {
        try {
            return (InvocationReturnMessage)observableMessageFuture.get(this.fMethodCallTimeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            Log.LOGGER.severe(TAG + ": Exception getting invocation return message.");
            throw new NoReturnMessageException("Exception getting invocation return message.", executionException);
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.severe(TAG + ": Interrupted while getting invocation return message");
            throw new NoReturnMessageException("Interrupted getting invocation return message.", interruptedException);
        }
        catch (TimeoutException timeoutException) {
            Log.LOGGER.severe(TAG + ": InvocationReturnMessage not available after waiting for " + this.fMethodCallTimeout + "ms");
            throw new MethodCallTimeoutException(this.fMethodCallTimeout, TimeUnit.MILLISECONDS);
        }
    }

    public void invokeAsync(Method method, Object[] objectArray, MessageObserver messageObserver) throws PeerRmiException {
        InvocationMessage invocationMessage = new InvocationMessage(this.fObjectID, method.getName(), method.getParameterTypes(), objectArray);
        this.sendMessage(invocationMessage, messageObserver);
    }

    private void sendMessage(InvocationMessage invocationMessage, MessageObserver messageObserver) throws PeerRmiException {
        OutputGroup outputGroup = this.fClientOutputGroupFactory.createOutputGroup(this.fRemoteInstance);
        assert (outputGroup != null) : "createOutputGroup should not return null";
        Log.LOGGER.info(TAG + ": Sending " + invocationMessage + " to " + this.fRemoteInstance);
        try {
            outputGroup.sendTo(this.fRemoteInstance, (ObservableMessage)invocationMessage, messageObserver);
        }
        catch (NoSuchDestinationException noSuchDestinationException) {
            throw new FailedToSendInvocationException("Failed to send invocation message to " + this.fRemoteInstance, noSuchDestinationException);
        }
    }

    public String toString() {
        return "RemoteMethodInvocationHandler{fObjectID=" + this.fObjectID + ", fRemoteInstance=" + this.fRemoteInstance + ", fClientOutputGroupFactory=" + this.fClientOutputGroupFactory + ", fMethodCallTimeout=" + this.fMethodCallTimeout + '}';
    }

    private static class FailedToSendInvocationException
    extends PeerRmiException {
        private FailedToSendInvocationException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static class NoReturnMessageException
    extends PeerRmiException {
        private NoReturnMessageException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static class MethodCallTimeoutException
    extends PeerRmiException {
        private MethodCallTimeoutException(long l, TimeUnit timeUnit) {
            super("Method call timeout " + l + " " + (Object)((Object)timeUnit) + " exceeded.");
        }
    }
}

