/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.security;

import com.mathworks.toolbox.distcomp.mjs.security.CertificateBase64Encoder;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStoreException;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.util.security.KeyStoreFactory;
import com.mathworks.toolbox.distcomp.util.security.SSLContextFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import java.util.UUID;
import javax.net.ssl.SSLContext;

public final class ClientCertificateStore {
    private static ClientCertificateStore sInstance;
    private final KeyStore fKeyStore;

    public static synchronized ClientCertificateStore getInstance() {
        if (sInstance == null) {
            PackageInfo.LOGGER.info("ClientCertificateStore: Creating instance");
            sInstance = new ClientCertificateStore();
        }
        return sInstance;
    }

    private ClientCertificateStore() {
        KeyStoreFactory keyStoreFactory = new KeyStoreFactory();
        this.fKeyStore = keyStoreFactory.createKeyStore();
    }

    public synchronized SSLContext createSSLContext() {
        SSLContextFactory sSLContextFactory = new SSLContextFactory();
        return sSLContextFactory.createClientSSLContext(this.fKeyStore);
    }

    public synchronized void setCertificateEntry(String string, Certificate certificate) {
        PackageInfo.LOGGER.info("ClientCertificateStore: Adding certificate " + string);
        try {
            this.fKeyStore.setCertificateEntry(string, certificate);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }

    private void setCertificateEntry(String string, InputStream inputStream) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(inputStream);
        this.setCertificateEntry(string, certificate);
    }

    public void setCertificateEntry(String string, String string2) throws CertificateException {
        PackageInfo.LOGGER.info("ClientCertificateStore: Reading base64 encoded certificate.");
        this.setCertificateEntry(string, string2.getBytes(Charset.forName("UTF-8")));
    }

    public String putCertificate(String string) throws CertificateException {
        String string2 = UUID.randomUUID().toString();
        this.setCertificateEntry(string2, string);
        return string2;
    }

    public void setCertificateEntry(String string, byte[] byArray) throws CertificateException {
        PackageInfo.LOGGER.info("ClientCertificateStore: Reading byte encoded certificate.");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.setCertificateEntry(string, byteArrayInputStream);
    }

    public String putCertificate(byte[] byArray) throws CertificateException {
        String string = UUID.randomUUID().toString();
        this.setCertificateEntry(string, byArray);
        return string;
    }

    public void setCertificateEntry(String string, File file) throws CertificateException, FileNotFoundException {
        PackageInfo.LOGGER.info("ClientCertificateStore: Loading certificate from file " + file);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        this.setCertificateEntry(string, bufferedInputStream);
    }

    public String putCertificate(File file) throws FileNotFoundException, CertificateException {
        String string = UUID.randomUUID().toString();
        this.setCertificateEntry(string, file);
        return string;
    }

    public synchronized void removeCertificateEntry(String string) {
        PackageInfo.LOGGER.info("ClientCertificateStore: Removing certificate " + string);
        try {
            this.fKeyStore.deleteEntry(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }

    public synchronized boolean containsEntry(String string) {
        try {
            return this.fKeyStore.containsAlias(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }

    public synchronized String getEncodedCertificateEntry(String string) {
        try {
            Certificate certificate = this.fKeyStore.getCertificate(string);
            if (certificate != null) {
                CertificateBase64Encoder certificateBase64Encoder = new CertificateBase64Encoder();
                return certificateBase64Encoder.encode(certificate);
            }
            return null;
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }

    public synchronized String[] entryList() {
        try {
            String[] stringArray = new String[this.fKeyStore.size()];
            Enumeration<String> enumeration = this.fKeyStore.aliases();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n] = enumeration.nextElement();
                ++n;
            }
            return stringArray;
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }

    public synchronized void removeAllEntries() {
        try {
            Enumeration<String> enumeration = this.fKeyStore.aliases();
            while (enumeration.hasMoreElements()) {
                this.fKeyStore.deleteEntry(enumeration.nextElement());
            }
        }
        catch (KeyStoreException keyStoreException) {
            throw new ClientCertificateStoreException(keyStoreException);
        }
    }
}

