/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class DispatchInvoker<T extends Message> {
    private Dispatcher<T> fDispatcher;
    private Class<?> fMessageClass;

    public Dispatcher<T> getDispatcher() {
        return this.fDispatcher;
    }

    public Class<?> getMessageClass() {
        return this.fMessageClass;
    }

    public boolean isInvokableObject(Class<?> clazz) {
        return this.fMessageClass.isAssignableFrom(clazz);
    }

    public void invoke(T t, Instance instance) {
        try {
            this.fDispatcher.dispatch(t, instance);
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to invoke dispatcher " + this.fDispatcher.getClass().getName() + " on message " + t, error);
            throw error;
        }
    }

    private DispatchInvoker(Dispatcher<T> dispatcher, Class<?> clazz) {
        this.fDispatcher = dispatcher;
        this.fMessageClass = clazz;
    }

    static <T extends Message> DispatchInvoker<T> create(Dispatcher<T> dispatcher, Class<?> clazz, Object object) {
        List<Class> list = DispatchInvoker.findAllMessageClasses(clazz, object);
        assert (!list.isEmpty()) : "No Dispatch Interface found";
        assert (list.size() == 1) : "Found " + list.size() + " Dispatch interfaces expecting only 1";
        return new DispatchInvoker<T>(dispatcher, list.get(0));
    }

    private static List<Class> findAllMessageClasses(Class clazz, Object object) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        List<Class> list = DispatchInvoker.getAllClasses(object.getClass());
        list.addAll(DispatchInvoker.getAllInterfaces(list));
        List<Type> list2 = DispatchInvoker.getAllGenericInterfaces(list);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Generic interface types on " + object + " are " + list2);
        for (Type type : list2) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "aParamType is " + parameterizedType);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "aParamType.getActualTypeArguments() [0] is " + parameterizedType.getActualTypeArguments()[0]);
            if (!clazz.isAssignableFrom((Class)parameterizedType.getRawType()) || !(parameterizedType.getActualTypeArguments()[0] instanceof Class)) continue;
            linkedList.add((Class)parameterizedType.getActualTypeArguments()[0]);
        }
        return linkedList;
    }

    private static List<Class> getAllClasses(Class clazz) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        while (clazz != null) {
            linkedList.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return linkedList;
    }

    private static List<Class> getAllInterfaces(List<Class> list) {
        LinkedList<Class> linkedList = new LinkedList<Class>();
        for (Class clazz : list) {
            List<Class> list2 = Arrays.asList(clazz.getInterfaces());
            List<Class> list3 = DispatchInvoker.getAllInterfaces(list2);
            linkedList.addAll(list2);
            linkedList.addAll(list3);
        }
        return linkedList;
    }

    private static List<Type> getAllGenericInterfaces(List<Class> list) {
        LinkedList<Type> linkedList = new LinkedList<Type>();
        for (Class clazz : list) {
            linkedList.addAll(Arrays.asList(clazz.getGenericInterfaces()));
        }
        return linkedList;
    }
}

