/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DrainableOutputImpl
implements DrainableOutput {
    public static final String sTRUNCATED_MESSAGE = "<truncated...>";
    public static final String sCONTINUATION_PREFIX = "  ";
    private final Map<ProcessInstance, StringBuffer> fOutputBuffers;
    private final Map<ProcessInstance, Boolean> fIsTruncated;
    private ProcessInstance fLastProcessPrinted = null;
    private final boolean fPrintLabIndex;
    private boolean fIsOpen;
    private final int fMaxLengthPerLab;
    private final String fLabIndexFormat;

    public DrainableOutputImpl(List<ProcessInstance> list, boolean bl, int n) {
        assert (n > 0) : "Maximum string length must be > 0.";
        this.fOutputBuffers = new TreeMap<ProcessInstance, StringBuffer>();
        this.fIsTruncated = new TreeMap<ProcessInstance, Boolean>();
        int n2 = 1;
        for (ProcessInstance processInstance : list) {
            this.fOutputBuffers.put(processInstance, new StringBuffer());
            this.fIsTruncated.put(processInstance, false);
            if (processInstance.getLabIndex() <= n2) continue;
            n2 = processInstance.getLabIndex();
        }
        this.fPrintLabIndex = bl;
        this.fIsOpen = true;
        this.fMaxLengthPerLab = n;
        int n3 = (int)Math.floor(Math.log10(n2)) + 1;
        this.fLabIndexFormat = "Lab %" + n3 + "d: \n";
    }

    public DrainableOutputImpl(List<ProcessInstance> list, boolean bl) {
        this(list, bl, 1000000);
    }

    @Override
    public synchronized void addOutput(ProcessInstance processInstance, String[] stringArray) {
        int n;
        if (!this.fIsOpen) {
            return;
        }
        StringBuffer stringBuffer = this.fOutputBuffers.get(processInstance);
        assert (stringBuffer != null) : "Received output for an unknown process ProcessInstance " + processInstance;
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD output from " + processInstance);
        int n2 = 0;
        for (n = stringArray.length - 1; n >= 0; --n) {
            if ((n2 += stringArray[n].length()) <= this.fMaxLengthPerLab) continue;
            stringArray[n] = stringArray[n].substring(n2 - this.fMaxLengthPerLab);
            n2 = this.fMaxLengthPerLab;
            stringBuffer.delete(0, stringBuffer.length());
            this.fIsTruncated.put(processInstance, true);
            break;
        }
        int n3 = Math.max(0, n);
        int n4 = n2 + stringBuffer.length();
        if (n4 > this.fMaxLengthPerLab) {
            stringBuffer.delete(0, n4 - this.fMaxLengthPerLab);
            this.fIsTruncated.put(processInstance, true);
        }
        for (int i = n3; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        assert (stringBuffer.length() <= this.fMaxLengthPerLab) : "StringBuffer has not been trimmed to the correct length";
    }

    @Override
    public synchronized void closeForOutput() {
        this.fIsOpen = false;
    }

    @Override
    public synchronized String[] drainOutput() {
        return this.doDrainOutput(false);
    }

    @Override
    public synchronized String[] drainAllOutput() {
        return this.doDrainOutput(true);
    }

    private String[] doDrainOutput(boolean bl) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (ProcessInstance processInstance : this.fOutputBuffers.keySet()) {
            String string = this.getStringToPrint(processInstance, bl);
            if (string == null) continue;
            linkedList.add(string);
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private String getStringToPrint(ProcessInstance processInstance, boolean bl) {
        StringBuffer stringBuffer = this.fOutputBuffers.get(processInstance);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Draining output for lab: " + processInstance + "buffer length: " + stringBuffer.length());
        if (stringBuffer.length() == 0) {
            return null;
        }
        String string = "";
        if (bl) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
        } else {
            int n = stringBuffer.lastIndexOf("\n");
            if (n <= 0) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "Nothing to print on " + processInstance);
                return null;
            }
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "From zero to " + n + " out of " + stringBuffer.length() + " on " + processInstance);
            string = stringBuffer.substring(n + 1, stringBuffer.length());
            stringBuffer.delete(n, stringBuffer.length());
        }
        if (this.fIsTruncated.get(processInstance).booleanValue()) {
            stringBuffer.insert(0, sTRUNCATED_MESSAGE);
            this.fIsTruncated.put(processInstance, false);
        }
        if (this.fPrintLabIndex) {
            String string2 = this.formatPrefix(processInstance);
            stringBuffer.insert(0, string2);
            string2 = this.continuationPrefix(string2);
            String string3 = '\n' + string2;
            int n = stringBuffer.indexOf("\n", string2.length());
            while (n >= 0) {
                stringBuffer.replace(n, n + 1, string3);
                n = stringBuffer.indexOf("\n", n + 1);
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Draining output for lab: " + processInstance + " sb buffer length: " + stringBuffer.length() + " retaining " + string.length() + " characters.");
        String string4 = stringBuffer.toString();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.insert(0, string);
        return string4;
    }

    private String formatPrefix(ProcessInstance processInstance) {
        ProcessInstance processInstance2 = processInstance;
        int n = processInstance2.getLabIndex();
        String string = String.format(this.fLabIndexFormat, n);
        if (processInstance.equals(this.fLastProcessPrinted)) {
            string = this.continuationPrefix(string);
        } else {
            this.fLastProcessPrinted = processInstance;
        }
        return string;
    }

    private String continuationPrefix(String string) {
        return sCONTINUATION_PREFIX;
    }
}

