/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.CmdExecResults;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import com.mathworks.toolbox.distcomp.pmode.LabsStateListener;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTracker;
import com.mathworks.toolbox.distcomp.pmode.LabsStateTrackerImpl;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.MInteractiveEvalCommand;
import com.mathworks.toolbox.distcomp.pmode.MInteractiveInterrupt;
import com.mathworks.toolbox.distcomp.pmode.MInterruptResult;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandler;
import com.mathworks.toolbox.distcomp.pmode.RemoteResultsHandlerImpl;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.AbstractRoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;

public class LabsImpl
implements Labs,
CommunicationObserver {
    private final RoleOutputGroup fOutGroup;
    private final List<PendingCommand> fPendingQueue;
    private final AtomicBoolean fLabsAreBusy;
    private final LabsStateTracker fLabsStateTracker;
    private final RemoteResultsHandler fResultsHandler;
    private final List<ProcessInstance> fLabInstances;
    private final SessionRoleMapping fRoleMapping;

    public static LabsImpl create(SessionService sessionService) {
        LabsImpl labsImpl = new LabsImpl(sessionService);
        labsImpl.init();
        return labsImpl;
    }

    private LabsImpl(SessionService sessionService) {
        this.fOutGroup = sessionService.getRoleCommGroup();
        this.fPendingQueue = Collections.synchronizedList(new LinkedList());
        this.fLabsAreBusy = new AtomicBoolean(false);
        this.fLabInstances = this.fOutGroup.getConnectedProcessInstances();
        this.fLabsStateTracker = new LabsStateTrackerImpl(sessionService, this.fLabInstances);
        this.fResultsHandler = new RemoteResultsHandlerImpl(sessionService, this.fLabsStateTracker);
        this.fRoleMapping = sessionService.getRoleMapping();
    }

    private void init() {
        this.fLabsStateTracker.setIdleListener(new LabsStateListener(){

            @Override
            public void labsAreIdle() {
                LabsImpl.this.onLabsAreIdle();
            }
        });
    }

    public synchronized void eval(String string) {
        this.eval(string, null);
    }

    public synchronized void evalConsoleOutput(String string) {
        LabsCompletionObserver labsCompletionObserver = new LabsCompletionObserver(){

            @Override
            public void handleLabList(List<ProcessInstance> list) {
            }

            @Override
            public void handleOutput(String string, ProcessInstance processInstance) {
                System.out.print(string);
            }

            @Override
            public void handleExecStatus(int n, ProcessInstance processInstance) {
            }

            @Override
            public void handleLabAborted(ProcessInstance processInstance) {
            }
        };
        this.eval(string, labsCompletionObserver);
    }

    @Override
    public synchronized void eval(String string, @Nullable LabsCompletionObserver labsCompletionObserver) {
        assert (string != null) : "M command string must not be null.";
        if (this.fLabsAreBusy.get()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Adding command to pending queue: " + string);
            this.fPendingQueue.add(new PendingCommand(string, labsCompletionObserver));
        } else {
            this.runCommand(string, labsCompletionObserver);
        }
    }

    public synchronized BlockingQueue<ReturnMessage> fevalOnLab(int n, String string, Object[] objectArray, int n2) {
        assert (string != null) : "Function string must not be null.";
        assert (n > 0 && n <= this.getNumLabs()) : "labindex must be between 1 and numlabs.";
        assert (n2 >= 0) : "nlhs cannot be less than zero";
        final LinkedBlockingQueue<ReturnMessage> linkedBlockingQueue = new LinkedBlockingQueue<ReturnMessage>();
        MFevalCommand mFevalCommand = new MFevalCommand(string, objectArray, n2, MFevalCommand.ConsoleOutput.Return);
        AbstractRoleMessageObserver abstractRoleMessageObserver = new AbstractRoleMessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                try {
                    linkedBlockingQueue.put(returnMessage);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (returnMessage instanceof CmdWinOutput) {
                    String[] stringArray;
                    for (String string : stringArray = ((CmdWinOutput)returnMessage).getStrings()) {
                        System.out.print(string);
                    }
                }
            }
        };
        this.fOutGroup.sendTo(ProcessInstance.getLabInstance(n), (ObservableMessage)mFevalCommand, (RoleMessageObserver)abstractRoleMessageObserver);
        return linkedBlockingQueue;
    }

    @Override
    public int getNumLabs() {
        return this.fLabInstances.size();
    }

    @Override
    public List<ProcessInstance> getLabInstances() {
        return new ArrayList<ProcessInstance>(this.fLabInstances);
    }

    public int getNumPending() {
        return this.fPendingQueue.size();
    }

    public boolean isRunningCommand() {
        return this.fLabsAreBusy.get();
    }

    @Override
    public synchronized void interrupt() {
        this.interrupt(null);
    }

    @Override
    public synchronized void interrupt(@Nullable LabsCompletionObserver labsCompletionObserver) {
        this.doInterrupt(labsCompletionObserver);
    }

    @Override
    public synchronized void interruptAndRemovePendingCommands() {
        this.interruptAndRemovePendingCommands(null);
    }

    @Override
    public synchronized void interruptAndRemovePendingCommands(@Nullable LabsCompletionObserver labsCompletionObserver) {
        this.fPendingQueue.clear();
        this.doInterrupt(labsCompletionObserver);
    }

    private void doInterrupt(final @Nullable LabsCompletionObserver labsCompletionObserver) {
        MInteractiveInterrupt mInteractiveInterrupt = new MInteractiveInterrupt();
        this.fLabsStateTracker.interruptStarting();
        if (labsCompletionObserver == null) {
            this.fOutGroup.sendTo(this.fLabInstances, (Message)mInteractiveInterrupt);
        } else {
            RoleMessageObserver roleMessageObserver = new RoleMessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                    if (returnMessage instanceof MInterruptResult) {
                        MInterruptResult mInterruptResult = (MInterruptResult)returnMessage;
                        labsCompletionObserver.handleExecStatus(mInterruptResult.getRawStatus(), processInstance);
                    }
                }

                @Override
                public void aborted(long l, ProcessInstance processInstance) {
                    labsCompletionObserver.handleLabAborted(processInstance);
                }

                @Override
                public void expectReturnsFrom(long l, List<ProcessInstance> list) {
                    labsCompletionObserver.handleLabList(list);
                }
            };
            this.fOutGroup.sendTo(this.fLabInstances, (ObservableMessage)mInteractiveInterrupt, roleMessageObserver);
        }
    }

    private void evalNextCommand() {
        if (!this.fPendingQueue.isEmpty()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Evaluating a pending command.");
            PendingCommand pendingCommand = this.fPendingQueue.remove(0);
            this.runCommand(pendingCommand.fCommand, pendingCommand.fObserver);
        }
    }

    private void runCommand(String string, @Nullable LabsCompletionObserver labsCompletionObserver) {
        assert (!this.fLabsAreBusy.get()) : "In runCommand while labs are busy.";
        MInteractiveEvalCommand mInteractiveEvalCommand = new MInteractiveEvalCommand(string);
        long l = mInteractiveEvalCommand.getSequenceNumber();
        this.fResultsHandler.setCurrentCommand(l, labsCompletionObserver);
        this.fLabsAreBusy.set(true);
        this.fLabsStateTracker.cmdStarting(l);
        RoleMessageObserver roleMessageObserver = new RoleMessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                LabsImpl.this.handleReturnMessage(returnMessage, processInstance);
            }

            @Override
            public void aborted(long l, ProcessInstance processInstance) {
                LabsImpl.this.handleWorkerAborted(l, processInstance);
            }

            @Override
            public void expectReturnsFrom(long l, List<ProcessInstance> list) {
                LabsImpl.this.handleExpectReturns(l, list);
            }
        };
        this.fOutGroup.sendTo(this.fLabInstances, (ObservableMessage)mInteractiveEvalCommand, roleMessageObserver);
    }

    private void handleReturnMessage(ReturnMessage returnMessage, ProcessInstance processInstance) {
        if (returnMessage instanceof CmdWinOutput) {
            CmdWinOutput cmdWinOutput = (CmdWinOutput)returnMessage;
            this.fResultsHandler.handleOutput(cmdWinOutput, processInstance);
        } else if (returnMessage instanceof CmdExecResults) {
            if (this.fResultsHandler == null) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Should not receive command execution results on the labs.");
                assert (false) : "Should not receive command execution results on the labs.";
            }
            CmdExecResults cmdExecResults = (CmdExecResults)returnMessage;
            this.fResultsHandler.handleExecStatus(cmdExecResults, processInstance);
        }
    }

    private void handleWorkerAborted(long l, ProcessInstance processInstance) {
        this.fResultsHandler.handleLabAborted(l, processInstance);
    }

    private void handleExpectReturns(long l, List<ProcessInstance> list) {
        this.fResultsHandler.handleExpectReturns(l, list);
    }

    private synchronized void onLabsAreIdle() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "LabsImpl informed us that labs became idle.");
        this.fLabsAreBusy.set(false);
        this.evalNextCommand();
    }

    @Override
    public synchronized void communicationLost(Instance instance, Throwable throwable) {
        ProcessInstance processInstance = this.fRoleMapping.instanceToRole(instance);
        this.fLabInstances.remove(processInstance);
        this.fLabsStateTracker.communicationLost(processInstance);
    }

    @Override
    public synchronized void communicationEstablished(Instance instance) {
        ProcessInstance processInstance = this.fRoleMapping.instanceToRole(instance);
        if (!this.fLabInstances.contains(processInstance)) {
            this.fLabInstances.add(processInstance);
            this.fLabsStateTracker.communicationEstablished(processInstance);
        }
    }

    private static final class PendingCommand {
        private final String fCommand;
        private final LabsCompletionObserver fObserver;

        PendingCommand(String string, LabsCompletionObserver labsCompletionObserver) {
            this.fCommand = string;
            this.fObserver = labsCompletionObserver;
        }
    }
}

