/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.RunCallableOnce;
import com.mathworks.toolbox.parallel.pctutil.concurrent.ObjectCountDownLatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class MultipleFinalReturnMessageObserver<T extends FinalReturnMessage>
implements RoleMessageObserver {
    private final ObjectCountDownLatch<ProcessInstance> fLatch;
    private final Map<ProcessInstance, T> fMessageMap;
    private final Class<T> fExpectedMessageClass;
    private final RunCallableOnce fRunOnAllCompleteOnce;

    MultipleFinalReturnMessageObserver(Class<T> clazz, List<ProcessInstance> list) {
        this(list, clazz);
    }

    protected MultipleFinalReturnMessageObserver(List<ProcessInstance> list, Class<T> clazz) {
        this.fLatch = new ObjectCountDownLatch(list);
        this.fMessageMap = Collections.synchronizedMap(new HashMap());
        this.fExpectedMessageClass = clazz;
        this.fRunOnAllCompleteOnce = new RunCallableOnce(new Runnable(){

            @Override
            public void run() {
                MultipleFinalReturnMessageObserver.this.onAllComplete();
            }
        });
    }

    protected void onAllComplete() {
    }

    @Override
    public synchronized void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
        if (this.fExpectedMessageClass.isInstance(returnMessage)) {
            this.fLatch.countDown((Object)processInstance);
            this.fMessageMap.put(processInstance, this.fExpectedMessageClass.cast(returnMessage));
            this.callOnAllCompletedIfAllReceived();
        }
    }

    private void callOnAllCompletedIfAllReceived() {
        if (this.fLatch.complete()) {
            this.fRunOnAllCompleteOnce.run();
        }
    }

    public boolean await(long l, TimeUnit timeUnit) {
        return this.fLatch.await(l, timeUnit);
    }

    public boolean allMessagesReceived() {
        return this.fLatch.complete();
    }

    public synchronized Collection<T> getReturnMessages() {
        return this.fMessageMap.values();
    }

    protected synchronized Collection<Map.Entry<ProcessInstance, T>> getSourcesAndReturnMessages() {
        return this.fMessageMap.entrySet();
    }
}

