/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.BufferTransferCommand;
import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.DependencyExistsException;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;

public final class NewFileDependencyCommand
extends BufferTransferCommand {
    private static final String ADD_COMMAND = "parallel.internal.apishared.AttachedFiles.addAttachedFileToPath";
    private transient File fClientFile;
    private final String fClientFileStr;
    private final String fRemoteName;

    public NewFileDependencyCommand(ByteBufferHandle byteBufferHandle, File file, String string) {
        super(byteBufferHandle);
        assert (file.isFile()) : "Must be constructed with a file.";
        this.fClientFile = file;
        this.fClientFileStr = file.getPath();
        this.fRemoteName = string;
    }

    private File createLocalFile(FileDependenciesAssistant fileDependenciesAssistant) throws IOException {
        if (fileDependenciesAssistant.dependencyExists(this.fClientFile)) {
            throw new DependencyExistsException(this.fClientFile.getPath() + " is already added as a FileDependency");
        }
        File file = new File(fileDependenciesAssistant.getDependencyDir(), FileUtils.convertToLocalSeparators(this.fRemoteName));
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewFileDependencyCommand: localFile: " + file);
        if (file.exists()) {
            throw new DependencyExistsException(file.getPath() + " appears to already exist");
        }
        FileUtils.createNewFileAndParent(file);
        if (!fileDependenciesAssistant.addDependency(this.fClientFile, file)) {
            throw new DependencyExistsException(this.fClientFile.getPath() + " : unexpectedly failed to add as a FileDependency");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, SessionService sessionService) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispatch of NewFileDependencyCommand for fClientFile: " + this.fClientFile + " with fRemoteName: " + this.fRemoteName);
        DependencyCommandResult dependencyCommandResult = new DependencyCommandResult(this.getSequenceNumber());
        try {
            assert (this.fBuffer != null) : "Input ByteBuffer was null";
            File file = this.createLocalFile(sessionService.getFileDependenciesAssistant());
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            matlabMCR.fevalNoOutput(ADD_COMMAND, new Object[]{file});
            this.writeBufferToFile(file);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during dispatch.", throwable);
            dependencyCommandResult.setException(throwable);
        }
        finally {
            if (this.fBuffer != null) {
                this.fBuffer.free();
            }
            returnGroup.returnTo(this.getSourceProcess(), (ReturnMessage)dependencyCommandResult);
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.fClientFile = new File(this.fClientFileStr);
        return this;
    }
}

