/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import java.util.Date;

public final class SessionInfo {
    private final String fProfileName;
    private final String fClusterType;
    private final SessionState fState;
    private final int fSessionSize;
    private final int fNumWorkersBusy;
    private final long fSessionIdleAt;
    private final long fIdleShutdownTimeout;
    private final String fError;
    private final boolean fRestartOnClusterChange;
    private final boolean fRestartOnPreferredNumWorkersChange;
    private static final String NO_CLUSTER_NAME = "";
    private static final String NO_CLUSTER_TYPE = "";
    private static final String NO_ERROR = "";
    private static final int WORKERS_NOT_BUSY = 0;
    private static final int UNKNOWN_CLUSTER_SIZE = -1;
    private static final long EMPTY_IDLE_TIME = -1L;
    private static final long NO_IDLE_SHUTDOWN_TIMEOUT = Integer.MAX_VALUE;
    private static final boolean NO_RESTART_ON_CLUSTER_CHANGE = false;
    private static final boolean NO_RESTART_ON_PREFERRED_NUM_WORKERS_CHANGE = false;
    private static final long INVALID_TIME_TO_SHUTDOWN = -1L;
    private static final long SHUTTING_DOWN_TIME_TO_SHUTDOWN = 0L;
    public static final SessionInfo NULL_SESSION_INFO = new SessionInfo("", "", SessionState.CLOSED, -1, -1L, Integer.MAX_VALUE, 0, "", false, false);

    static SessionInfo starting(String string, String string2, long l, boolean bl, boolean bl2) {
        return new SessionInfo(string, string2, SessionState.STARTING, -1, -1L, l, 0, "", bl, bl2);
    }

    static SessionInfo started(SessionInfo sessionInfo, int n) {
        assert (sessionInfo.getState().equals((Object)SessionState.STARTING)) : "The session state should have been starting. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before started. Found  " + sessionInfo.getError();
        long l = System.currentTimeMillis();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.IDLE, n, l, sessionInfo.getIdleShutdownTimeout(), 0, sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo failedToStart(SessionInfo sessionInfo, String string) {
        assert (sessionInfo.getState().equals((Object)SessionState.STARTING) || sessionInfo.equals(NULL_SESSION_INFO)) : "The session state should have been starting. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before failed to start. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.FAILED_TO_START, sessionInfo.getSize(), -1L, sessionInfo.getIdleShutdownTimeout(), 0, string, sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo busy(SessionInfo sessionInfo, int n) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been idle or busy. But found " + (Object)((Object)sessionInfo.getState());
        assert (n > 0) : "The number of workers should be greater than 0.";
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before busy. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.BUSY, sessionInfo.getSize(), -1L, sessionInfo.getIdleShutdownTimeout(), n, sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo idle(SessionInfo sessionInfo) {
        assert (sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been busy. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before idle. Found  " + sessionInfo.getError();
        long l = System.currentTimeMillis();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.IDLE, sessionInfo.getSize(), l, sessionInfo.getIdleShutdownTimeout(), 0, sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo sizeChanged(SessionInfo sessionInfo, int n) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been idle or busy. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before size changed. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), sessionInfo.getState(), n, sessionInfo.getSessionIdleAt(), sessionInfo.getIdleShutdownTimeout(), sessionInfo.getNumWorkersBusy(), sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo timeoutChanged(SessionInfo sessionInfo, long l) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been idle or busy. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before timeout changed. Found  " + sessionInfo.getError();
        long l2 = sessionInfo.getState().equals((Object)SessionState.IDLE) ? System.currentTimeMillis() : sessionInfo.getSessionIdleAt();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), sessionInfo.getState(), sessionInfo.getSize(), l2, l, sessionInfo.getNumWorkersBusy(), sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo restartOnClusterChanged(SessionInfo sessionInfo, boolean bl) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been idle or busy. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before timeout changed. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), sessionInfo.getState(), sessionInfo.getSize(), sessionInfo.getSessionIdleAt(), sessionInfo.getIdleShutdownTimeout(), sessionInfo.getNumWorkersBusy(), sessionInfo.getError(), bl, sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo resetIdleAtTime(SessionInfo sessionInfo) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE)) : "The session state should have been idle. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before idle. Found  " + sessionInfo.getError();
        long l = System.currentTimeMillis();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.IDLE, sessionInfo.getSize(), l, sessionInfo.getIdleShutdownTimeout(), 0, sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo close(SessionInfo sessionInfo) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been busy or idle. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before close. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.CLOSED, sessionInfo.getSize(), -1L, sessionInfo.getIdleShutdownTimeout(), 0, sessionInfo.getError(), sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    static SessionInfo closeDueToError(SessionInfo sessionInfo, String string) {
        assert (sessionInfo.getState().equals((Object)SessionState.IDLE) || sessionInfo.getState().equals((Object)SessionState.BUSY)) : "The session state should have been busy or idle. But found " + (Object)((Object)sessionInfo.getState());
        assert (sessionInfo.getError().isEmpty()) : "There should not be any errors before close with errors. Found  " + sessionInfo.getError();
        return new SessionInfo(sessionInfo.getClusterType(), sessionInfo.getProfileName(), SessionState.CLOSED, sessionInfo.getSize(), -1L, sessionInfo.getIdleShutdownTimeout(), 0, string, sessionInfo.getRestartOnClusterChange(), sessionInfo.getRestartOnPreferredNumWorkersChange());
    }

    private SessionInfo(String string, String string2, SessionState sessionState, int n, long l, long l2, int n2, String string3, boolean bl, boolean bl2) {
        this.fProfileName = string2;
        this.fClusterType = string;
        this.fState = sessionState;
        this.fSessionSize = n;
        this.fNumWorkersBusy = n2;
        this.fError = string3;
        this.fSessionIdleAt = l;
        this.fIdleShutdownTimeout = l2;
        this.fRestartOnClusterChange = bl;
        this.fRestartOnPreferredNumWorkersChange = bl2;
    }

    public String getProfileName() {
        return this.fProfileName;
    }

    public String getClusterType() {
        return this.fClusterType;
    }

    public SessionState getState() {
        return this.fState;
    }

    public int getSize() {
        return this.fSessionSize;
    }

    public int getNumWorkersBusy() {
        return this.fNumWorkersBusy;
    }

    public String getError() {
        return this.fError;
    }

    public long getIdleShutdownTimeout() {
        return this.fIdleShutdownTimeout;
    }

    public long getSessionIdleAt() {
        return this.fSessionIdleAt;
    }

    public long getRemainingSecondsBeforeShutdown() {
        switch (this.fState) {
            case IDLE: {
                Date date = new Date();
                if (this.fIdleShutdownTimeout == Long.MAX_VALUE) {
                    return Long.MAX_VALUE;
                }
                double d = (double)(date.getTime() - this.fSessionIdleAt) / 1000.0;
                long l = (long)((double)this.fIdleShutdownTimeout - d);
                return Math.max(l, 0L);
            }
            case STARTING: 
            case FAILED_TO_START: 
            case BUSY: 
            case CLOSED: {
                return -1L;
            }
        }
        assert (false) : "Unknown session state found " + (Object)((Object)this.fState);
        return -1L;
    }

    public boolean getRestartOnClusterChange() {
        return this.fRestartOnClusterChange;
    }

    public boolean getRestartOnPreferredNumWorkersChange() {
        return this.fRestartOnPreferredNumWorkersChange;
    }

    public static enum SessionState {
        STARTING,
        FAILED_TO_START,
        BUSY,
        IDLE,
        CLOSED;

    }
}

