/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.distcomp.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public final class TopologyGraph<V> {
    private static final int NO_NEXT_VERTEX = -1;
    private static final int INDEXOF_UNKNOWN_ELEMENT = -1;
    private final Map<V, Set<V>> fEdges = new HashMap<V, Set<V>>();
    private final List<V> fVertices = new ArrayList<V>();
    private double[][] fDistance = null;
    private int[][] fNext = null;
    private boolean fTablesValid = false;

    public synchronized void addVertices(Collection<V> collection) {
        this.fTablesValid = false;
        for (V v : collection) {
            if (!this.fVertices.contains(v)) {
                this.fVertices.add(v);
            }
            if (this.fEdges.containsKey(v)) continue;
            this.fEdges.put(v, new HashSet());
        }
    }

    public synchronized void removeVertices(Collection<V> collection) {
        this.fTablesValid = false;
        for (V v : collection) {
            this.fVertices.remove(v);
            this.fEdges.remove(v);
            for (Set<V> set : this.fEdges.values()) {
                set.remove(v);
            }
        }
    }

    public synchronized void addEdges(V v, Collection<V> collection) {
        this.fTablesValid = false;
        assert (this.fEdges.containsKey(v));
        this.fEdges.get(v).addAll(collection);
    }

    public synchronized List<V> getAllVertices() {
        return Collections.unmodifiableList(new ArrayList<V>(this.fVertices));
    }

    public Collection<V> mapNextHop(V v, Collection<V> collection) throws NoRouteException, NoVertexException {
        Pair<Collection<V>, Collection<V>> pair = this.mapNextHopWherePossible(v, collection);
        Collection<V> collection2 = pair.getSecond();
        if (!collection2.isEmpty()) {
            throw new NoRouteException(collection2.iterator().next());
        }
        return pair.getFirst();
    }

    public Pair<Collection<V>, Collection<V>> mapNextHopWherePossible(V v, Collection<V> collection) throws NoVertexException {
        if (!this.fVertices.contains(v)) {
            throw new NoVertexException(v);
        }
        if (!this.fVertices.containsAll(collection)) {
            HashSet<V> hashSet = new HashSet<V>(collection);
            hashSet.removeAll(this.fVertices);
            assert (!hashSet.isEmpty());
            throw new NoVertexException(hashSet.iterator().next());
        }
        HashSet<V> hashSet = new HashSet<V>();
        HashSet<V> hashSet2 = new HashSet<V>();
        for (V v2 : collection) {
            V v3 = this.findNext(v, v2);
            Log.LOGGER.fine("TopologyGraph: mapped " + v2 + " to " + v3);
            if (v3 == null) {
                hashSet2.add(v);
                continue;
            }
            hashSet.add(v3);
        }
        return new Pair<Collection<V>, Collection<V>>(hashSet, hashSet2);
    }

    public synchronized double getDistance(V v, V v2) throws NoVertexException {
        this.updateDistances();
        int n = this.fVertices.indexOf(v);
        int n2 = this.fVertices.indexOf(v2);
        if (n == -1) {
            throw new NoVertexException(v);
        }
        if (n2 == -1) {
            throw new NoVertexException(v2);
        }
        return this.fDistance[n][n2];
    }

    private synchronized V findNext(V v, V v2) throws NoVertexException {
        this.updateDistances();
        int n = this.fVertices.indexOf(v);
        int n2 = this.fVertices.indexOf(v2);
        if (n2 == -1) {
            throw new NoVertexException(v2);
        }
        int n3 = n2;
        while (this.fDistance[n][n3] > 1.0) {
            int n4 = this.fNext[n][n3];
            if (n4 == -1) {
                Log.LOGGER.warning("TopologyGraph.findNext: no route from " + v + " to " + v2);
                return null;
            }
            n3 = n4;
        }
        if (this.fNext[n][n2] != n3) {
            Log.LOGGER.finer("Updating fNext[" + n + "][" + n2 + "]: " + n3);
            this.fNext[n][n2] = n3;
        }
        return this.fVertices.get(n3);
    }

    private synchronized void updateDistances() {
        if (!this.fTablesValid) {
            int n;
            int n2 = this.fVertices.size();
            this.fDistance = new double[n2][n2];
            this.fNext = new int[n2][n2];
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    this.fDistance[n][i] = n == i ? 0.0 : Double.POSITIVE_INFINITY;
                    this.fNext[n][i] = n == i ? n : -1;
                }
            }
            for (n = 0; n < n2; ++n) {
                Set<V> set = this.fEdges.get(this.fVertices.get(n));
                for (V v : set) {
                    int n3 = this.fVertices.indexOf(v);
                    this.fDistance[n][n3] = 1.0;
                    this.fDistance[n3][n] = 1.0;
                    this.fNext[n][n3] = n3;
                    this.fNext[n3][n] = n;
                }
            }
            this.logDistanceTable();
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        if (!(this.fDistance[i][n] + this.fDistance[n][j] < this.fDistance[i][j])) continue;
                        this.fDistance[i][j] = this.fDistance[i][n] + this.fDistance[n][j];
                        this.fNext[i][j] = n;
                    }
                }
            }
            this.logDistanceTable();
            this.fTablesValid = true;
        }
    }

    private void logDistanceTable() {
        Level level = Level.FINE;
        if (Log.LOGGER.isLoggable(level)) {
            Log.LOGGER.log(level, "Routing Table:\n\n" + this.getDistanceTableAsString());
        }
    }

    private String getDistanceTableAsString() {
        int n = this.fVertices.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("Row[").append(this.fVertices.get(i)).append("]: ");
            for (int j = 0; j < n; ++j) {
                stringBuilder.append("(").append(this.fDistance[i][j]).append(", ").append(this.fNext[i][j]).append("), ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static class NoVertexException
    extends Exception {
        private <V> NoVertexException(V v) {
            super("No such vertex: " + v);
        }
    }

    public static class NoRouteException
    extends Exception {
        private <V> NoRouteException(V v) {
            super("No route to vertex: " + v);
        }
    }
}

