/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.matlabpool.attachedfiles;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplication;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.toolbox.distcomp.pmode.matlabpool.attachedfiles.Log;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EditorListener {
    private final String UPDATE_FILES_FUNCTION = "parallel.internal.pool.maybeUpdateAttachedFiles";
    private final Map<Editor, EditorEventListener> fEditorListenerMap = new HashMap<Editor, EditorEventListener>();
    private EditorApplicationListener fEditorAppListener;

    public void register() {
        EditorApplication editorApplication = MLEditorServices.getEditorApplication();
        List list = editorApplication.getOpenEditors();
        for (Editor editor : list) {
            this.listenToDirtyEditor(editor);
        }
        this.fEditorAppListener = new EditorOpenedListener();
        editorApplication.addEditorApplicationListener(this.fEditorAppListener);
    }

    public void unregister() {
        HashMap<Editor, EditorEventListener> hashMap = new HashMap<Editor, EditorEventListener>(this.fEditorListenerMap);
        for (Editor editor : hashMap.keySet()) {
            this.removeEditorListener(editor);
        }
        if (this.fEditorAppListener != null) {
            EditorApplication editorApplication = MLEditorServices.getEditorApplication();
            editorApplication.removeEditorApplicationListener(this.fEditorAppListener);
            this.fEditorAppListener = null;
        }
    }

    private void listenToDirtyEditor(Editor editor) {
        Log.LOGGER.log(DistcompLevel.FOUR, "EditorListener: adding listener for: " + editor.getLongName());
        DirtyEditorListener dirtyEditorListener = new DirtyEditorListener(editor);
        editor.addEventListener((EditorEventListener)dirtyEditorListener);
        this.fEditorListenerMap.put(editor, dirtyEditorListener);
    }

    private void removeEditorListener(Editor editor) {
        if (this.fEditorListenerMap.containsKey(editor)) {
            Log.LOGGER.log(DistcompLevel.FOUR, "EditorListener: removing listener for: " + editor.getLongName());
            editor.removeEventListener(this.fEditorListenerMap.get(editor));
            this.fEditorListenerMap.remove(editor);
        }
    }

    private final class EditorOpenedListener
    implements EditorApplicationListener {
        private EditorOpenedListener() {
        }

        public void editorOpened(Editor editor) {
            EditorListener.this.listenToDirtyEditor(editor);
        }

        public void editorClosed(Editor editor) {
            EditorListener.this.removeEditorListener(editor);
        }
    }

    private final class DirtyEditorListener
    implements EditorEventListener {
        final Editor fEditor;

        public DirtyEditorListener(Editor editor) {
            this.fEditor = editor;
        }

        public void eventOccurred(EditorEvent editorEvent) {
            StorageLocation storageLocation;
            if (editorEvent.equals((Object)EditorEvent.DIRTY_STATE_CHANGED) && !this.fEditor.isDirty() && (storageLocation = this.fEditor.getStorageLocation()) instanceof FileStorageLocation) {
                try {
                    String string = ((FileStorageLocation)storageLocation).getFile().getCanonicalPath();
                    Log.LOGGER.log(DistcompLevel.FOUR, "EditorListener: file " + string + " has changed.");
                    MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
                    matlabMCR.fevalNoOutput("parallel.internal.pool.maybeUpdateAttachedFiles", new Object[]{string});
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(DistcompLevel.ONE, "Failed to get filename from editor.");
                }
            }
        }
    }
}

