/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.matlabpool.sessions;

import com.mathworks.toolbox.distcomp.pmode.FatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.NonFatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.SessionFactory;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.matlabpool.sessions.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.KeepAlive;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ConnectionManager;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionServicesFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionStartupFailedException;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorkerSessionBuilder {
    private WorkerSessionBuilder() {
    }

    private static Future<SessionService> initiate(WorkerSessionBuilderTask workerSessionBuilderTask) {
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)"WorkerSessionBuilder.initiate-lab", (Logger)Log.LOGGER));
        Future<SessionService> future = executorService.submit(workerSessionBuilderTask);
        executorService.shutdown();
        return future;
    }

    public static Future<SessionService> initiatePlain(ConnectionManager.Connector connector, int n) {
        return WorkerSessionBuilder.initiate(new WorkerConnectsOnlyToClientTask(connector, n));
    }

    public static Future<SessionService> initiateProxyingWorker(ConnectionManager.Connector connector, int n, MatlabPoolPeerInstance matlabPoolPeerInstance, ConnectionManager.Acceptor acceptor, boolean bl) {
        return WorkerSessionBuilder.initiate(new WorkerAcceptsAndThenConnectsTask(connector, n, matlabPoolPeerInstance, acceptor, bl));
    }

    public static Future<SessionService> initiateProxiedWorker(ConnectionManager.Connector connector, int n, MatlabPoolPeerInstance matlabPoolPeerInstance, ConnectInfo connectInfo) {
        return WorkerSessionBuilder.initiate(new WorkerConnectsOnlyToLabOneTask(connector, n, matlabPoolPeerInstance, connectInfo));
    }

    private static class BrittleWorkersServicesFactory
    implements SessionServicesFactory {
        private final Instance fClientInstance;

        private BrittleWorkersServicesFactory(Instance instance) {
            this.fClientInstance = instance;
        }

        @Override
        public SessionErrorHandler buildErrorHandler(SessionRoleMapping sessionRoleMapping) {
            boolean bl = false;
            return new FatalErrorHandler(bl);
        }

        @Override
        public KeepAlive buildKeepAlive(OutputGroup outputGroup) {
            return new KeepAlive(outputGroup, Collections.singletonList(this.fClientInstance));
        }

        @Override
        public ParforController.Factory getParforControllerFactory() {
            throw new IllegalStateException("Cannot getParforControllerFactory on a worker.");
        }
    }

    private static final class WorkerConnectsOnlyToClientTask
    extends WorkerSessionBuilderTask {
        private Instance fClientInstance;

        private WorkerConnectsOnlyToClientTask(ConnectionManager.Connector connector, int n) {
            super(connector, n);
        }

        @Override
        protected List<Connection> buildConnections() throws InterruptedException, PeerMessagingException {
            long l = 10L * (long)this.getWorkerIndex();
            Thread.sleep(l);
            Connection connection = this.connectToClient();
            this.fClientInstance = connection.getRemoteInstance();
            return Collections.singletonList(connection);
        }

        @Override
        protected SessionServicesFactory buildSessionServicesFactory() {
            return new BrittleWorkersServicesFactory(this.fClientInstance);
        }
    }

    private static class ProxiedWorkersServicesFactory
    implements SessionServicesFactory {
        private final List<Instance> fInitialConnections;
        private final List<Instance> fTreatAsFatalConnections;

        private ProxiedWorkersServicesFactory(List<Instance> list, List<Instance> list2) {
            this.fInitialConnections = new ArrayList<Instance>(list);
            this.fTreatAsFatalConnections = new ArrayList<Instance>(list2);
        }

        @Override
        public SessionErrorHandler buildErrorHandler(SessionRoleMapping sessionRoleMapping) {
            boolean bl = false;
            return new NonFatalErrorHandler(bl, sessionRoleMapping, this.fInitialConnections, this.fTreatAsFatalConnections);
        }

        @Override
        public KeepAlive buildKeepAlive(OutputGroup outputGroup) {
            return new KeepAlive(outputGroup, this.fInitialConnections);
        }

        @Override
        public ParforController.Factory getParforControllerFactory() {
            throw new IllegalStateException("Cannot getParforControllerFactory on a worker.");
        }
    }

    private static final class WorkerConnectsOnlyToLabOneTask
    extends WorkerSessionBuilderTask {
        private final ProcessInstance fLabOneProcess;
        private final Instance fLabOneInstance;

        private WorkerConnectsOnlyToLabOneTask(ConnectionManager.Connector connector, int n, MatlabPoolPeerInstance matlabPoolPeerInstance, ConnectInfo connectInfo) {
            super(connector, n);
            this.fLabOneProcess = ProcessInstance.getLabInstance(matlabPoolPeerInstance.getLabIndex());
            connector.registerConnectInfo(connectInfo, this.fLabOneProcess);
            this.fLabOneInstance = matlabPoolPeerInstance;
        }

        @Override
        protected List<Connection> buildConnections() throws InterruptedException, PeerMessagingException {
            return Collections.singletonList(this.getConnector().activelyConnectTo(this.fLabOneProcess));
        }

        @Override
        protected SessionServicesFactory buildSessionServicesFactory() {
            List<Instance> list = Collections.singletonList(this.fLabOneInstance);
            return new ProxiedWorkersServicesFactory(list, list);
        }
    }

    private static final class WorkerAcceptsAndThenConnectsTask
    extends WorkerSessionBuilderTask {
        private final MatlabPoolPeerInstance fLabOneInstance;
        private final ConnectionManager.Acceptor fAcceptor;
        private final List<Instance> fConnectedWorkers = new ArrayList<Instance>();
        private final boolean fSpmdEnabled;
        private Instance fClientInstance;

        private WorkerAcceptsAndThenConnectsTask(ConnectionManager.Connector connector, int n, MatlabPoolPeerInstance matlabPoolPeerInstance, ConnectionManager.Acceptor acceptor, boolean bl) {
            super(connector, n);
            this.fLabOneInstance = matlabPoolPeerInstance;
            this.fAcceptor = acceptor;
            this.fSpmdEnabled = bl;
        }

        @Override
        protected List<Connection> buildConnections() throws InterruptedException, PeerMessagingException {
            int n = this.fLabOneInstance.getNumberOfLabs() - 1;
            ArrayList<Connection> arrayList = new ArrayList<Connection>(1 + n);
            for (int i = 0; i < n; ++i) {
                Connection connection = this.fAcceptor.activelyAccept();
                arrayList.add(connection);
                this.fConnectedWorkers.add(connection.getRemoteInstance());
            }
            Connection connection = this.connectToClient();
            arrayList.add(connection);
            this.fClientInstance = connection.getRemoteInstance();
            return arrayList;
        }

        @Override
        protected SessionServicesFactory buildSessionServicesFactory() {
            ArrayList<Instance> arrayList = new ArrayList<Instance>(this.fConnectedWorkers);
            arrayList.add(this.fClientInstance);
            if (this.fSpmdEnabled) {
                return new ProxiedWorkersServicesFactory(arrayList, arrayList);
            }
            List<Instance> list = Collections.singletonList(this.fClientInstance);
            return new ProxiedWorkersServicesFactory(arrayList, list);
        }
    }

    private static abstract class WorkerSessionBuilderTask
    implements Callable<SessionService> {
        private final ConnectionManager.Connector fConnector;
        private final int fWorkerIndex;

        protected ConnectionManager.Connector getConnector() {
            return this.fConnector;
        }

        protected int getWorkerIndex() {
            return this.fWorkerIndex;
        }

        protected WorkerSessionBuilderTask(ConnectionManager.Connector connector, int n) {
            this.fConnector = connector;
            this.fWorkerIndex = n;
        }

        protected Connection connectToClient() throws PeerMessagingException, InterruptedException {
            ProcessInstance processInstance = ProcessInstance.getClientInstance();
            return this.fConnector.activelyConnectTo(processInstance);
        }

        protected abstract List<Connection> buildConnections() throws InterruptedException, PeerMessagingException;

        protected abstract SessionServicesFactory buildSessionServicesFactory();

        @Override
        public final SessionService call() throws PeerMessagingException, InterruptedException, SessionStartupFailedException {
            try {
                List<Connection> list = this.buildConnections();
                SessionService sessionService = SessionFactory.createLabSession(this.buildSessionServicesFactory(), list, this.fWorkerIndex, this.fConnector.getLocalInstance());
                return sessionService;
            }
            catch (PeerMessagingException | InterruptedException exception) {
                Log.LOGGER.log(Level.SEVERE, "Caught an exception during WorkerSessionBuilderTask.call()", exception);
                throw exception;
            }
            finally {
                this.fConnector.close();
            }
        }
    }
}

