/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnector;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.Log;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolConnector;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class MatlabPoolBrokeredConnector
extends MatlabPoolConnector {
    private final BrokeredConnector fBrokeredConnector;
    private final MatlabPoolPeerInstance fLocalPeer;
    private final String fHostname;
    private Map<ProcessInstance, ConnectInfo> fProcessInstancesToConnectInfos;
    private final UUID fGroupUUID;

    MatlabPoolBrokeredConnector(MatlabPoolPeerInstance matlabPoolPeerInstance, String string, UUID uUID, int n) throws PeerMessagingException {
        super(matlabPoolPeerInstance);
        this.fLocalPeer = matlabPoolPeerInstance;
        this.fGroupUUID = uUID;
        this.fHostname = string;
        this.fBrokeredConnector = new BrokeredConnector(matlabPoolPeerInstance, n);
        this.fProcessInstancesToConnectInfos = new HashMap<ProcessInstance, ConnectInfo>();
        Log.LOGGER.log(DistcompLevel.THREE, "ConnectionManager (" + this.fGroupUUID + ") constructed.");
    }

    @Override
    void registerConnectInfo(ConnectInfo connectInfo, ProcessInstance processInstance) {
        ProcessInstance processInstance2 = ProcessInstance.getClientInstance();
        String string = System.getenv("MDCE_OVERRIDE_CLIENT_HOST");
        if (processInstance.equals(processInstance2) && string != null && !string.isEmpty() && connectInfo instanceof ServerSocketConnectInfo && ((ServerSocketConnectInfo)connectInfo).getSocketAddress() != null) {
            ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)connectInfo;
            InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
            Log.LOGGER.log(DistcompLevel.THREE, "Using overriding client hostname: " + string + " to override " + inetSocketAddress);
            InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, inetSocketAddress.getPort());
            ServerSocketConnectInfo serverSocketConnectInfo2 = serverSocketConnectInfo.createCopyReplaceSocket(inetSocketAddress2);
            this.fProcessInstancesToConnectInfos.put(processInstance2, serverSocketConnectInfo2);
        } else {
            this.fProcessInstancesToConnectInfos.put(processInstance, connectInfo);
        }
    }

    @Override
    Connection activelyConnectTo(ProcessInstance processInstance) throws InterruptedException, PeerMessagingException {
        if (!this.fProcessInstancesToConnectInfos.containsKey(processInstance)) {
            assert (false) : "No address for: " + processInstance;
            return null;
        }
        ConnectInfo connectInfo = this.fProcessInstancesToConnectInfos.get(processInstance);
        if (connectInfo instanceof BrokeredSocketConnectInfo) {
            BrokeredSocketConnectInfo brokeredSocketConnectInfo = (BrokeredSocketConnectInfo)connectInfo;
            return this.fBrokeredConnector.activelyConnectTo(brokeredSocketConnectInfo, this.fHostname);
        }
        throw new IllegalArgumentException("Does not understand how to connect using a " + connectInfo.getClass());
    }

    @Override
    void close() {
    }

    public String toString() {
        return "MatlabPoolBrokeredConnector{, fBrokeredConnector=" + this.fBrokeredConnector + ", fLocalPeer=" + this.fLocalPeer + ", fProcessInstancesToConnectInfos.size()=" + this.fProcessInstancesToConnectInfos.size() + ", fGroupUUID=" + this.fGroupUUID + '}';
    }
}

