/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.SSLConnection;
import com.mathworks.toolbox.distcomp.util.securesocket.SSLSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public final class SSLConnectionFactory
implements ConnectionFactory {
    private final SSLContext fSSLContext;
    private final boolean fUseClientMode;

    public SSLConnectionFactory(SSLContext sSLContext, boolean bl) {
        if (sSLContext == null) {
            throw new IllegalArgumentException("sslContext cannot be null.");
        }
        this.fSSLContext = sSLContext;
        this.fUseClientMode = bl;
    }

    @Override
    public Connection createConnection(SocketChannel socketChannel, Instance instance, JoinInfo joinInfo, boolean bl) throws HandShake.HandShakeException {
        SSLEngine sSLEngine = this.fSSLContext.createSSLEngine();
        sSLEngine.setUseClientMode(this.fUseClientMode);
        SSLSocketChannel sSLSocketChannel = new SSLSocketChannel(socketChannel, sSLEngine);
        HandShake handShake = new HandShake();
        long l = joinInfo.getHandShakeDeadline();
        Instance instance2 = this.fUseClientMode ? handShake.connectHandShake(sSLSocketChannel, instance, l) : handShake.acceptHandShake(sSLSocketChannel, instance, l);
        return new SSLConnection(sSLSocketChannel, instance2, joinInfo);
    }
}

