/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsResponseVector;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferError;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitor;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.List;

class TransferLabsCompletionObserver
implements LabsCompletionObserver {
    private final TransferMonitor fMonitor;
    private final long fTransferSeqNumber;
    private final ProcessInstance fSrcID;
    private String fCmdWinOutput;
    private LabsResponseVector<ProcessInstance> fResponses;
    private boolean fWasInterrupted;
    private boolean fFailed;

    TransferLabsCompletionObserver(long l, ProcessInstance processInstance, TransferMonitor transferMonitor) {
        this.fTransferSeqNumber = l;
        this.fSrcID = processInstance;
        this.fMonitor = transferMonitor;
        this.fCmdWinOutput = "";
    }

    @Override
    public synchronized void handleLabList(List<ProcessInstance> list) {
        this.fResponses = new LabsResponseVector<ProcessInstance>(list);
    }

    @Override
    public synchronized void handleOutput(String string, ProcessInstance processInstance) {
        if (processInstance.equals(this.fSrcID) && string != null) {
            this.fCmdWinOutput = this.fCmdWinOutput + string;
        }
    }

    @Override
    public synchronized void handleExecStatus(int n, ProcessInstance processInstance) {
        this.fResponses.receivedResponse(processInstance);
        switch (Matlab.getExecutionStatus((int)n)) {
            case 0: {
                break;
            }
            case 4: {
                this.fWasInterrupted = true;
                break;
            }
            default: {
                this.fFailed = true;
            }
        }
        if (this.fResponses.hasAllResponses()) {
            this.completed();
        }
    }

    @Override
    public synchronized void handleLabAborted(ProcessInstance processInstance) {
        this.fResponses.receivedResponse(processInstance);
        if (this.fResponses.hasAllResponses()) {
            this.completed();
        }
    }

    private void completed() {
        if (this.fWasInterrupted) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Labs were interrupted during the transfer.");
            this.fMonitor.setOutsideLocalMError(TransferError.getLabsInterruptedError(this.fTransferSeqNumber));
        } else if (this.fFailed) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Labs completed transfer command earlier than expected.");
            this.fMonitor.setOutsideLocalMError(TransferError.getLabsUnexpectedError(this.fTransferSeqNumber, this.fSrcID, this.fCmdWinOutput));
        } else {
            this.fMonitor.setRemoteFinished();
        }
    }
}

