/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.transfer.DataTransfer;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCommand;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCompletedListener;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferDataItem;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferError;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferFinished;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferManager;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitor;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitorAndStarter;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitorAndStarterImpl;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferMonitorImpl;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferReady;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.ExecutorService;

class TransferManagerImpl
implements TransferManager {
    private final RoleOutputGroup fOutGroup;
    private final ExecutorService fListenerExec;
    private final ErrorHandler fErrorHandler;
    private DataTransfer fCurrTransfer;
    private TransferMonitor fCurrMonitor;
    private ProcessInstance fCurrDestID;
    private long fTransferSeqNumber;
    private TransferError fStoredError;
    private boolean fWaitForLabsObserver;

    TransferManagerImpl(SessionService sessionService, RoleOutputGroup roleOutputGroup) {
        this.fOutGroup = roleOutputGroup;
        this.fListenerExec = sessionService.getListenerExecutor();
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fCurrDestID = null;
        this.fTransferSeqNumber = -1L;
        this.fWaitForLabsObserver = false;
        this.fStoredError = null;
    }

    @Override
    public synchronized TransferMonitorAndStarter initiateTransfer(DataTransfer dataTransfer, int n, boolean bl) {
        assert (1 <= n);
        this.fCurrTransfer = dataTransfer;
        this.fCurrDestID = ProcessInstance.getLabInstance(n);
        assert (this.fOutGroup.getConnectedProcessInstances().contains(this.fCurrDestID));
        this.fWaitForLabsObserver = true;
        ++this.fTransferSeqNumber;
        TransferMonitorAndStarterImpl transferMonitorAndStarterImpl = new TransferMonitorAndStarterImpl(this.fListenerExec, this.fErrorHandler, this.fTransferSeqNumber, this.fOutGroup, this.fCurrDestID, this.getCompletedListener());
        this.fCurrMonitor = transferMonitorAndStarterImpl;
        if (!bl) {
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            matlabMCR.eval("", (CompletionObserver)new TransferCompletionObserver(this.fCurrMonitor));
        }
        this.fCurrTransfer.prepareForTransfer(this.fTransferSeqNumber, this.fCurrDestID);
        this.handleStoredErrorsWhenStartingTransfer();
        return transferMonitorAndStarterImpl;
    }

    @Override
    public synchronized TransferMonitor respondToTransferInitiation(DataTransfer dataTransfer, long l) {
        this.fCurrTransfer = dataTransfer;
        this.fCurrDestID = ProcessInstance.getClientInstance();
        this.fWaitForLabsObserver = false;
        this.fTransferSeqNumber = l;
        this.fCurrMonitor = new TransferMonitorImpl(this.fListenerExec, this.fErrorHandler, this.fTransferSeqNumber, this.fOutGroup, this.fCurrDestID, this.getCompletedListener());
        this.fCurrTransfer.prepareForTransfer(this.fTransferSeqNumber, this.fCurrDestID);
        this.handleStoredErrorsWhenStartingTransfer();
        return this.fCurrMonitor;
    }

    @Override
    public synchronized void dispatch(TransferCommand transferCommand, ProcessInstance processInstance) {
        boolean bl;
        boolean bl2 = bl = transferCommand.getTransferSeqNumber() == this.fTransferSeqNumber;
        if (!this.isTransferInProgress()) {
            this.handleCommandsWhileIdle(transferCommand);
            return;
        }
        if (!bl) {
            this.handleIncorrectSeqNumber(transferCommand);
            return;
        }
        this.assertSeqNumber(transferCommand.getTransferSeqNumber());
        if (transferCommand instanceof TransferDataItem) {
            TransferDataItem transferDataItem = (TransferDataItem)transferCommand;
            this.fCurrTransfer.dispatch(transferDataItem, processInstance);
        } else if (transferCommand instanceof TransferReady) {
            this.fCurrMonitor.setRemoteReady();
        } else if (transferCommand instanceof TransferFinished) {
            if (this.fWaitForLabsObserver) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Dropping TransferFinished packet.");
            } else {
                this.fCurrMonitor.setRemoteFinished();
            }
        } else if (transferCommand instanceof TransferError) {
            TransferError transferError = (TransferError)transferCommand;
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Received a TransferError.  Error ID: " + transferError.getErrorIdentifier() + ".  Error message: " + transferError.getErrorMessage() + ".");
            this.fCurrMonitor.setOutsideLocalMError(transferError);
        } else {
            String string = TransferManagerImpl.sMsgUnexpectedTransferCommand(transferCommand);
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
            assert (false) : string;
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.fCurrMonitor != null) {
            this.fCurrMonitor.setOutsideLocalMError(TransferError.getSessionDestroyedError(this.fTransferSeqNumber));
        }
        this.reset();
    }

    private boolean isTransferInProgress() {
        assert (this.fCurrTransfer == null == (this.fCurrMonitor == null)) : "Objects should either both be null or both be non-null.";
        return this.fCurrTransfer != null || this.fCurrMonitor != null;
    }

    private void handleCommandsWhileIdle(TransferCommand transferCommand) {
        assert (!this.isTransferInProgress());
        if (transferCommand instanceof TransferError) {
            this.fStoredError = (TransferError)transferCommand;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Storing a TransferError while idle.");
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "No transfer currently in progress.  Dropping transfer object " + transferCommand.getClass().getName() + " with transfer sequence number" + transferCommand.getTransferSeqNumber());
        }
    }

    private void handleIncorrectSeqNumber(TransferCommand transferCommand) {
        assert (this.isTransferInProgress());
        assert (transferCommand.getTransferSeqNumber() != this.fTransferSeqNumber);
        if (transferCommand.getTransferSeqNumber() < this.fTransferSeqNumber) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Dropping transfer object " + transferCommand.getTransferSeqNumber());
        }
        if (transferCommand.getTransferSeqNumber() > this.fTransferSeqNumber) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Received transfer object " + transferCommand.getTransferSeqNumber() + ".  Cancelling current transfer.");
            this.fCurrMonitor.setOutsideLocalMError(TransferError.getRemoteIsAhead(this.fTransferSeqNumber));
        }
    }

    private synchronized void onCompleted(long l) {
        if (this.fTransferSeqNumber == l) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Notified of completion of current transfer.");
            this.reset();
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Dropping notification of completion of transfer " + l);
        }
    }

    private void reset() {
        this.fCurrTransfer = null;
        this.fCurrMonitor = null;
    }

    private TransferCompletedListener getCompletedListener() {
        return new TransferCompletedListener(){

            @Override
            public void transferCompleted(long l) {
                TransferManagerImpl.this.onCompleted(l);
            }
        };
    }

    private void handleStoredErrorsWhenStartingTransfer() {
        assert (this.isTransferInProgress());
        if (this.fStoredError == null) {
            return;
        }
        if (this.fStoredError.getTransferSeqNumber() < this.fTransferSeqNumber) {
            this.fStoredError = null;
        } else if (this.fStoredError.getTransferSeqNumber() == this.fTransferSeqNumber) {
            this.fCurrMonitor.setOutsideLocalMError(this.fStoredError);
            this.fStoredError = null;
        } else {
            assert (this.fStoredError.getTransferSeqNumber() > this.fTransferSeqNumber);
            this.fCurrMonitor.setOutsideLocalMError(TransferError.getTransferAlreadyCancelled(this.fTransferSeqNumber));
        }
    }

    private void assertSeqNumber(long l) {
        assert (this.fTransferSeqNumber == l) : "Invalid Transfer sequence number. Was " + l + ". Expected " + this.fTransferSeqNumber + ".";
    }

    private static String sMsgUnexpectedTransferCommand(TransferCommand transferCommand) {
        return "Received unexpected transfer object of type " + transferCommand.getClass().getName() + " with transfer sequence number " + transferCommand.getTransferSeqNumber() + ".";
    }
}

