/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.CopyCommand;
import java.io.File;
import java.util.Collections;
import java.util.Set;

public final class CopyToRemoteCommand
implements CopyCommand {
    private final File fLocalFile;
    private final String fRemoteFile;
    private final Set<File> fExcludedFiles;

    public CopyToRemoteCommand(File file, String string, Set<File> set) {
        this.fLocalFile = file;
        this.fRemoteFile = string;
        this.fExcludedFiles = set;
    }

    public CopyToRemoteCommand(File file, String string) {
        this(file, string, Collections.emptySet());
    }

    @Override
    public File getLocalFile() {
        return this.fLocalFile;
    }

    @Override
    public String getRemoteFile() {
        return this.fRemoteFile;
    }

    public boolean isExcluded(File file) {
        if (this.fExcludedFiles.contains(file)) {
            return true;
        }
        String string = file.getAbsolutePath();
        int n = string.length();
        for (File file2 : this.fExcludedFiles) {
            String string2 = file2.getAbsolutePath();
            int n2 = string2.length();
            if (n <= n2 || string.indexOf(string2) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean anyFilesExcluded() {
        return !this.fExcludedFiles.isEmpty();
    }
}

