/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterNotAllowedException;
import com.mathworks.toolbox.distcomp.remote.RequiredParameterMissingException;
import java.util.Set;

public class CredentialParameter
extends ParameterImpl<Credential> {
    private final Set<CredentialDescription> fPossibleCredentialDescriptions;
    private final CredentialDescription fDefaultCredentialDescription;

    public CredentialParameter(Parameter.PersistentKey persistentKey, Set<CredentialDescription> set, CredentialDescription credentialDescription) {
        super(persistentKey, true, Credential.class);
        this.fPossibleCredentialDescriptions = set;
        this.fDefaultCredentialDescription = credentialDescription;
    }

    public Set<CredentialDescription> getPossibleCredentialDescriptions() {
        return this.fPossibleCredentialDescriptions;
    }

    public CredentialDescription getDefaultCredentialDescription() {
        return this.fDefaultCredentialDescription;
    }

    @Override
    public void checkValueImpl(Credential credential) throws InvalidValueException {
        if (!this.fPossibleCredentialDescriptions.contains(credential.getCredentialDescription())) assert (false) : "The credential parameter " + credential + " contains an incorrect credential description. The credential description is " + credential.getCredentialDescription();
        try {
            credential.getParameterMap().checkParameters(credential.getCredentialDescription().getParameterSet());
        }
        catch (ParameterNotAllowedException parameterNotAllowedException) {
            throw new CredentialNotAllowedException(credential, parameterNotAllowedException);
        }
        catch (RequiredParameterMissingException requiredParameterMissingException) {
            throw new RequiredCredentialMissingException(requiredParameterMissingException);
        }
    }

    @Override
    protected String getSimpleName() {
        return CredentialParameter.class.getSimpleName();
    }

    private static final class RequiredCredentialMissingException
    extends InvalidValueException {
        RequiredCredentialMissingException(RequiredParameterMissingException requiredParameterMissingException) {
            super(requiredParameterMissingException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.RequiredCredentialMissing();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.RequiredCredentialMissing();
        }
    }

    private static final class CredentialNotAllowedException
    extends InvalidValueException {
        private final Credential fValueToCheck;

        CredentialNotAllowedException(Credential credential, ParameterNotAllowedException parameterNotAllowedException) {
            super(parameterNotAllowedException);
            this.fValueToCheck = credential;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CredentialNotAllowed(this.fValueToCheck.getCredentialDescription().toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CredentialNotAllowed(this.fValueToCheck.getCredentialDescription().toString(), this.getCause().getLocalizedMessage());
        }
    }
}

