/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.NoCommonProtocolSetException;
import com.mathworks.toolbox.distcomp.remote.NoMatchingProtocolOptionsException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import com.mathworks.toolbox.distcomp.remote.spi.Protocol;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public final class FutureMonitor {
    private final Lock fLock = new ReentrantLock();
    private final Map<String, Future> fHostsToFutures = new HashMap<String, Future>();
    private final Map<String, RemoteExecutionException> fHostsToExceptions = new HashMap<String, RemoteExecutionException>();
    private final FutureMonitorCallback fCallback;
    private static final int COMPLETION_CHECK_DELAY = 100;
    private static final int MAX_STARTER_POOL_SIZE = 8;

    public FutureMonitor(Command command, Set<String> set, ParameterMap parameterMap, Protocol protocol) throws InterruptedException {
        this(command, set, parameterMap, protocol, (FutureMonitorCallback)NoOpCallback.INSTANCE);
    }

    public FutureMonitor(Command command, Set<String> set, ParameterMap parameterMap, PathUtils.PlatformType platformType, FutureMonitorCallback futureMonitorCallback) throws NoCommonProtocolSetException, NoMatchingProtocolOptionsException, InterruptedException {
        this(command, set, parameterMap, RemoteExecutor.selectProtocol(command.getClass(), platformType), futureMonitorCallback);
    }

    public FutureMonitor(Command command, Set<String> set, ParameterMap parameterMap, Protocol protocol, FutureMonitorCallback futureMonitorCallback) throws InterruptedException {
        boolean bl;
        Runnable runnable;
        ExecutorService executorService = Executors.newFixedThreadPool(Math.min(set.size(), 8), (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " starterExecutorService-"), (java.util.logging.Logger)Logger.LOGGER));
        this.fCallback = futureMonitorCallback;
        Logger.LOGGER.finest("Will start " + command + " on " + set);
        for (String object : set) {
            runnable = new RemoteExecutionStarter(command, object, parameterMap, protocol);
            executorService.execute(runnable);
        }
        executorService.shutdown();
        Logger.LOGGER.finest("Submitted RemoteExecutionStarters for " + command + " on " + set + ". Waiting for RemoteExecutionStarters to finish launching commands.");
        while (!(bl = executorService.awaitTermination(1L, TimeUnit.MINUTES))) {
        }
        Logger.LOGGER.fine("Started " + command + " on " + set);
        this.fCallback.commandsStarted(this.getHostsToFutures());
        if (NoOpCallback.INSTANCE != this.fCallback) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " completedCheckExecutor"), (java.util.logging.Logger)Logger.LOGGER));
            runnable = new CommandCompletedCheck(this, futureMonitorCallback, scheduledThreadPoolExecutor);
            scheduledThreadPoolExecutor.execute(runnable);
            Logger.LOGGER.finest("Scheduled CommandCompletedCheck for " + command + " on " + set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorFuture(String string, Future future) {
        this.fLock.lock();
        try {
            this.fHostsToFutures.put(string, future);
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.finest("Started monitoring " + future + " on " + string);
        this.fCallback.commandStarted(string, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordException(String string, RemoteExecutionException remoteExecutionException) {
        this.fLock.lock();
        try {
            if (!this.fHostsToExceptions.containsKey(string)) {
                this.fHostsToExceptions.put(string, remoteExecutionException);
            }
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.log(Level.WARNING, "Observed exception on " + string, remoteExecutionException);
        this.fCallback.exceptionCaught(string, remoteExecutionException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.fLock.lock();
        try {
            for (Future future : this.fHostsToFutures.values()) {
                future.cancel();
            }
        }
        finally {
            this.fLock.unlock();
        }
        Logger.LOGGER.fine("Canceled all futures");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAnyRunning() {
        this.fLock.lock();
        try {
            boolean bl = false;
            for (Future future : this.fHostsToFutures.values()) {
                bl |= future.isRunning();
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void awaitEndOfAll() throws InterruptedException {
        Map<String, Future> map = this.getHostsToFutures();
        Logger.LOGGER.finest("Started waiting for the end of all monitored commands");
        for (String string : map.keySet()) {
            Future future = map.get(string);
            try {
                future.awaitEnd();
            }
            catch (FulfillmentException fulfillmentException) {
                this.recordException(string, fulfillmentException);
            }
        }
        Logger.LOGGER.finest("Finished waiting for the end of all monitored commands");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Future> getHostsToFutures() {
        this.fLock.lock();
        try {
            HashMap<String, Future> hashMap = new HashMap<String, Future>(this.fHostsToFutures);
            return hashMap;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, RemoteExecutionException> getHostsToExceptions() {
        this.fLock.lock();
        try {
            HashMap<String, RemoteExecutionException> hashMap = new HashMap<String, RemoteExecutionException>(this.fHostsToExceptions);
            return hashMap;
        }
        finally {
            this.fLock.unlock();
        }
    }

    private static final class CommandCompletedCheck
    implements Runnable {
        private final ScheduledThreadPoolExecutor fExecutor;
        private final FutureMonitor fFutureMonitor;
        private final FutureMonitorCallback fCallback;
        private final Set<String> fHostnamesCompleted = new HashSet<String>();

        CommandCompletedCheck(FutureMonitor futureMonitor, FutureMonitorCallback futureMonitorCallback, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
            this.fFutureMonitor = futureMonitor;
            this.fCallback = futureMonitorCallback;
            this.fExecutor = scheduledThreadPoolExecutor;
        }

        @Override
        public void run() {
            Map<String, Future> map = this.fFutureMonitor.getHostsToFutures();
            for (String string : map.keySet()) {
                Future future;
                if (this.fHostnamesCompleted.contains(string) || (future = map.get(string)).isRunning()) continue;
                this.fHostnamesCompleted.add(string);
                this.fCallback.commandEnded(string, future);
            }
            if (this.fHostnamesCompleted.containsAll(map.keySet())) {
                this.fExecutor.shutdown();
                Logger.LOGGER.fine("Finished polling for the end of all monitored commands");
                this.fCallback.commandsEnded(this.fFutureMonitor.getHostsToFutures(), this.fFutureMonitor.getHostsToExceptions());
            } else {
                this.fExecutor.schedule(this, 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private static final class NoOpCallback
    implements FutureMonitorCallback {
        static final NoOpCallback INSTANCE = new NoOpCallback();

        private NoOpCallback() {
        }

        @Override
        public void commandStarted(String string, Future future) {
        }

        @Override
        public void commandsStarted(Map<String, Future> map) {
        }

        @Override
        public void exceptionCaught(String string, RemoteExecutionException remoteExecutionException) {
        }

        @Override
        public void commandEnded(String string, Future future) {
        }

        @Override
        public void commandsEnded(Map<String, Future> map, Map<String, RemoteExecutionException> map2) {
        }
    }

    public static interface FutureMonitorCallback {
        public void commandStarted(String var1, Future var2);

        public void commandsStarted(Map<String, Future> var1);

        public void exceptionCaught(String var1, RemoteExecutionException var2);

        public void commandEnded(String var1, Future var2);

        public void commandsEnded(Map<String, Future> var1, Map<String, RemoteExecutionException> var2);
    }

    private class RemoteExecutionStarter
    implements Runnable {
        private final Command fCommand;
        private final String fHost;
        private final ParameterMap fParameterMap;
        private final Protocol fProtocol;

        RemoteExecutionStarter(Command command, String string, ParameterMap parameterMap, Protocol protocol) {
            this.fCommand = command;
            this.fHost = string;
            this.fParameterMap = parameterMap;
            this.fProtocol = protocol;
        }

        @Override
        public void run() {
            try {
                Future future = this.fProtocol.execute(this.fCommand, this.fHost, this.fParameterMap);
                FutureMonitor.this.monitorFuture(this.fHost, future);
            }
            catch (DispatchException dispatchException) {
                FutureMonitor.this.recordException(this.fHost, dispatchException);
            }
        }
    }
}

