/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterInCredential;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordCredential;
import com.mathworks.toolbox.distcomp.remote.PasswordEmptyException;
import com.mathworks.toolbox.distcomp.remote.PasswordNullException;
import com.mathworks.toolbox.distcomp.remote.UsernameEmptyException;
import com.mathworks.toolbox.distcomp.remote.UsernameNullException;

public final class PasswordCredentialDescription
implements CredentialDescription {
    public static final PasswordCredentialDescription INSTANCE = new PasswordCredentialDescription();
    public static final ParameterInCredential<String> USERNAME = new ParameterInCredential<String>((Parameter.PersistentKey)PersistentKey.USERNAME, false, true, String.class, System.getProperty("user.name")){

        @Override
        public void checkValueImpl(String string) throws InvalidValueException {
            if (string == null) {
                throw new UsernameNullException(this);
            }
            if (string.isEmpty()) {
                throw new UsernameEmptyException(this);
            }
        }
    };
    public static final ParameterInCredential<Password> PASSWORD = new ParameterInCredential<Password>((Parameter.PersistentKey)PersistentKey.PASSWORD, true, true, Password.class){

        @Override
        public void checkValueImpl(Password password) throws InvalidValueException {
            if (password == null) {
                throw new PasswordNullException(this);
            }
            if (password.getPassword().length == 0) {
                throw new PasswordEmptyException(this);
            }
        }
    };
    private static final ParameterSet PARAMETERS = new ParameterSet(USERNAME, PASSWORD);

    private PasswordCredentialDescription() {
    }

    @Override
    public ParameterSet getParameterSet() {
        return PARAMETERS;
    }

    @Override
    public Credential create(ParameterMap parameterMap) {
        return new PasswordCredential(parameterMap);
    }

    private static enum PersistentKey implements Parameter.PersistentKey
    {
        USERNAME,
        PASSWORD;

    }
}

