/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.cli;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.ForwardTunnelCommand;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ReverseTunnelCommand;
import com.mathworks.toolbox.distcomp.remote.TunnelCommand;
import com.mathworks.toolbox.distcomp.remote.cli.CommandCreationException;
import com.mathworks.toolbox.distcomp.remote.cli.CommandFactory;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.util.List;

class TunnelCommandFactory
implements CommandFactory<TunnelCommand> {
    private static final String TUNNEL_COMMAND_TYPE = "tunnel";
    private static final ParameterSet COMMAND_PARAMETERS = new ParameterSet(TunnelParameter.DIRECTION, TunnelParameter.LOCAL_PORT, TunnelParameter.LOCAL_BIND_ADDRESS, TunnelParameter.REMOTE_PORT, TunnelParameter.REMOTE_BIND_ADDRESS);

    TunnelCommandFactory() {
    }

    @Override
    public TunnelCommand createCommand(ParameterMap parameterMap, List<String> list) throws CommandCreationException {
        String string = parameterMap.getOrSuggest(TunnelParameter.DIRECTION);
        if (!parameterMap.containsKey(TunnelParameter.LOCAL_PORT)) {
            throw new CommandCreationLocalPortException();
        }
        int n = parameterMap.get(TunnelParameter.LOCAL_PORT);
        String string2 = parameterMap.getOrSuggest(TunnelParameter.LOCAL_BIND_ADDRESS);
        if (!parameterMap.containsKey(TunnelParameter.REMOTE_PORT)) {
            throw new CommandCreationRemotePortException();
        }
        int n2 = parameterMap.get(TunnelParameter.REMOTE_PORT);
        String string3 = parameterMap.getOrSuggest(TunnelParameter.REMOTE_BIND_ADDRESS);
        if (TunnelCommand.FORWARD.equals(string)) {
            return new ForwardTunnelCommand(n, string2, n2, string3);
        }
        if (TunnelCommand.REVERSE.equals(string)) {
            return new ReverseTunnelCommand(n, string2, n2, string3);
        }
        throw new CommandCreationDirectionException(string);
    }

    @Override
    public Class<TunnelCommand> getCommandClass() {
        return TunnelCommand.class;
    }

    @Override
    public String getCommandType() {
        return TUNNEL_COMMAND_TYPE;
    }

    @Override
    public ParameterSet getParameterSet() {
        return COMMAND_PARAMETERS;
    }

    @Override
    public void setRemotePlatform(PathUtils.Platform platform) {
    }

    private static final class CommandCreationRemotePortException
    extends CommandCreationException {
        private final BaseMsgID fBaseMsgID = new remote.TunnelCommandFactoryRemotePort();

        CommandCreationRemotePortException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CommandCreationLocalPortException
    extends CommandCreationException {
        private final BaseMsgID fBaseMsgID = new remote.TunnelCommandFactoryLocalPort();

        CommandCreationLocalPortException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CommandCreationDirectionException
    extends CommandCreationException {
        private final BaseMsgID fBaseMsgID;

        CommandCreationDirectionException(String string) {
            this.fBaseMsgID = new remote.TunnelCommandFactoryDirection(TunnelCommand.FORWARD, TunnelCommand.REVERSE, string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static class TunnelParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> DIRECTION = new TunnelParameter<String>((Parameter.PersistentKey)Key.DIRECTION, false, String.class, TunnelCommand.FORWARD);
        public static final Parameter<Integer> LOCAL_PORT = new TunnelParameter<Integer>(Key.LOCAL_PORT, true, Integer.class);
        public static final Parameter<String> LOCAL_BIND_ADDRESS = new TunnelParameter<String>(Key.LOCAL_BIND_ADDRESS, false, false, String.class, "localhost");
        public static final Parameter<Integer> REMOTE_PORT = new TunnelParameter<Integer>(Key.REMOTE_PORT, true, Integer.class);
        public static final Parameter<String> REMOTE_BIND_ADDRESS = new TunnelParameter<String>(Key.REMOTE_BIND_ADDRESS, false, false, String.class, "localhost");

        private TunnelParameter(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz, V v) {
            super(persistentKey, bl, clazz, v);
        }

        private TunnelParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        private TunnelParameter(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz) {
            super(persistentKey, bl, clazz);
        }

        @Override
        protected String getSimpleName() {
            return TunnelParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            DIRECTION,
            LOCAL_PORT,
            LOCAL_BIND_ADDRESS,
            REMOTE_PORT,
            REMOTE_BIND_ADDRESS;

        }
    }
}

