/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.storage.CachedPreparedStatement;
import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.CredentialStorageException;
import com.mathworks.toolbox.distcomp.storage.CredentialsNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class H2CredentialStorage
implements CredentialStorage {
    private static final String CRED_TABLE_NAME = "cred_table";
    private transient InsertCreds fInsertCreds;
    private transient UpdateCreds fUpdateCreds;
    private transient SelectCredsByUser fSelectCredsByUser;
    private transient SelectCredsByUserAndRole fSelectCredsByUserAndRole;
    private transient DeleteCreds fDeleteCreds;
    private transient DatabaseConnectionPool fDatabaseConnectionPool;
    private transient Connection fConn;
    private transient ReadWriteLock fRWLock = new ReentrantReadWriteLock();
    private transient Lock fReadLock = this.fRWLock.readLock();
    private transient Lock fWriteLock = this.fRWLock.writeLock();

    public H2CredentialStorage(DatabaseConnectionPool databaseConnectionPool) throws StorageInitException {
        this.fDatabaseConnectionPool = databaseConnectionPool;
        this.fConn = databaseConnectionPool.openConnectionToDatabase();
        assert (this.fConn != null) : "Exceeded maximum number of connections to the database";
        this.initializeStatements();
    }

    private void initializeStatements() {
        this.fInsertCreds = new InsertCreds();
        this.fUpdateCreds = new UpdateCreds();
        this.fSelectCredsByUser = new SelectCredsByUser();
        this.fSelectCredsByUserAndRole = new SelectCredsByUserAndRole();
        this.fDeleteCreds = new DeleteCreds();
    }

    @Override
    public void close() throws StorageException {
        this.fDatabaseConnectionPool.closeConnection(this.fConn);
    }

    @Override
    public void putCredentials(TransferableCredentials transferableCredentials, CredentialRole credentialRole) throws CredentialStorageException {
        if (transferableCredentials == null) {
            return;
        }
        UserIdentity userIdentity = transferableCredentials.getUserIdentity();
        this.fWriteLock.lock();
        try {
            this.fInsertCreds.execute(userIdentity, transferableCredentials, credentialRole);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to write credentials to the H2 database", sQLException);
            throw new H2WriteCredentialsException(sQLException);
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    @Override
    public void putMultipleCredentials(Map<CredentialRole, TransferableCredentials> map) throws CredentialStorageException {
        this.fWriteLock.lock();
        try {
            this.atomicallyWriteMultipleCredentials(map, this.fInsertCreds);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to put multiple credentials in H2 database Stored credentials potentially in an inconsistent state", sQLException);
            throw new H2WriteMultipleCredentialsException(sQLException);
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    @Override
    public void updateCredentials(TransferableCredentials transferableCredentials, CredentialRole credentialRole) throws CredentialStorageException {
        if (transferableCredentials == null) {
            return;
        }
        UserIdentity userIdentity = transferableCredentials.getUserIdentity();
        this.fWriteLock.lock();
        try {
            this.fUpdateCreds.execute(userIdentity, transferableCredentials, credentialRole);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to update credentials in the H2 database", sQLException);
            throw new H2UpdateCredentialsException(sQLException);
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    @Override
    public void updateMultipleCredentials(Map<CredentialRole, TransferableCredentials> map) throws CredentialStorageException {
        this.fWriteLock.lock();
        try {
            this.atomicallyWriteMultipleCredentials(map, this.fUpdateCreds);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to update multiple credentials in H2 database Stored credentials potentially in an inconsistent state", sQLException);
            throw new H2UpdateMultipleCredentialsException(sQLException);
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    private void atomicallyWriteMultipleCredentials(Map<CredentialRole, TransferableCredentials> map, InsertOrUpdateCredentials insertOrUpdateCredentials) throws SQLException {
        try {
            this.fConn.setAutoCommit(false);
            for (Map.Entry<CredentialRole, TransferableCredentials> entry : map.entrySet()) {
                TransferableCredentials transferableCredentials = entry.getValue();
                UserIdentity userIdentity = transferableCredentials.getUserIdentity();
                CredentialRole credentialRole = entry.getKey();
                insertOrUpdateCredentials.execute(userIdentity, transferableCredentials, credentialRole);
            }
            this.fConn.commit();
        }
        catch (SQLException sQLException) {
            this.fConn.rollback();
            throw sQLException;
        }
        finally {
            this.fConn.setAutoCommit(true);
        }
    }

    @Override
    public TransferableCredentials getCredentials(UserIdentity userIdentity, CredentialRole credentialRole) throws CredentialStorageException, CredentialsNotFoundException {
        this.fReadLock.lock();
        try {
            TransferableCredentials transferableCredentials = this.fSelectCredsByUserAndRole.execute(userIdentity, credentialRole);
            if (transferableCredentials == null) {
                throw new CredentialsNotFoundException(userIdentity);
            }
            TransferableCredentials transferableCredentials2 = transferableCredentials;
            return transferableCredentials2;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve credentials from the H2 database", sQLException);
            throw new H2GetCredentialsException(sQLException);
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    @Override
    public Map<CredentialRole, TransferableCredentials> getAllCredentials(UserIdentity userIdentity) throws CredentialStorageException, CredentialsNotFoundException {
        this.fReadLock.lock();
        try {
            Map<CredentialRole, TransferableCredentials> map = this.fSelectCredsByUser.execute(userIdentity);
            if (map.isEmpty()) {
                throw new CredentialsNotFoundException(userIdentity);
            }
            Map<CredentialRole, TransferableCredentials> map2 = map;
            return map2;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve credentials from the H2 database", sQLException);
            throw new H2GetCredentialsException(sQLException);
        }
        finally {
            this.fReadLock.unlock();
        }
    }

    @Override
    public void deleteCredentials(UserIdentity userIdentity) throws CredentialStorageException {
        this.fWriteLock.lock();
        try {
            this.fDeleteCreds.execute(userIdentity);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Credentials not removed from the job manager database", sQLException);
            throw new H2RemoveCredentialsException(sQLException);
        }
        finally {
            this.fWriteLock.unlock();
        }
    }

    private class DeleteCreds
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM cred_table WHERE user = ?";

        DeleteCreds() {
            super(SQL_STRING);
        }

        public int execute(UserIdentity userIdentity) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2CredentialStorage.this.fConn);
            preparedStatement.setObject(1, userIdentity);
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    private class SelectCredsByUserAndRole
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT creds FROM cred_table WHERE user = ? AND role = ?";

        SelectCredsByUserAndRole() {
            super(SQL_STRING);
        }

        public TransferableCredentials execute(UserIdentity userIdentity, CredentialRole credentialRole) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2CredentialStorage.this.fConn);
            preparedStatement.setObject(1, userIdentity);
            preparedStatement.setObject(2, (Object)credentialRole.name(), 12);
            ResultSet resultSet = preparedStatement.executeQuery();
            TransferableCredentials transferableCredentials = null;
            if (resultSet.next()) {
                transferableCredentials = (TransferableCredentials)resultSet.getObject(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return transferableCredentials;
        }
    }

    private class SelectCredsByUser
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT creds, role FROM cred_table WHERE user = ?";

        SelectCredsByUser() {
            super(SQL_STRING);
        }

        public Map<CredentialRole, TransferableCredentials> execute(UserIdentity userIdentity) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2CredentialStorage.this.fConn);
            preparedStatement.setObject(1, userIdentity);
            ResultSet resultSet = preparedStatement.executeQuery();
            HashMap<CredentialRole, TransferableCredentials> hashMap = new HashMap<CredentialRole, TransferableCredentials>();
            while (resultSet.next()) {
                TransferableCredentials transferableCredentials = (TransferableCredentials)resultSet.getObject(1);
                CredentialRole credentialRole = CredentialRole.valueOf(resultSet.getString(2));
                hashMap.put(credentialRole, transferableCredentials);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return hashMap;
        }
    }

    private class UpdateCreds
    extends CachedPreparedStatement
    implements InsertOrUpdateCredentials {
        private static final String SQL_STRING = "UPDATE cred_table SET creds = ? WHERE user = ? AND role = ?";

        UpdateCreds() {
            super(SQL_STRING);
        }

        @Override
        public int execute(UserIdentity userIdentity, TransferableCredentials transferableCredentials, CredentialRole credentialRole) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2CredentialStorage.this.fConn);
            preparedStatement.setObject(1, transferableCredentials);
            preparedStatement.setObject(2, userIdentity);
            preparedStatement.setObject(3, (Object)credentialRole.name(), 12);
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    private class InsertCreds
    extends CachedPreparedStatement
    implements InsertOrUpdateCredentials {
        private static final String SQL_STRING = "INSERT INTO cred_table VALUES(?,?,?)";

        InsertCreds() {
            super(SQL_STRING);
        }

        @Override
        public int execute(UserIdentity userIdentity, TransferableCredentials transferableCredentials, CredentialRole credentialRole) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2CredentialStorage.this.fConn);
            preparedStatement.setObject(1, transferableCredentials);
            preparedStatement.setObject(2, userIdentity);
            preparedStatement.setObject(3, (Object)credentialRole.name(), 12);
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    private static interface InsertOrUpdateCredentials {
        public int execute(UserIdentity var1, TransferableCredentials var2, CredentialRole var3) throws SQLException;
    }

    private static final class H2RemoveCredentialsException
    extends CredentialStorageException {
        H2RemoveCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2RemoveCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class H2GetCredentialsException
    extends CredentialStorageException {
        H2GetCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2GetCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class H2UpdateMultipleCredentialsException
    extends CredentialStorageException {
        H2UpdateMultipleCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2UpdateMultipleCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class H2UpdateCredentialsException
    extends CredentialStorageException {
        H2UpdateCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2UpdateCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class H2WriteMultipleCredentialsException
    extends CredentialStorageException {
        H2WriteMultipleCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2WriteMultipleCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class H2WriteCredentialsException
    extends CredentialStorageException {
        H2WriteCredentialsException(SQLException sQLException) {
            super(CredentialStorageErrorCode.H2WriteCredentialsError, (Throwable)sQLException, new Object[0]);
        }
    }
}

