/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.CachedPreparedStatement;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.IncorrectStateToDemoteJobException;
import com.mathworks.toolbox.distcomp.storage.IncorrectStateToPromoteJobException;
import com.mathworks.toolbox.distcomp.storage.JobNotFoundException;
import com.mathworks.toolbox.distcomp.storage.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.ReadJobsException;
import com.mathworks.toolbox.distcomp.storage.ReadTasksException;
import com.mathworks.toolbox.distcomp.storage.StorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageHelpers;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.TaskNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorageException;
import com.mathworks.toolbox.distcomp.util.BufferedStreamCopier;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class H2DatabaseStorage
implements DatabaseStorage {
    private static final String DATA_SEQUENCE_NAME = "data_seq_key";
    private static final String JOB_SEQUENCE_NAME = "job_seq_key";
    private static final String JOB_QUEUE_SEQUENCE_NAME = "job_queue_seq_key";
    private static final String QUOTED_DATA_SEQUENCE_NAME = "'data_seq_key'";
    private static final String QUOTED_JOB_SEQUENCE_NAME = "'job_seq_key'";
    private static final String QUOTED_JOB_QUEUE_SEQUENCE_NAME = "'job_queue_seq_key'";
    private static final String TASK_TABLE_NAME = "task_table";
    private static final String JOB_TABLE_NAME = "job_table";
    private static final String DATA_TABLE_NAME = "data_table";
    private Semaphore fDataTableWriteLock = new Semaphore(1, true);
    private transient SelectTaskById fSelectTaskById;
    private transient SelectTasksByState fSelectTasksByState;
    private transient SelectTasksByJobId fSelectTasksByJobId;
    private transient CountTasksByJobId fCountTasksByJobId;
    private transient CountTasksByJobIdAndState fCountTasksByJobIdAndState;
    private transient CountTasksByJobIdAndBeforeState fCountTasksByJobIdAndBeforeState;
    private transient SelectTasksByJobIdAndState fSelectTasksByJobIdAndState;
    private transient SelectTasksByJobIdAndArrayOfStates fSelectTasksByJobIdAndArrayOfStates;
    private transient SelectNumberOfTasksByJobIdAndState fSelectNumberOfTasksByJobIdAndState;
    private transient SelectTasksByJobIdAndBeforeState fSelectTasksByJobIdAndBeforeState;
    private transient SelectDataById fSelectDataById;
    private transient SelectJobById fSelectJobById;
    private transient SelectJobsByState fSelectJobsByState;
    private transient SelectJobsByJobStateWithTasksInState fSelectJobsByJobStateWithTasksInState;
    private transient SelectJobsAndTypesByState fSelectJobsAndTypesByState;
    private transient SelectJobsAndTypesByArrayOfStates fSelectJobsAndTypesByArrayOfStates;
    private transient SelectPreviousQueuedJob fSelectPreviousQueuedJob;
    private transient SelectNextQueuedJob fSelectNextQueuedJob;
    private transient SwapQueuedJobs fSwapQueuedJobs;
    private transient ReadJobState fReadJobState;
    private transient SelectFirstJobByState fSelectFirstJobByState;
    private transient SelectJobsAndTypes fSelectJobsAndTypes;
    private transient AddToJobQueue fAddToJobQueue;
    private transient RemoveFromJobQueue fRemoveFromJobQueue;
    private transient InsertData fInsertData;
    private transient CopyData fCopyData;
    private transient UpdateData fUpdateData;
    private transient AppendToData fAppendToData;
    private transient DeleteDataForJobAndTasks fDeleteDataForJobAndTasks;
    private transient DeleteDataForTask fDeleteDataForTask;
    private transient DeleteData fDeleteData;
    private transient InsertTask fInsertTask;
    private transient UpdateTask fUpdateTask;
    private transient DeleteTask fDeleteTask;
    private transient DeleteTasksByJobId fDeleteTasksByJobId;
    private transient InsertJob fInsertJob;
    private transient UpdateJob fUpdateJob;
    private transient DeleteJob fDeleteJob;
    private transient Connection fConn;
    private transient DatabaseConnectionPool fDatabaseConnectionPool;

    public H2DatabaseStorage(DatabaseConnectionPool databaseConnectionPool) throws StorageInitException {
        this.fDatabaseConnectionPool = databaseConnectionPool;
        this.fConn = databaseConnectionPool.openConnectionToDatabase();
        assert (this.fConn != null) : "Exceeded maximum number of connections to the database";
        this.initializeStatements();
    }

    private void initializeStatements() {
        this.fSelectTaskById = new SelectTaskById();
        this.fSelectTasksByState = new SelectTasksByState();
        this.fSelectTasksByJobId = new SelectTasksByJobId();
        this.fSelectTasksByJobIdAndState = new SelectTasksByJobIdAndState();
        this.fSelectTasksByJobIdAndArrayOfStates = new SelectTasksByJobIdAndArrayOfStates();
        this.fSelectNumberOfTasksByJobIdAndState = new SelectNumberOfTasksByJobIdAndState();
        this.fSelectTasksByJobIdAndBeforeState = new SelectTasksByJobIdAndBeforeState();
        this.fSelectJobById = new SelectJobById();
        this.fSelectJobsByState = new SelectJobsByState();
        this.fSelectJobsByJobStateWithTasksInState = new SelectJobsByJobStateWithTasksInState();
        this.fSelectJobsAndTypesByState = new SelectJobsAndTypesByState();
        this.fSelectJobsAndTypesByArrayOfStates = new SelectJobsAndTypesByArrayOfStates();
        this.fSelectPreviousQueuedJob = new SelectPreviousQueuedJob();
        this.fSelectNextQueuedJob = new SelectNextQueuedJob();
        this.fSwapQueuedJobs = new SwapQueuedJobs();
        this.fReadJobState = new ReadJobState();
        this.fSelectJobsAndTypes = new SelectJobsAndTypes();
        this.fSelectFirstJobByState = new SelectFirstJobByState();
        this.fSelectDataById = new SelectDataById();
        this.fCountTasksByJobId = new CountTasksByJobId();
        this.fCountTasksByJobIdAndState = new CountTasksByJobIdAndState();
        this.fCountTasksByJobIdAndBeforeState = new CountTasksByJobIdAndBeforeState();
        this.fAddToJobQueue = new AddToJobQueue();
        this.fRemoveFromJobQueue = new RemoveFromJobQueue();
        this.fInsertData = new InsertData();
        this.fInsertTask = new InsertTask();
        this.fInsertJob = new InsertJob();
        this.fCopyData = new CopyData();
        this.fUpdateData = new UpdateData();
        this.fUpdateTask = new UpdateTask();
        this.fUpdateJob = new UpdateJob();
        this.fAppendToData = new AppendToData();
        this.fDeleteData = new DeleteData();
        this.fDeleteDataForJobAndTasks = new DeleteDataForJobAndTasks();
        this.fDeleteDataForTask = new DeleteDataForTask();
        this.fDeleteTask = new DeleteTask();
        this.fDeleteTasksByJobId = new DeleteTasksByJobId();
        this.fDeleteJob = new DeleteJob();
    }

    @Override
    public void close() throws StorageException {
        this.fDatabaseConnectionPool.closeConnection(this.fConn);
    }

    @Override
    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Uuid putJob(JobImpl jobImpl) throws WorkUnitStorageException {
        if (jobImpl == null) {
            return null;
        }
        Uuid uuid = jobImpl.getID();
        try {
            this.fInsertJob.execute(jobImpl);
            return uuid;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to write job, " + jobImpl + ", to the job manager database.", sQLException);
            throw new WriteJobException(sQLException);
        }
    }

    @Override
    public Uuid putTask(TaskImpl taskImpl) throws WorkUnitStorageException {
        if (taskImpl == null) {
            return null;
        }
        Uuid uuid = taskImpl.getID();
        try {
            this.fInsertTask.execute(taskImpl);
            return uuid;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to write task, " + taskImpl + ", to the job manager database.", sQLException);
            throw new WriteTaskException(sQLException);
        }
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null || uuid2 == null) {
            return;
        }
        try {
            this.fInsertData.execute(uuid, uuid2, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to write job data to the H2 database", sQLException);
            throw new PutDataException(sQLException);
        }
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null || uuid2 == null || uuid3 == null) {
            return;
        }
        try {
            this.fInsertData.execute(uuid, uuid2, uuid3, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to write task data to the H2 database", sQLException);
            throw new PutDataException(sQLException);
        }
    }

    @Override
    public WorkUnitImpl readWorkUnit(Uuid uuid) throws WorkUnitNotFoundException {
        if (uuid == null) {
            throw new NullWorkUnitIDException();
        }
        return this.readWorkUnitFromDatabase(uuid);
    }

    private WorkUnitImpl readWorkUnitFromDatabase(Uuid uuid) throws WorkUnitNotFoundException {
        WorkUnitImpl workUnitImpl;
        try {
            workUnitImpl = this.readTask(uuid);
        }
        catch (TaskNotFoundException taskNotFoundException) {
            try {
                workUnitImpl = this.readJob(uuid);
            }
            catch (JobNotFoundException jobNotFoundException) {
                PackageInfo.LOGGER.log(Level.FINE, "Work unit not found in database, id: " + uuid);
                throw new WorkUnitNotFoundException();
            }
        }
        return workUnitImpl;
    }

    private JobImpl readJob(Uuid uuid) throws JobNotFoundException {
        JobImpl jobImpl;
        try {
            jobImpl = this.fSelectJobById.execute(uuid);
            if (jobImpl == null) {
                throw new JobNotFoundException();
            }
        }
        catch (WorkUnitStorageException | SQLException exception) {
            PackageInfo.LOGGER.log(Level.INFO, "Could not read job: " + uuid + " from the job manager database.", exception);
            throw new JobNotFoundException(exception);
        }
        return jobImpl;
    }

    private TaskImpl readTask(Uuid uuid) throws TaskNotFoundException {
        TaskImpl taskImpl;
        try {
            taskImpl = this.fSelectTaskById.execute(uuid);
            if (taskImpl == null) {
                throw new TaskNotFoundException();
            }
        }
        catch (WorkUnitStorageException | SQLException exception) {
            PackageInfo.LOGGER.log(Level.INFO, "Could not read task: " + uuid + " from the job manager database.", exception);
            throw new TaskNotFoundException(exception);
        }
        return taskImpl;
    }

    @Override
    public byte[] readData(Uuid uuid) throws DataStorageException {
        byte[] byArray;
        assert (uuid != null) : "cannot read null data";
        try {
            byArray = this.fSelectDataById.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", sQLException);
            throw new ReadDataException(sQLException);
        }
        return byArray;
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws DataStorageException {
        int n2;
        assert (uuid != null) : "cannot read null data";
        try {
            n2 = this.fSelectDataById.execute(uuid, outputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", sQLException);
            throw new ReadDataException(sQLException);
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to read data from H2 database", iOException);
            throw new ReadDataException(iOException);
        }
        return n2;
    }

    @Override
    public void promoteJob(Uuid uuid) throws WorkUnitStorageException, WorkUnitStateException {
        assert (uuid != null) : "Called promoteJob with a null jobid";
        try {
            Uuid uuid2 = this.fSelectPreviousQueuedJob.execute(uuid);
            if (uuid2 != null) {
                int n = this.fSwapQueuedJobs.execute(uuid, uuid2);
                assert (n == 2);
            } else {
                int n = this.fReadJobState.execute(uuid);
                if (n != 1) {
                    throw new IncorrectStateToPromoteJobException();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new PromoteJobException(sQLException);
        }
    }

    @Override
    public void demoteJob(Uuid uuid) throws WorkUnitStorageException, WorkUnitStateException {
        assert (uuid != null) : "Called demoteJob with a null jobid";
        try {
            Uuid uuid2 = this.fSelectNextQueuedJob.execute(uuid);
            if (uuid2 != null) {
                int n = this.fSwapQueuedJobs.execute(uuid, uuid2);
                assert (n == 2);
            } else {
                int n = this.fReadJobState.execute(uuid);
                if (n != 1) {
                    throw new IncorrectStateToDemoteJobException();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new DemoteJobException(sQLException);
        }
    }

    @Override
    public void updateCredentials(UserCredentials userCredentials) {
        PackageInfo.LOGGER.log(Level.INFO, "updateCredentials called on H2DatabaseStorage, this is not expected.");
    }

    @Override
    public int updateWorkUnit(WorkUnitImpl workUnitImpl) throws WorkUnitStorageException {
        if (workUnitImpl instanceof JobImpl) {
            return this.updateJob((JobImpl)workUnitImpl);
        }
        if (workUnitImpl instanceof TaskImpl) {
            return this.updateTask((TaskImpl)workUnitImpl);
        }
        throw new IllegalArgumentException("The WorkUnit must be an instance of JobImpl or of TaskImpl.");
    }

    private int updateJob(JobImpl jobImpl) throws WorkUnitStorageException {
        try {
            return this.fUpdateJob.execute(jobImpl);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to update job in the job manager database.", sQLException);
            throw new UpdateJobException(sQLException);
        }
    }

    private int updateTask(TaskImpl taskImpl) throws WorkUnitStorageException {
        try {
            return this.fUpdateTask.execute(taskImpl);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to update task in the job manager database.", sQLException);
            throw new UpdateTaskException(sQLException);
        }
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fUpdateData.execute(uuid, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to update data in the H2 database", sQLException);
            throw new UpdateDataException(sQLException);
        }
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fAppendToData.execute(uuid, inputStream, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to append to data in the H2 database", sQLException);
            throw new AppendDataException(sQLException);
        }
    }

    @Override
    public void removeJob(Uuid uuid) throws WorkUnitStorageException, WorkUnitNotFoundException {
        if (uuid == null) {
            return;
        }
        try {
            this.fDeleteTasksByJobId.execute(uuid);
            int n = this.fDeleteJob.execute(uuid);
            if (n <= 0) {
                throw new JobNotFoundException();
            }
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to remove job from the job manager database.", sQLException);
            throw new RemoveJobException(sQLException);
        }
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws DataStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fDeleteDataForJobAndTasks.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to delete data for job in the H2 database", sQLException);
            throw new JobDataRemoveException(sQLException);
        }
    }

    @Override
    public void removeTask(Uuid uuid) throws WorkUnitStorageException {
        if (uuid == null) {
            return;
        }
        try {
            this.fDeleteTask.execute(uuid);
            this.fDeleteDataForTask.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Task not removed from the job manager database", sQLException);
            throw new RemoveTaskException(sQLException);
        }
    }

    @Override
    public void removeData(Uuid uuid) throws DataStorageException {
        assert (uuid != null) : "cannot remove null data";
        try {
            this.fDeleteData.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to remove data from the H2 database", sQLException);
            throw new WorkUnitDataRemoveException(sQLException);
        }
    }

    @Override
    public Uuid copyData(Uuid uuid) throws DataStorageException {
        assert (uuid != null) : "cannot copy null data";
        try {
            Uuid uuid2 = UuidFactory.generate();
            this.fCopyData.execute(uuid, uuid2);
            return uuid2;
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to copy data in the H2 database", sQLException);
            throw new CopyDataException(sQLException);
        }
    }

    @Override
    public Uuid[] readTasksByState(int n) throws WorkUnitStorageException {
        Uuid[] uuidArray;
        try {
            uuidArray = this.fSelectTasksByState.execute(n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to a read Task IDs from the job manager database", sQLException);
            throw new ReadTasksException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobID(Uuid uuid) throws WorkUnitStorageException {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectTasksByJobId.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read Task IDs from the job manager database", sQLException);
            throw new ReadTasksException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[][] readTasksByJobIDAndState(Uuid uuid, int[] nArray) throws WorkUnitStorageException {
        Uuid[][] uuidArray = new Uuid[nArray.length][0];
        if (uuid == null) {
            return uuidArray;
        }
        try {
            if (nArray.length == 1) {
                uuidArray[0] = this.fSelectTasksByJobIdAndState.execute(uuid, nArray[0]);
            } else {
                uuidArray = this.fSelectTasksByJobIdAndArrayOfStates.execute(uuid, nArray);
            }
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to a read Task IDs from the job manager database", sQLException);
            throw new ReadTasksException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobIDAndState(Uuid uuid, int n, int n2) throws WorkUnitStorageException {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null || n2 < 1) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectNumberOfTasksByJobIdAndState.execute(uuid, n, n2);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to a read a Task ID from the job manager database", sQLException);
            throw new ReadTasksException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobIDAndBeforeState(Uuid uuid, int n) throws WorkUnitStorageException, MJSException {
        Uuid[] uuidArray = new Uuid[]{};
        if (uuid == null) {
            return uuidArray;
        }
        try {
            uuidArray = this.fSelectTasksByJobIdAndBeforeState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to a read Task IDs from the job manager database", sQLException);
            throw new ReadTasksException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public int countTasksByJobID(Uuid uuid) throws WorkUnitStorageException {
        int n;
        try {
            n = this.fCountTasksByJobId.execute(uuid);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to count the tasks in the job manager database", sQLException);
            throw new CountTasksException(sQLException);
        }
        return n;
    }

    @Override
    public int countTasksByJobIDAndState(Uuid uuid, int n) throws WorkUnitStorageException {
        int n2;
        try {
            n2 = this.fCountTasksByJobIdAndState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to count the tasks in the job manager database", sQLException);
            throw new CountTasksException(sQLException);
        }
        return n2;
    }

    @Override
    public int countTasksByJobIDAndBeforeState(Uuid uuid, int n) throws WorkUnitStorageException {
        int n2;
        try {
            n2 = this.fCountTasksByJobIdAndBeforeState.execute(uuid, n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to count the tasks in the job manager database", sQLException);
            throw new CountTasksException(sQLException);
        }
        return n2;
    }

    @Override
    public Uuid[] readJobsByState(int n) throws WorkUnitStorageException {
        Uuid[] uuidArray;
        try {
            uuidArray = this.fSelectJobsByState.execute(n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read Job IDs from the job manager database", sQLException);
            throw new ReadJobsException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readJobsByJobStateWithTasksInState(int n, int n2) throws WorkUnitStorageException {
        Uuid[] uuidArray;
        try {
            uuidArray = this.fSelectJobsByJobStateWithTasksInState.execute(n, n2);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read Job IDs from the job manager database", sQLException);
            throw new ReadJobsException(sQLException);
        }
        return uuidArray;
    }

    @Override
    public JobIDAndMLType[] readJobsAndTypes() throws WorkUnitStorageException {
        JobIDAndMLType[] jobIDAndMLTypeArray;
        try {
            jobIDAndMLTypeArray = this.fSelectJobsAndTypes.execute();
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read Job IDs and Types from the job manager database", sQLException);
            throw new ReadJobsException(sQLException);
        }
        return jobIDAndMLTypeArray;
    }

    @Override
    public JobIDAndMLType[][] readJobsAndTypesByState(int[] nArray) throws WorkUnitStorageException {
        JobIDAndMLType[][] jobIDAndMLTypeArray = new JobIDAndMLType[nArray.length][0];
        try {
            if (nArray.length == 1) {
                jobIDAndMLTypeArray[0] = this.fSelectJobsAndTypesByState.execute(nArray[0]);
            } else {
                jobIDAndMLTypeArray = this.fSelectJobsAndTypesByArrayOfStates.execute(nArray);
            }
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read Job IDs and Types from the job manager database", sQLException);
            throw new ReadJobsException(sQLException);
        }
        return jobIDAndMLTypeArray;
    }

    @Override
    public Uuid readFirstJobByState(int n) throws WorkUnitStorageException {
        Uuid uuid;
        try {
            uuid = this.fSelectFirstJobByState.execute(n);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to read a Job ID from the job manager database", sQLException);
            throw new ReadJobsException(sQLException);
        }
        return uuid;
    }

    @Override
    public void addToQueue(Uuid uuid) throws WorkUnitStorageException {
        try {
            int n = this.fAddToJobQueue.execute(uuid);
            assert (n == 1);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to add job to the job manager queue.", sQLException);
            throw new AddToQueueException(sQLException);
        }
    }

    @Override
    public void removeFromQueue(Uuid uuid) throws WorkUnitStorageException {
        try {
            int n = this.fRemoveFromJobQueue.execute(uuid);
            assert (n == 1);
        }
        catch (SQLException sQLException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Unable to remove job from the job manager queue.", sQLException);
            throw new RemoveFromQueueException(sQLException);
        }
    }

    class ReadJobState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT state FROM job_table WHERE jobid = ?";

        public ReadJobState() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
            assert (false) : "Failed to retrieve state of job from job manager database";
            throw new IllegalStateException("Failed to retrieve state of job from job manager database");
        }
    }

    class SwapQueuedJobs
    extends CachedPreparedStatement {
        private static final String SQL_STRING = " UPDATE job_table SET queuenum =  (CASE WHEN jobid = ?1 THEN  (SELECT queuenum FROM job_table WHERE jobid = ?2) ELSE  (SELECT queuenum FROM job_table WHERE jobid = ?1) END) WHERE jobid IN (?1, ?2)";

        public SwapQueuedJobs() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid, Uuid uuid2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setString(2, uuid2.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class RemoveFromJobQueue
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE job_table SET queuenum = ? WHERE jobid = ?";

        public RemoveFromJobQueue() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setLong(1, StorageHelpers.NOT_ON_JOB_QUEUE);
            preparedStatement.setString(2, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class AddToJobQueue
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE job_table SET queuenum = NEXTVAL('job_queue_seq_key')  WHERE jobid = ?";

        public AddToJobQueue() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM task_table WHERE jobid = ?";

        public DeleteTasksByJobId() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM task_table WHERE taskid = ?";

        public DeleteTask() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM job_table WHERE jobid = ?";

        public DeleteJob() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE dataid = ?";

        public DeleteData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteDataForTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE taskid = ?";

        public DeleteDataForTask() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class DeleteDataForJobAndTasks
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM data_table WHERE jobid = ?";

        public DeleteDataForJobAndTasks() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class AppendToData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE data_table SET data = data || ? WHERE dataid = ?";

        public AppendToData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, InputStream inputStream, int n) throws SQLException {
            int n2;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setBinaryStream(1, inputStream, n);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n2 = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class UpdateData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE data_table SET data = ? WHERE dataid = ?";

        public UpdateData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, byte[] byArray) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            preparedStatement.setBinaryStream(1, (InputStream)byteArrayInputStream, byArray.length);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, InputStream inputStream, int n) throws SQLException {
            int n2;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setBinaryStream(1, inputStream, n);
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n2 = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class UpdateJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE job_table SET job = ?, state = ? WHERE jobid = ?";

        public UpdateJob() {
            super(SQL_STRING);
        }

        public int execute(JobImpl jobImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setObject(1, jobImpl);
            preparedStatement.setInt(2, jobImpl.getState());
            preparedStatement.setString(3, jobImpl.getID().toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class UpdateTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE task_table SET task = ?, state = ? WHERE taskid = ?";

        public UpdateTask() {
            super(SQL_STRING);
        }

        public int execute(TaskImpl taskImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setObject(1, taskImpl);
            preparedStatement.setInt(2, taskImpl.getState());
            preparedStatement.setString(3, taskImpl.getID().toString());
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class CopyData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO data_table (seqnum, jobid, taskid, dataid, data) SELECT NEXTVAL('data_seq_key'), jobid, taskid, ?, data FROM data_table WHERE dataid = ? ORDER BY seqnum";

        public CopyData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Uuid uuid, Uuid uuid2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid2.toString());
            preparedStatement.setString(2, uuid.toString());
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
        }
    }

    class InsertData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO data_table VALUES(NEXTVAL('data_seq_key'),?,?,?,?)";

        public InsertData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setNull(2, 0);
                preparedStatement.setString(3, uuid2.toString());
                preparedStatement.setBinaryStream(4, inputStream, n);
                int n2 = this.execute(preparedStatement);
                return n2;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setString(2, uuid2.toString());
                preparedStatement.setString(3, uuid3.toString());
                preparedStatement.setBinaryStream(4, inputStream, n);
                int n2 = this.execute(preparedStatement);
                return n2;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int execute(PreparedStatement preparedStatement) throws SQLException {
            int n;
            H2DatabaseStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2DatabaseStorage.this.fDataTableWriteLock.release();
            }
            return n;
        }
    }

    class InsertJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO job_table VALUES(NEXTVAL('job_seq_key'),?,?,?,?,?)";

        public InsertJob() {
            super(SQL_STRING);
        }

        public int execute(JobImpl jobImpl) throws SQLException {
            int n = jobImpl.getJobMLType();
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setLong(1, StorageHelpers.NOT_ON_JOB_QUEUE);
            preparedStatement.setString(2, jobImpl.getID().toString());
            preparedStatement.setInt(3, jobImpl.getState());
            preparedStatement.setInt(4, n);
            preparedStatement.setObject(5, jobImpl);
            int n2 = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class InsertTask
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO task_table VALUES(?,?,?,?,?)";

        public InsertTask() {
            super(SQL_STRING);
        }

        public int execute(TaskImpl taskImpl) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setLong(1, taskImpl.getNum());
            preparedStatement.setString(2, taskImpl.getJob().toString());
            preparedStatement.setInt(3, taskImpl.getState());
            preparedStatement.setString(4, taskImpl.getID().toString());
            preparedStatement.setObject(5, taskImpl);
            int n = preparedStatement.executeUpdate();
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    class CountTasksByJobIdAndBeforeState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ? AND state < ?";

        public CountTasksByJobIdAndBeforeState() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class CountTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ? AND state = ?";

        public CountTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public int execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n2 = 0;
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class CountTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT COUNT(*) FROM task_table WHERE jobid = ?";

        public CountTasksByJobId() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                this.releaseStatement(preparedStatement);
            }
        }
    }

    private static final class H2DataNotFoundException
    extends DataNotFoundException {
        H2DataNotFoundException() {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.DataNotFoundError, new Object[0]);
        }
    }

    class SelectDataById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT data FROM data_table WHERE dataid = ? ORDER BY seqnum";

        public SelectDataById() {
            super(SQL_STRING);
        }

        public byte[] execute(Uuid uuid) throws SQLException, DataNotFoundException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new H2DataNotFoundException();
            }
            Blob blob = resultSet.getBlob(1);
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return byArray;
        }

        public int execute(Uuid uuid, OutputStream outputStream, int n) throws SQLException, IOException, DataNotFoundException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new H2DataNotFoundException();
            }
            InputStream inputStream = resultSet.getBinaryStream(1);
            int n2 = (int)BufferedStreamCopier.copyStreams(inputStream, outputStream, n);
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return n2;
        }
    }

    class SelectJobsAndTypes
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type FROM job_table ORDER BY seqnum";

        public SelectJobsAndTypes() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[] execute() throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<JobIDAndMLType> vector = new Vector<JobIDAndMLType>();
            while (resultSet.next()) {
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new JobIDAndMLType[vector.size()]);
        }
    }

    class SelectNextQueuedJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ?1 AND queuenum > ( SELECT queuenum FROM job_table WHERE jobid = ?2 AND state = ?1 LIMIT 1 ) ORDER BY queuenum LIMIT 1";

        public SelectNextQueuedJob() {
            super(SQL_STRING);
        }

        public Uuid execute(Uuid uuid) throws SQLException {
            int n = 1;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid2 = null;
            if (resultSet.next()) {
                uuid2 = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid2;
        }
    }

    class SelectPreviousQueuedJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ?1 AND queuenum < ( SELECT queuenum FROM job_table WHERE jobid = ?2 AND state = ?1 LIMIT 1 ) ORDER BY queuenum DESC LIMIT 1";

        public SelectPreviousQueuedJob() {
            super(SQL_STRING);
        }

        public Uuid execute(Uuid uuid) throws SQLException {
            int n = 1;
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid2 = null;
            while (resultSet.next()) {
                uuid2 = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid2;
        }
    }

    class SelectJobsAndTypesByArrayOfStates
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type, state FROM job_table ORDER BY state, queuenum, seqnum";

        public SelectJobsAndTypesByArrayOfStates() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[][] execute(int[] nArray) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            ResultSet resultSet = preparedStatement.executeQuery();
            HashMap hashMap = new HashMap();
            for (int n : nArray) {
                hashMap.put(n, new Vector());
            }
            int[] nArray2 = new int[nArray.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            Arrays.sort(nArray2);
            while (resultSet.next()) {
                int n = resultSet.getInt(3);
                if (Arrays.binarySearch(nArray2, n) < 0) continue;
                Vector vector = (Vector)hashMap.get(n);
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return JobIDAndMLType.convertToJobAndTypesArray(nArray, hashMap);
        }
    }

    class SelectJobsAndTypesByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid, type FROM job_table WHERE state = ? ORDER BY queuenum, seqnum";

        public SelectJobsAndTypesByState() {
            super(SQL_STRING);
        }

        public JobIDAndMLType[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<JobIDAndMLType> vector = new Vector<JobIDAndMLType>();
            while (resultSet.next()) {
                vector.add(new JobIDAndMLType(UuidFactory.create((String)resultSet.getString(1)), resultSet.getInt(2)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new JobIDAndMLType[vector.size()]);
        }
    }

    class SelectJobsByJobStateWithTasksInState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT task_table.jobid  FROM task_table INNER JOIN job_table ON task_table.jobid = job_table.jobid WHERE job_table.state = ? AND task_table.state = ? ORDER BY task_table.seqnum";

        public SelectJobsByJobStateWithTasksInState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectJobsByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? ORDER BY queuenum, seqnum";

        public SelectJobsByState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectJobById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT seqnum, state, type, job FROM job_table WHERE jobid = ? ORDER BY seqnum";

        public SelectJobById() {
            super(SQL_STRING);
        }

        public JobImpl execute(Uuid uuid) throws SQLException, WorkUnitStorageException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            JobImpl jobImpl = null;
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                int n = resultSet.getInt(2);
                int n2 = resultSet.getInt(3);
                try (ObjectInputStream objectInputStream = new ObjectInputStream(resultSet.getBinaryStream(4));){
                    jobImpl = JobImpl.create(objectInputStream, l, n, n2);
                }
                catch (IOException | ClassNotFoundException exception) {
                    throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.DeserializeJobError, (Throwable)exception, new Object[0]);
                }
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return jobImpl;
        }
    }

    class SelectFirstJobByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT jobid FROM job_table WHERE state = ? ORDER BY queuenum, seqnum";

        public SelectFirstJobByState() {
            super(SQL_STRING);
        }

        public Uuid execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Uuid uuid = null;
            if (resultSet.next()) {
                uuid = UuidFactory.create((String)resultSet.getString(1));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return uuid;
        }
    }

    class SelectTasksByJobIdAndBeforeState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state < ? ORDER BY seqnum";

        public SelectTasksByJobIdAndBeforeState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectNumberOfTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state = ? ORDER BY seqnum";

        public SelectNumberOfTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n, int n2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next() && vector.size() < n2) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByJobIdAndArrayOfStates
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid, state FROM task_table WHERE jobid = ? ORDER BY seqnum";

        public SelectTasksByJobIdAndArrayOfStates() {
            super(SQL_STRING);
        }

        public Uuid[][] execute(Uuid uuid, int[] nArray) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Arrays.sort(nArray);
            HashMap hashMap = new HashMap();
            for (int n : nArray) {
                hashMap.put(n, new Vector());
            }
            while (resultSet.next()) {
                int n = resultSet.getInt(2);
                if (Arrays.binarySearch(nArray, n) == -1) continue;
                Vector vector = (Vector)hashMap.get(n);
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return StorageHelpers.createArrayOfUuids(nArray, hashMap);
        }
    }

    class SelectTasksByJobIdAndState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? AND state = ? ORDER BY seqnum";

        public SelectTasksByJobIdAndState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid, int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.setInt(2, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                Uuid uuid2 = UuidFactory.create((String)resultSet.getString(1));
                vector.add(uuid2);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByState
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE state = ? ORDER BY seqnum";

        public SelectTasksByState() {
            super(SQL_STRING);
        }

        public Uuid[] execute(int n) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                Uuid uuid = UuidFactory.create((String)resultSet.getString(1));
                vector.add(uuid);
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTasksByJobId
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT taskid FROM task_table WHERE jobid = ? ORDER BY seqnum";

        public SelectTasksByJobId() {
            super(SQL_STRING);
        }

        public Uuid[] execute(Uuid uuid) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Uuid> vector = new Vector<Uuid>();
            while (resultSet.next()) {
                vector.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return vector.toArray(new Uuid[vector.size()]);
        }
    }

    class SelectTaskById
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT seqnum, state, task FROM task_table WHERE taskid = ? ORDER BY seqnum";

        public SelectTaskById() {
            super(SQL_STRING);
        }

        public TaskImpl execute(Uuid uuid) throws SQLException, WorkUnitStorageException {
            PreparedStatement preparedStatement = this.getStatement(H2DatabaseStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            TaskImpl taskImpl = null;
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                int n = resultSet.getInt(2);
                try (ObjectInputStream objectInputStream = new ObjectInputStream(resultSet.getBinaryStream(3));){
                    taskImpl = TaskImpl.create(objectInputStream, l, n);
                }
                catch (IOException | ClassNotFoundException exception) {
                    throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.DeserializeTaskError, (Throwable)exception, new Object[0]);
                }
            }
            resultSet.close();
            this.releaseStatement(preparedStatement);
            return taskImpl;
        }
    }

    private static final class RemoveFromQueueException
    extends WorkUnitStorageException {
        RemoveFromQueueException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.RemoveFromQueueError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class AddToQueueException
    extends WorkUnitStorageException {
        AddToQueueException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.AddToQueueError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class CountTasksException
    extends WorkUnitStorageException {
        CountTasksException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.CountTasksError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class CopyDataException
    extends DataStorageException {
        CopyDataException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.CopyDataError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class WorkUnitDataRemoveException
    extends DataStorageException {
        WorkUnitDataRemoveException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.WorkUnitDataRemoveError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class RemoveTaskException
    extends WorkUnitStorageException {
        RemoveTaskException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.RemoveTaskError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class JobDataRemoveException
    extends DataStorageException {
        JobDataRemoveException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.JobDataRemoveError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class RemoveJobException
    extends WorkUnitStorageException {
        RemoveJobException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.RemoveJobError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class AppendDataException
    extends DataStorageException {
        AppendDataException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.AppendDataError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class UpdateDataException
    extends DataStorageException {
        UpdateDataException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.UpdateDataError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class UpdateTaskException
    extends WorkUnitStorageException {
        UpdateTaskException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.UpdateTaskError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class UpdateJobException
    extends WorkUnitStorageException {
        UpdateJobException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.UpdateJobError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class DemoteJobException
    extends WorkUnitStorageException {
        DemoteJobException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.DemoteJobError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class PromoteJobException
    extends WorkUnitStorageException {
        PromoteJobException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.PromoteJobError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class ReadDataException
    extends DataStorageException {
        ReadDataException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.ReadDataError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class NullWorkUnitIDException
    extends WorkUnitNotFoundException {
        NullWorkUnitIDException() {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.NullWorkUnitID, new Object[0]);
        }
    }

    private static final class PutDataException
    extends DataStorageException {
        PutDataException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)DataStorageErrorCode.PutDataError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class WriteTaskException
    extends WorkUnitStorageException {
        WriteTaskException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.WriteTaskError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class WriteJobException
    extends WorkUnitStorageException {
        WriteJobException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.WriteJobError, (Throwable)sQLException, new Object[0]);
        }
    }
}

