/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.H2CredentialStorage;
import com.mathworks.toolbox.distcomp.storage.H2DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.H2DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.StorageFactory;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;

abstract class H2StorageFactory
implements StorageFactory {
    private final String fProtocol;

    H2StorageFactory(String string) {
        this.fProtocol = string;
    }

    protected DatabaseConnectionPool getConnectionPool() throws StorageInitException {
        return H2DatabaseConnectionPool.getH2DatabaseConnectionPool(this.getDatabaseURL());
    }

    protected String getProtocol() {
        return this.fProtocol;
    }

    protected abstract String getDatabaseURL();

    @Override
    public DatabaseStorage createDatabaseStorage() throws StorageInitException {
        return new H2DatabaseStorage(this.getConnectionPool());
    }

    @Override
    public CredentialStorage createCredentialStorage() throws StorageInitException {
        return new H2CredentialStorage(this.getConnectionPool());
    }
}

