/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.InMemoryDataStorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.util.BufferedStreamCopier;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public final class InMemoryDataStorage
implements DataStorage {
    private final Lock fLock = new ReentrantLock();
    private final Map<Uuid, byte[]> fData = new HashMap<Uuid, byte[]>();
    private final Map<Uuid, Set<Uuid>> fJobToDataMap = new HashMap<Uuid, Set<Uuid>>();

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        this.fLock.lock();
        try {
            if (this.fData.containsKey(uuid)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BufferedStreamCopier.copyStreams(inputStream, byteArrayOutputStream, n);
                this.fData.put(uuid, byteArrayOutputStream.toByteArray());
            }
        }
        catch (IOException iOException) {
            throw new UpdateInMemoryDataException(iOException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws DataStorageException {
        this.fLock.lock();
        try {
            byte[] byArray = this.readData(uuid);
            outputStream.write(byArray);
            int n2 = byArray.length;
            return n2;
        }
        catch (IOException iOException) {
            throw new ReadInMemoryDataException(iOException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public byte[] readData(Uuid uuid) throws DataStorageException {
        this.fLock.lock();
        try {
            if (this.fData.containsKey(uuid)) {
                byte[] byArray = this.fData.get(uuid);
                return byArray;
            }
            throw new InMemoryDataNotFoundException();
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeData(Uuid uuid) throws DataStorageException {
        this.fLock.lock();
        try {
            this.fData.remove(uuid);
            for (Map.Entry<Uuid, Set<Uuid>> entry : this.fJobToDataMap.entrySet()) {
                Set<Uuid> set = entry.getValue();
                set.remove(uuid);
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public Uuid copyData(Uuid uuid) throws DataStorageException {
        Uuid uuid2 = UuidFactory.generate();
        this.fLock.lock();
        try {
            if (this.fData.containsKey(uuid)) {
                byte[] byArray = this.fData.get(uuid);
                byte[] byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.fData.put(uuid2, byArray2);
                Uuid uuid3 = this.findJobForData(uuid);
                if (uuid3 != null) {
                    this.fJobToDataMap.get(uuid3).add(uuid2);
                }
                Uuid uuid4 = uuid2;
                return uuid4;
            }
            throw new InMemoryDataNotFoundException();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private Uuid findJobForData(Uuid uuid) {
        for (Map.Entry<Uuid, Set<Uuid>> entry : this.fJobToDataMap.entrySet()) {
            for (Uuid uuid2 : entry.getValue()) {
                if (!uuid2.equals((Object)uuid)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws DataStorageException {
        block6: {
            this.fLock.lock();
            try {
                if (this.fData.containsKey(uuid)) {
                    byte[] byArray = this.fData.get(uuid);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream.write(byArray);
                    BufferedStreamCopier.copyStreams(inputStream, byteArrayOutputStream, n);
                    this.fData.put(uuid, byteArrayOutputStream.toByteArray());
                    break block6;
                }
                throw new InMemoryDataNotFoundException();
            }
            catch (IOException iOException) {
                throw new AppendInMemoryDataException(iOException);
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws DataStorageException {
        this.putJobData(uuid, uuid3, inputStream, n);
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws DataStorageException {
        this.fLock.lock();
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedStreamCopier.copyStreams(inputStream, byteArrayOutputStream, n);
            this.fData.put(uuid2, byteArrayOutputStream.toByteArray());
            if (this.fJobToDataMap.containsKey(uuid)) {
                this.fJobToDataMap.get(uuid).add(uuid2);
            } else {
                HashSet<Uuid> hashSet = new HashSet<Uuid>();
                hashSet.add(uuid2);
                this.fJobToDataMap.put(uuid, hashSet);
            }
        }
        catch (IOException iOException) {
            throw new PutInMemoryDataException(iOException);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws DataStorageException {
        block5: {
            this.fLock.lock();
            try {
                if (this.fJobToDataMap.containsKey(uuid)) {
                    Set<Uuid> set = this.fJobToDataMap.get(uuid);
                    for (Uuid uuid2 : set) {
                        this.fData.remove(uuid2);
                    }
                    this.fJobToDataMap.remove(uuid);
                    break block5;
                }
                throw new InMemoryDataNotFoundException();
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws StorageException {
        this.fLock.lock();
        try {
            this.fJobToDataMap.clear();
            this.fData.clear();
        }
        finally {
            this.fLock.unlock();
        }
    }

    private static final class PutInMemoryDataException
    extends DataStorageException {
        PutInMemoryDataException(IOException iOException) {
            super((I18nMatlabIdentifiedMessageCreator)InMemoryDataStorageErrorCode.PutInMemoryDataError, (Throwable)iOException, new Object[0]);
        }
    }

    private static final class AppendInMemoryDataException
    extends DataStorageException {
        AppendInMemoryDataException(IOException iOException) {
            super((I18nMatlabIdentifiedMessageCreator)InMemoryDataStorageErrorCode.AppendInMemoryDataError, (Throwable)iOException, new Object[0]);
        }
    }

    private static final class InMemoryDataNotFoundException
    extends DataNotFoundException {
        InMemoryDataNotFoundException() {
            super((I18nMatlabIdentifiedMessageCreator)InMemoryDataStorageErrorCode.InMemoryDataNotFoundError, new Object[0]);
        }
    }

    private static final class ReadInMemoryDataException
    extends DataStorageException {
        ReadInMemoryDataException(IOException iOException) {
            super((I18nMatlabIdentifiedMessageCreator)InMemoryDataStorageErrorCode.ReadInMemoryDataError, (Throwable)iOException, new Object[0]);
        }
    }

    private static final class UpdateInMemoryDataException
    extends DataStorageException {
        UpdateInMemoryDataException(IOException iOException) {
            super((I18nMatlabIdentifiedMessageCreator)InMemoryDataStorageErrorCode.UpdateInMemoryDataError, (Throwable)iOException, new Object[0]);
        }
    }
}

