/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileErrorCode;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileFactory;
import com.mathworks.toolbox.distcomp.storage.fileblobs.FilePathAllocator;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class BlobFileAllocator {
    private File fRootDirectory;
    private FilePathAllocator fFilePathAllocator;
    private BlobFileFactory fBlobFileFactory;

    public BlobFileAllocator(File file, FilePathAllocator filePathAllocator, BlobFileFactory blobFileFactory) {
        this.fRootDirectory = file;
        this.fFilePathAllocator = filePathAllocator;
        this.fBlobFileFactory = blobFileFactory;
    }

    public BlobFile create(String string) throws BlobFileException {
        File file = this.getFilePath(string);
        return this.fBlobFileFactory.createBlobFile(file);
    }

    public BlobFile copy(BlobFile blobFile, String string) throws BlobFileException {
        File file = this.getFilePath(string);
        try {
            return blobFile.copy(file);
        }
        catch (IOException iOException) {
            throw new CopyBlobFileException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFilePath(String string) throws BlobFileException {
        File file = this.fFilePathAllocator.allocateFilePath();
        try {
            File file2 = new File(this.fRootDirectory, file.getPath());
            File file3 = new File(file2, string);
            BlobFileAllocator blobFileAllocator = this;
            synchronized (blobFileAllocator) {
                FileUtils.forceMkdir((File)file2);
            }
            if (file3.exists()) {
                throw new BlobFileExistsException(string);
            }
            return file3;
        }
        catch (IOException iOException) {
            this.fFilePathAllocator.freeFilePath(file);
            throw new BlobFileAllocationException(iOException);
        }
    }

    public boolean delete(BlobFile blobFile) throws BlobFileException {
        boolean bl = true;
        if (blobFile.exists() && (bl = blobFile.delete())) {
            this.fFilePathAllocator.freeFilePath(this.getDirectoryRelativeToRoot(blobFile.getParentFile()));
        }
        return bl;
    }

    private File getDirectoryRelativeToRoot(File file) {
        return new File(this.fRootDirectory.toURI().relativize(file.toURI()).getPath());
    }

    private static final class BlobFileAllocationException
    extends BlobFileException {
        BlobFileAllocationException(IOException iOException) {
            super(BlobFileErrorCode.BlobFileAllocationError, (Throwable)iOException, new Object[0]);
        }
    }

    private static final class BlobFileExistsException
    extends BlobFileException {
        BlobFileExistsException(String string) {
            super(BlobFileErrorCode.BlobFileExistsError, string);
        }
    }

    private static final class CopyBlobFileException
    extends BlobFileException {
        CopyBlobFileException(IOException iOException) {
            super(BlobFileErrorCode.CopyBlobFileError, (Throwable)iOException, new Object[0]);
        }
    }
}

