/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.toolbox.distcomp.storage.fileblobs.DirectoryIterator;
import com.mathworks.toolbox.distcomp.storage.fileblobs.FilePathAllocationChecker;
import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import com.mathworks.toolbox.distcomp.storage.fileblobs.TreeDirectoryIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class FilePathAllocator {
    private int fMaxFilesPerDirectory;
    private DirectoryIterator fDirectoryIterator;
    private static final List<String> DIRECTORY_NAMES = Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
    private TreeMap<File, Integer> fFreeDirectories = new TreeMap(new PathLengthComparator());
    private Set<File> fFullDirectories = new HashSet<File>();
    private File fPersistenceFile;
    private File fStartPath = null;

    private FilePathAllocator(File file, int n, DirectoryIterator directoryIterator) {
        this.fMaxFilesPerDirectory = n;
        this.fDirectoryIterator = directoryIterator;
        this.fPersistenceFile = file;
    }

    public static synchronized FilePathAllocator createFilePathAllocator(File file, File file2, int n) {
        FilePathAllocator filePathAllocator = new FilePathAllocator(file, n, new TreeDirectoryIterator(DIRECTORY_NAMES));
        if (filePathAllocator.recover(file)) {
            filePathAllocator.updateInBackground(file2);
        }
        return filePathAllocator;
    }

    public static FilePathAllocator createNonPersistedFilePathAllocator(int n, DirectoryIterator directoryIterator) {
        return new FilePathAllocator(null, n, directoryIterator);
    }

    public synchronized File allocateFilePath() {
        File file;
        if (!this.fFreeDirectories.isEmpty()) {
            file = this.fFreeDirectories.firstKey();
        } else {
            file = this.fDirectoryIterator.nextDirectory();
            try {
                if (this.fPersistenceFile != null) {
                    this.snapshot();
                }
            }
            catch (IOException iOException) {
                Log.LOGGER.warning("Unable to persist the FilePathAllocator's state, due to IOException: " + iOException.getMessage());
            }
            this.fFreeDirectories.put(file, this.fMaxFilesPerDirectory);
        }
        this.decrementFreeDirectories(file);
        return file;
    }

    public synchronized void freeFilePath(File file) {
        if (this.fFreeDirectories.containsKey(file)) {
            this.incrementFreeDirectories(file);
        } else if (this.fFullDirectories.contains(file)) {
            this.fFullDirectories.remove(file);
            this.fFreeDirectories.put(file, 1);
        }
    }

    public synchronized void update(Map<File, Integer> map, Set<File> set) {
        assert (!this.containsAny(this.fFullDirectories, set)) : "fullDirectories must not contain any directories already tracked by the FilePathAllocator";
        assert (!this.containsAny(this.fFreeDirectories.entrySet(), map.entrySet())) : "freeDirectories must not contain any directories already tracked by the FilePathAllocator";
        this.fFullDirectories.addAll(set);
        this.fFreeDirectories.putAll(map);
    }

    private <E> boolean containsAny(Collection<E> collection, Collection<E> collection2) {
        for (E e : collection) {
            if (!collection2.contains(e)) continue;
            return true;
        }
        return false;
    }

    private void decrementFreeDirectories(File file) {
        int n = this.fFreeDirectories.get(file) - 1;
        if (n <= 0) {
            this.fFreeDirectories.remove(file);
            this.fFullDirectories.add(file);
        } else {
            this.fFreeDirectories.put(file, n);
        }
    }

    private void incrementFreeDirectories(File file) {
        int n = this.fFreeDirectories.get(file) + 1;
        if (n <= this.fMaxFilesPerDirectory) {
            this.fFreeDirectories.put(file, n);
        }
    }

    private void updateInBackground(File file) {
        assert (this.fStartPath != null) : "The FilePathAllocator can only be updated after recovery";
        FilePathAllocationChecker filePathAllocationChecker = new FilePathAllocationChecker(file, this.fMaxFilesPerDirectory, new TreeDirectoryIterator(DIRECTORY_NAMES));
        BackgroundUpdater backgroundUpdater = new BackgroundUpdater(this, filePathAllocationChecker, this.fStartPath);
        Thread thread = new Thread(backgroundUpdater);
        thread.setName("FilePathAllocator updater");
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recover(File file) {
        if (!file.exists()) {
            return false;
        }
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.fDirectoryIterator = (DirectoryIterator)objectInputStream.readObject();
            this.fStartPath = this.fDirectoryIterator.nextDirectory();
            this.snapshot();
            this.fFreeDirectories.put(this.fStartPath, this.fMaxFilesPerDirectory);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            Log.LOGGER.warning("Unable to recover DirectoryIterator from disk: " + iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.LOGGER.warning("Unable to recover DirectoryIterator from disk: " + classNotFoundException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot() throws IOException {
        try (ObjectOutputStream objectOutputStream = null;){
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.fPersistenceFile));
            objectOutputStream.writeObject(this.fDirectoryIterator);
        }
    }

    private static final class BackgroundUpdater
    implements Runnable {
        private FilePathAllocationChecker fFilePathAllocationChecker;
        private FilePathAllocator fFilePathAllocator;
        private File fStopAt;

        BackgroundUpdater(FilePathAllocator filePathAllocator, FilePathAllocationChecker filePathAllocationChecker, File file) {
            this.fFilePathAllocator = filePathAllocator;
            this.fStopAt = file;
            this.fFilePathAllocationChecker = filePathAllocationChecker;
        }

        @Override
        public void run() {
            this.fFilePathAllocationChecker.checkDirectories(this.fStopAt);
            this.fFilePathAllocationChecker.updateAllocator(this.fFilePathAllocator);
        }
    }

    static class PathLengthComparator
    implements Comparator<File>,
    Serializable {
        PathLengthComparator() {
        }

        @Override
        public int compare(File file, File file2) {
            int n;
            int n2 = file.getPath().length();
            if (n2 < (n = file2.getPath().length())) {
                return -1;
            }
            if (n2 == n) {
                return file.compareTo(file2);
            }
            return 1;
        }
    }
}

