/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.fileblobs;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.storage.Cache;
import com.mathworks.toolbox.distcomp.storage.CachedPreparedStatement;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFile;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileErrorCode;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileException;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileFactory;
import com.mathworks.toolbox.distcomp.storage.fileblobs.BlobFileStorage;
import com.mathworks.toolbox.distcomp.storage.fileblobs.Log;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class H2BlobFileStorage
implements BlobFileStorage {
    private transient Cache<Uuid, BlobFile> fBlobFileCache;
    private transient Connection fConn;
    private transient DatabaseConnectionPool fDatabaseConnectionPool;
    private final transient GetBlobFile fGetBlobFile = new GetBlobFile();
    private final transient GetAllDataForJob fGetAllDataForJob = new GetAllDataForJob();
    private final transient InsertData fInsertData = new InsertData();
    private final transient UpdateData fUpdateData = new UpdateData();
    private final transient DeleteData fDeleteData = new DeleteData();
    private final transient CopyData fCopyData = new CopyData();
    private static final String BLOBFILE_TABLE_NAME = "blobfile_table";
    private static final String DATA_SEQUENCE_NAME = "data_seq_key";
    private static final String QUOTED_DATA_SEQUENCE_NAME = "'data_seq_key'";
    private Semaphore fDataTableWriteLock = new Semaphore(1, true);
    private BlobFileFactory fBlobFileFactory;

    public H2BlobFileStorage(Cache<Uuid, BlobFile> cache, DatabaseConnectionPool databaseConnectionPool, BlobFileFactory blobFileFactory) throws StorageInitException {
        this.fBlobFileFactory = blobFileFactory;
        this.fBlobFileCache = cache;
        this.fConn = databaseConnectionPool.openConnectionToDatabase();
        if (this.fConn == null) {
            throw new StorageInitException((BaseMsgID)new mjs.DatabaseNotFound());
        }
        this.fDatabaseConnectionPool = databaseConnectionPool;
    }

    @Override
    public void close() throws StorageException {
        this.fBlobFileCache.clear();
        this.fDatabaseConnectionPool.closeConnection(this.fConn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BlobFile getBlobFile(Uuid uuid) throws DataStorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fBlobFileCache.lock(uuid);){
            BlobFile blobFile = this.fBlobFileCache.get(cacheToken);
            if (blobFile == null) {
                blobFile = this.fGetBlobFile.execute(uuid);
            }
            if (blobFile == null) {
                throw new BlobFileNotFoundException();
            }
            BlobFile blobFile2 = blobFile;
            return blobFile2;
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to read blob file information from H2 database", sQLException);
            throw new GetBlobFileException(sQLException);
        }
        catch (BlobFileException blobFileException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to retrieve blob file", blobFileException);
            throw new GetBlobFileException(blobFileException);
        }
    }

    @Override
    public List<Uuid> getDataForJobAndTasks(Uuid uuid) throws DataStorageException {
        try {
            return this.fGetAllDataForJob.execute(uuid);
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to read blob file information from H2 database", sQLException);
            throw new GetAllBlobFilesException(sQLException);
        }
    }

    @Override
    public void putBlobFileForJob(Uuid uuid, Uuid uuid2, BlobFile blobFile) throws DataStorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fBlobFileCache.lock(uuid2);){
            this.fInsertData.execute(uuid, uuid2, blobFile);
            this.fBlobFileCache.put(cacheToken, blobFile);
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to update H2 database with blob file information", sQLException);
            throw new PutBlobFileInfoException(sQLException);
        }
    }

    @Override
    public void putBlobFileForTask(Uuid uuid, Uuid uuid2, Uuid uuid3, BlobFile blobFile) throws DataStorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fBlobFileCache.lock(uuid3);){
            this.fInsertData.execute(uuid, uuid2, uuid3, blobFile);
            this.fBlobFileCache.put(cacheToken, blobFile);
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to update H2 database with blob file information", sQLException);
            throw new PutBlobFileInfoException(sQLException);
        }
    }

    @Override
    public Uuid copyBlobFile(Uuid uuid) throws DataStorageException {
        assert (uuid != null) : "cannot copy null data";
        try {
            Uuid uuid2 = UuidFactory.generate();
            this.fCopyData.execute(uuid, uuid2);
            return uuid2;
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to copy blob file information in H2 database", sQLException);
            throw new CopyBlobFileInfoException(sQLException);
        }
    }

    @Override
    public void updateBlobFile(Uuid uuid, BlobFile blobFile) throws DataStorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fBlobFileCache.lock(uuid);){
            this.fUpdateData.execute(uuid, blobFile);
            this.fBlobFileCache.put(cacheToken, blobFile);
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to write blob file information to H2 database", sQLException);
            throw new WriteBlobFileInfoException(sQLException);
        }
    }

    @Override
    public void removeBlobFile(Uuid uuid) throws DataStorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fBlobFileCache.lock(uuid);){
            this.fBlobFileCache.remove(cacheToken);
            this.fDeleteData.execute(uuid);
        }
        catch (SQLException sQLException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to delete blob file information from H2 database", sQLException);
            throw new RemoveBlobFileInfoException(sQLException);
        }
    }

    private final class CopyData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO blobfile_table (seqnum, jobid, taskid, dataid, filepath, dataSize) SELECT NEXTVAL('data_seq_key'), jobid, taskid, ?, filepath, dataSize FROM blobfile_table WHERE dataid = ? ORDER BY seqnum";

        CopyData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Uuid uuid, Uuid uuid2) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            preparedStatement.setString(1, uuid2.toString());
            preparedStatement.setString(2, uuid.toString());
            H2BlobFileStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                preparedStatement.executeUpdate();
            }
            finally {
                H2BlobFileStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
        }
    }

    private final class DeleteData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "DELETE FROM blobfile_table WHERE dataid = ?";

        DeleteData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            H2BlobFileStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2BlobFileStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    private final class UpdateData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "UPDATE blobfile_table SET filepath = ?, dataSize = ? WHERE dataid = ?";

        UpdateData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, BlobFile blobFile) throws SQLException {
            int n;
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            preparedStatement.setObject(1, (Object)blobFile.getPath(), 12);
            preparedStatement.setLong(2, blobFile.getDataSize());
            preparedStatement.setString(3, uuid.toString());
            H2BlobFileStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2BlobFileStorage.this.fDataTableWriteLock.release();
            }
            this.releaseStatement(preparedStatement);
            return n;
        }
    }

    private final class InsertData
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "INSERT INTO blobfile_table VALUES(NEXTVAL('data_seq_key'),?,?,?,?,?)";

        InsertData() {
            super(SQL_STRING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, BlobFile blobFile) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setNull(2, 0);
                preparedStatement.setString(3, uuid2.toString());
                preparedStatement.setObject(4, (Object)blobFile.getPath(), 12);
                preparedStatement.setLong(5, blobFile.getDataSize());
                int n = this.execute(preparedStatement);
                return n;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Uuid uuid, Uuid uuid2, Uuid uuid3, BlobFile blobFile) throws SQLException {
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            try {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setString(2, uuid2.toString());
                preparedStatement.setString(3, uuid3.toString());
                preparedStatement.setObject(4, (Object)blobFile.getPath(), 12);
                preparedStatement.setLong(5, blobFile.getDataSize());
                int n = this.execute(preparedStatement);
                return n;
            }
            finally {
                this.releaseStatement(preparedStatement);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int execute(PreparedStatement preparedStatement) throws SQLException {
            int n;
            H2BlobFileStorage.this.fDataTableWriteLock.acquireUninterruptibly();
            try {
                n = preparedStatement.executeUpdate();
            }
            finally {
                H2BlobFileStorage.this.fDataTableWriteLock.release();
            }
            return n;
        }
    }

    private final class GetAllDataForJob
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT dataid FROM blobfile_table WHERE jobid = ?";

        GetAllDataForJob() {
            super(SQL_STRING);
        }

        public List<Uuid> execute(Uuid uuid) throws SQLException {
            ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(UuidFactory.create((String)resultSet.getString(1)));
            }
            return arrayList;
        }
    }

    private final class GetBlobFile
    extends CachedPreparedStatement {
        private static final String SQL_STRING = "SELECT filepath, dataSize FROM blobfile_table WHERE dataid = ?";

        GetBlobFile() {
            super(SQL_STRING);
        }

        public BlobFile execute(Uuid uuid) throws SQLException, BlobFileException {
            PreparedStatement preparedStatement = this.getStatement(H2BlobFileStorage.this.fConn);
            preparedStatement.setString(1, uuid.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            BlobFile blobFile = null;
            if (resultSet.next()) {
                blobFile = H2BlobFileStorage.this.fBlobFileFactory.createBlobFile(new File(resultSet.getString(1)), resultSet.getLong(2));
            }
            return blobFile;
        }
    }

    private static final class RemoveBlobFileInfoException
    extends DataStorageException {
        RemoveBlobFileInfoException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.RemoveBlobFileInfoError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class WriteBlobFileInfoException
    extends DataStorageException {
        WriteBlobFileInfoException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.WriteBlobFileInfoError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class CopyBlobFileInfoException
    extends DataStorageException {
        CopyBlobFileInfoException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.CopyBlobFileInfoError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class PutBlobFileInfoException
    extends DataStorageException {
        PutBlobFileInfoException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.PutBlobFileInfoError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class GetAllBlobFilesException
    extends DataStorageException {
        GetAllBlobFilesException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.GetAllBlobFilesError, (Throwable)sQLException, new Object[0]);
        }
    }

    private static final class GetBlobFileException
    extends DataStorageException {
        GetBlobFileException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.GetBlobFileError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class BlobFileNotFoundException
    extends DataNotFoundException {
        BlobFileNotFoundException() {
            super((I18nMatlabIdentifiedMessageCreator)BlobFileErrorCode.BlobFileNotFoundError, new Object[0]);
        }
    }
}

