/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.mwswing.MJMultilineCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.settings.SettingAccessException;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingTypeException;
import com.mathworks.services.settings.SettingValidationException;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.desk.ClientSessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.desk.ProfileDesktopMenuProvider;
import com.mathworks.toolbox.distcomp.ui.desk.RestartPoolConfirmationDialog;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.ParallelSettings;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileSelector;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public final class ParallelPreferencePanel
extends StyleGuidePanel {
    private static ParallelPreferencePanel sParallelPreferencePanel = null;
    private final SessionInfoProvider fSessionInfoProvider;
    private final ParallelSettings fParallelSettings = new ParallelSettings();
    private ProfileSelector fProfileSelector;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    private MJFormattedTextField fPreferredWorkerSizeTextField;
    private MJMultilineCheckBox fAutoOpenCheckBox;
    private JCheckBox fAutoShutdownCheckBox;
    private MJFormattedTextField fIdleTimeOutTextField;
    private static final int PROFILE_SELECTOR_MIN_WIDTH = 200;
    private static final int CLUSTER_PROFILE_LINK_MIN_WIDTH = 200;
    private static final int CLUSTER_PROFILE_LINK_MIN_HEIGHT = 40;
    private static final int HORIZONTAL_INSET = 0;
    private static final int TOP_INSET = 5;
    private static final int NOTE_LABEL_LEFT_INSET = 10;
    private static final int NOTE_PANEL_PREFERRED_HEIGHT = 35;
    private static final int TEXT_FIELD_MIN_WIDTH = 75;
    private static final String EMPTY_VALUE = "";
    private static final String INF = "inf";
    private static final Object[] NO_INPUTS = new Object[0];
    private static final int NO_OUTPUTS = 0;
    private static final boolean SHOW_OUTPUT = true;
    private static final String RESTART_FUNCTION = "parallel.internal.ui.PoolHelper.restartPoolOnPreferredNumWorkersChange";

    private ParallelPreferencePanel(SessionInfoProvider sessionInfoProvider) throws SettingNotFoundException, SettingTypeException {
        this.fSessionInfoProvider = sessionInfoProvider;
        JComponent jComponent = this.createClusterSection();
        JComponent jComponent2 = this.createParallelPoolSection();
        this.addListeners();
        this.addLine(jComponent);
        this.addLine(jComponent2);
        this.addLine(new JPanel(), 8);
    }

    @Override
    protected int getTopInset() {
        return 5;
    }

    @Override
    protected int getLeftInset() {
        return 0;
    }

    @Override
    protected int getRightInset() {
        return 0;
    }

    private JComponent createClusterSection() {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.setBorder(BorderFactory.createTitledBorder(sRes.getString("Preference.Clusters.Heading")));
        ProfileManager profileManager = ProfileManager.Provider.INSTANCE.getProfileManager();
        Selection<Profile> selection = new Selection<Profile>(profileManager.getDefaultProfile());
        this.fProfileSelector = new ProfileSelector(profileManager, selection, false);
        Dimension dimension = this.fProfileSelector.getComponent().getPreferredSize();
        this.fProfileSelector.getComponent().setMinimumSize(new Dimension(200, (int)dimension.getHeight()));
        this.fProfileSelector.getComponent().setPreferredSize(new Dimension(200, (int)dimension.getHeight()));
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(sRes.getString("Preference.ProfileManager.HyperLinkLabel"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                ProfileDesktopMenuProvider.showProfileManagerUI();
            }
        });
        hyperlinkTextLabel.getComponent().setPreferredSize(new Dimension(200, 40));
        hyperlinkTextLabel.getComponent().setName("Preference.ProfileManager.HyperLinkLabel");
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{new JLabel(sRes.getString("Preference.DefaultCluster.Label")), this.fProfileSelector.getComponent(), new JPanel()}}, 0, 2);
        styleGuidePanel.addLine(hyperlinkTextLabel.getComponent(), 8);
        return styleGuidePanel;
    }

    private JComponent createParallelPoolSection() throws SettingTypeException, SettingNotFoundException {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel();
        styleGuidePanel.setBorder(BorderFactory.createTitledBorder(sRes.getString("Preference.ParallelPool.Heading")));
        JLabel jLabel = new JLabel(sRes.getString("Preference.ParallelPool.PreferredSizeLabel"));
        PreferredWorkerSizeFormatter preferredWorkerSizeFormatter = new PreferredWorkerSizeFormatter();
        this.fPreferredWorkerSizeTextField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)preferredWorkerSizeFormatter);
        Dimension dimension = this.fPreferredWorkerSizeTextField.getPreferredSize();
        this.fPreferredWorkerSizeTextField.setPreferredSize(new Dimension(75, (int)dimension.getHeight()));
        this.fPreferredWorkerSizeTextField.setMinimumSize(new Dimension(75, (int)dimension.getHeight()));
        this.fPreferredWorkerSizeTextField.setValue((Object)this.fParallelSettings.getPreferredNumWorkers());
        JLabel jLabel2 = new JLabel(sRes.getString("Preference.ParallelPool.PreferredSizeNoteLabel"));
        this.fAutoOpenCheckBox = new MJMultilineCheckBox(sRes.getString("Preference.ParallelPool.AutoOpenCheckBox"), this.isAutoOpenParallelPool());
        this.fAutoShutdownCheckBox = new JCheckBox(sRes.getString("Preference.ParallelPool.AutoShutdownCheckBox"), this.isAutoShutdownParallelPool());
        IdleTimeOutFormatter idleTimeOutFormatter = new IdleTimeOutFormatter();
        this.fIdleTimeOutTextField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)idleTimeOutFormatter);
        Dimension dimension2 = this.fIdleTimeOutTextField.getPreferredSize();
        this.fIdleTimeOutTextField.setPreferredSize(new Dimension(75, (int)dimension2.getHeight()));
        this.fIdleTimeOutTextField.setMinimumSize(new Dimension(75, (int)dimension2.getHeight()));
        this.fIdleTimeOutTextField.setValue((Object)this.fParallelSettings.getFactoryIdleTimeout());
        this.updateIdleTimeoutComponent();
        JLabel jLabel3 = new JLabel(sRes.getString("Preference.ParallelPool.AutoShutdownAdditionalLabel"));
        this.fAutoShutdownCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParallelPreferencePanel.this.fIdleTimeOutTextField.setEnabled(ParallelPreferencePanel.this.fAutoShutdownCheckBox.isSelected());
            }
        });
        StyleGuidePanel styleGuidePanel2 = new StyleGuidePanel(){

            @Override
            protected int getLeftInset() {
                return 25;
            }

            @Override
            protected int getTopInset() {
                return 0;
            }
        };
        styleGuidePanel2.addLine((JComponent[][])new JComponent[][]{{this.fIdleTimeOutTextField, jLabel3, null}}, 8, 2);
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel.addLine(this.fAutoShutdownCheckBox, 8);
        styleGuideEmptyPanel.addLine((JComponent)((Object)styleGuidePanel2));
        StyleGuideEmptyPanel styleGuideEmptyPanel2 = new StyleGuideEmptyPanel(){

            @Override
            protected int getLeftInset() {
                return 10;
            }
        };
        styleGuideEmptyPanel2.addLine(jLabel2, 8);
        styleGuideEmptyPanel2.setPreferredSize(new Dimension(styleGuideEmptyPanel2.getWidth(), 35));
        styleGuidePanel.addLine((JComponent[][])new JComponent[][]{{jLabel, this.fPreferredWorkerSizeTextField, null}}, 0, 2);
        styleGuidePanel.addLine((JComponent)((Object)styleGuideEmptyPanel2), 0);
        styleGuidePanel.addLine((JComponent)this.fAutoOpenCheckBox, 0);
        styleGuidePanel.addLine((JComponent)((Object)styleGuideEmptyPanel), 0);
        styleGuidePanel.addLine(new JPanel(), 8);
        this.fPreferredWorkerSizeTextField.setName("Preference.Pool.PreferredSizeTextField");
        this.fAutoOpenCheckBox.getCheckBox().setName("Preference.Pool.AutoOpenCheckBox");
        this.fAutoShutdownCheckBox.setName("Preference.Pool.AutoShutdownCheckBox");
        this.fIdleTimeOutTextField.setName("Preference.Pool.IdleTimeoutTextField");
        return styleGuidePanel;
    }

    private void addListeners() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ParallelPreferencePanel.this.doPropertyChange(propertyChangeEvent);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ParallelPreferencePanel.this.doPropertyChange(propertyChangeEvent);
                        }
                    });
                }
            }
        };
        this.fParallelSettings.addPropertyChangeListener(propertyChangeListener);
        ProfileManager.Provider.INSTANCE.getProfileManager().addPropertyChangeListener(propertyChangeListener);
    }

    private void doPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        block16: {
            try {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "DefaultProfileChanged": {
                        Profile profile = (Profile)propertyChangeEvent.getNewValue();
                        this.fProfileSelector.setSelectedProfile(profile.getName());
                        break;
                    }
                    case "DefaultProfile": {
                        break;
                    }
                    case "PreferredNumWorkers": {
                        this.fPreferredWorkerSizeTextField.setValue((Object)this.fParallelSettings.getPreferredNumWorkers());
                        break;
                    }
                    case "AutoCreate": {
                        this.fAutoOpenCheckBox.getCheckBox().setSelected(this.isAutoOpenParallelPool());
                        this.fIdleTimeOutTextField.setEnabled(this.isAutoShutdownParallelPool());
                        break;
                    }
                    case "IdleTimeout": {
                        this.updateIdleTimeoutComponent();
                        this.fAutoShutdownCheckBox.setSelected(this.isAutoShutdownParallelPool());
                        break;
                    }
                }
            }
            catch (SettingNotFoundException | SettingTypeException throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to update the preferences.", throwable);
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)("Unable to update the preferences. Caused by:" + throwable));
            }
        }
    }

    private boolean isAutoOpenParallelPool() throws SettingTypeException, SettingNotFoundException {
        return this.fParallelSettings.isAutoCreate();
    }

    private boolean isAutoShutdownParallelPool() throws SettingTypeException, SettingNotFoundException {
        int n = this.fParallelSettings.getIdleTimeout();
        return !Integer.valueOf(n).equals(Integer.MAX_VALUE);
    }

    private void updateIdleTimeoutComponent() throws SettingTypeException, SettingNotFoundException {
        int n = this.fParallelSettings.getIdleTimeout();
        if (!this.isAutoShutdownParallelPool()) {
            n = this.fParallelSettings.getFactoryIdleTimeout();
        }
        this.fIdleTimeOutTextField.setValue((Object)n);
        this.fIdleTimeOutTextField.setEnabled(this.isAutoShutdownParallelPool());
    }

    private void commitPrefs(boolean bl) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        if (bl) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            int n = this.fParallelSettings.getPreferredNumWorkers();
            String string = this.fParallelSettings.getDefaultProfile();
            int n2 = this.commitPreferredWorkersSize(n);
            this.fParallelSettings.setAutoCreate(this.fAutoOpenCheckBox.getCheckBox().isSelected());
            this.commitIdleTimeOut();
            ProfileManager profileManager = ProfileManager.Provider.INSTANCE.getProfileManager();
            boolean bl2 = false;
            if (profileManager.isInitialized()) {
                if (RestartPoolConfirmationDialog.isOkToChangeDefaultProfile(window, this.fSessionInfoProvider.getSessionInfo(), profileManager.getDefaultProfileName(), this.fProfileSelector.getSelectedProfile())) {
                    this.fParallelSettings.setDefaultProfile(this.fProfileSelector.getSelectedProfile());
                    bl2 = true;
                } else {
                    this.fProfileSelector.setSelectedProfile(string);
                    bl2 = false;
                }
            }
            SessionInfo sessionInfo = ClientSessionInfoProvider.getInstance().getSessionInfo();
            String string2 = this.fParallelSettings.getDefaultProfile();
            if (!bl2 && string.equals(string2) && RestartPoolConfirmationDialog.isOkToRestartDuePreferredNumWorkerChange(window, sessionInfo, n, n2)) {
                this.restartPoolOnPreferredNumWorkersChange();
            }
        } else {
            this.fProfileSelector.setSelectedProfile(this.fParallelSettings.getDefaultProfile());
            this.fPreferredWorkerSizeTextField.setValue((Object)this.fParallelSettings.getPreferredNumWorkers());
            this.fAutoOpenCheckBox.getCheckBox().setSelected(this.isAutoOpenParallelPool());
            this.fAutoShutdownCheckBox.setSelected(this.isAutoShutdownParallelPool());
            this.updateIdleTimeoutComponent();
        }
    }

    private void commitIdleTimeOut() throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        int n;
        if (this.fAutoShutdownCheckBox.isSelected()) {
            String string;
            try {
                this.fIdleTimeOutTextField.commitEdit();
            }
            catch (ParseException parseException) {
                PackageInfo.LOGGER.log(DistcompLevel.ONE, "ParallelPrefsIdleTimeout: The currently edited value was not committed", parseException);
            }
            switch (string = this.fIdleTimeOutTextField.getText()) {
                case "inf": {
                    n = Integer.MAX_VALUE;
                    break;
                }
                case "": {
                    n = this.fParallelSettings.getFactoryIdleTimeout();
                    break;
                }
                default: {
                    try {
                        n = Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = Integer.MAX_VALUE;
                    }
                    break;
                }
            }
        } else {
            n = Integer.MAX_VALUE;
        }
        if (n == this.fParallelSettings.getIdleTimeout()) {
            this.updateIdleTimeoutComponent();
            this.fAutoShutdownCheckBox.setSelected(this.isAutoShutdownParallelPool());
        } else {
            this.fParallelSettings.setIdleTimeout(n);
        }
    }

    private int commitPreferredWorkersSize(int n) throws SettingTypeException, SettingNotFoundException, SettingValidationException, SettingAccessException {
        int n2;
        String string;
        try {
            this.fPreferredWorkerSizeTextField.commitEdit();
        }
        catch (ParseException parseException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "ParallelPrefsPrefNumWorkers: The currently edited value was not committed", parseException);
        }
        switch (string = this.fPreferredWorkerSizeTextField.getText()) {
            case "": {
                n2 = n;
                break;
            }
            default: {
                try {
                    n2 = Integer.valueOf(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = Integer.MAX_VALUE;
                }
            }
        }
        if (n2 == n) {
            this.fPreferredWorkerSizeTextField.setValue((Object)n2);
        } else {
            this.fParallelSettings.setPreferredNumWorkers(n2);
        }
        return n2;
    }

    private void restartPoolOnPreferredNumWorkersChange() {
        new MatlabWorker<Object>(){

            public Object runOnMatlabThread() throws Exception {
                6.feval((String)ParallelPreferencePanel.RESTART_FUNCTION, (Object[])NO_INPUTS, (int)0, (boolean)true);
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        }.start();
    }

    private boolean validatePrefs() {
        return true;
    }

    public static MJPanel createPrefsPanel() {
        block3: {
            if (sParallelPreferencePanel == null) {
                try {
                    sParallelPreferencePanel = new ParallelPreferencePanel(ClientSessionInfoProvider.getInstance());
                }
                catch (SettingNotFoundException | SettingTypeException throwable) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "The Preference Panel has not been created.", throwable);
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)("The Preference Panel has not been created. Caused by" + throwable));
                }
            }
        }
        return sParallelPreferencePanel;
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        MJPanel mJPanel = ParallelPreferencePanel.createPrefsPanel();
        mJPanel.setPreferredSize(dimension);
        return mJPanel;
    }

    public static void commitPrefsChanges(boolean bl) throws SettingTypeException, SettingNotFoundException, SettingAccessException, SettingValidationException {
        assert (sParallelPreferencePanel != null) : "The Preference Panel has not been created.";
        sParallelPreferencePanel.commitPrefs(bl);
    }

    public static boolean validatePrefsPanel() {
        assert (sParallelPreferencePanel != null) : "The Preference Panel has not been created.";
        return sParallelPreferencePanel.validatePrefs();
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"distcomp", (String)"distcomp"), "parallel_preferences"};
    }

    private static class PreferredWorkerSizeIntStringFilter
    extends DocumentFilter {
        private PreferredWorkerSizeIntStringFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (PreferredWorkerSizeIntStringFilter.isDigit(string) && Integer.parseInt(string) == 0 && n == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else if (PreferredWorkerSizeIntStringFilter.isDigit(string) && (n == 0 || string2.isEmpty() || PreferredWorkerSizeIntStringFilter.isDigit(string2))) {
                filterBypass.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (PreferredWorkerSizeIntStringFilter.isDigit(string) && Integer.parseInt(string) == 0 && n == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else if (PreferredWorkerSizeIntStringFilter.isDigit(string) && (n == 0 || string2.isEmpty() || PreferredWorkerSizeIntStringFilter.isDigit(string2))) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private static boolean isDigit(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static class PreferredWorkerSizeFormatter
    extends JFormattedTextField.AbstractFormatter {
        private PreferredWorkerSizeIntStringFilter fPreferredWorkerIntStringFilter = new PreferredWorkerSizeIntStringFilter();

        private PreferredWorkerSizeFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            if ((string = string.trim()).isEmpty()) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null || object instanceof DefaultValue || object == ParallelPreferencePanel.EMPTY_VALUE) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(object);
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return this.fPreferredWorkerIntStringFilter;
        }
    }

    private static class IdleTimeOutIntStringFilter
    extends DocumentFilter {
        private IdleTimeOutIntStringFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (IdleTimeOutIntStringFilter.isDigit(string) && Integer.parseInt(string) == 0 && n == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else if (IdleTimeOutIntStringFilter.isDigit(string) && (n == 0 || string2.isEmpty() || IdleTimeOutIntStringFilter.isDigit(string2))) {
                filterBypass.insertString(n, string, attributeSet);
            } else if (ParallelPreferencePanel.INF.startsWith(string) && (n == 0 || string2.isEmpty())) {
                filterBypass.insertString(n, ParallelPreferencePanel.INF, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (IdleTimeOutIntStringFilter.isDigit(string) && Integer.parseInt(string) == 0 && n == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else if (IdleTimeOutIntStringFilter.isDigit(string) && (n == 0 || string2.isEmpty() || IdleTimeOutIntStringFilter.isDigit(string2))) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else if (ParallelPreferencePanel.INF.startsWith(string) && (n == 0 || string2.isEmpty())) {
                filterBypass.replace(n, n2, ParallelPreferencePanel.INF, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private static boolean isDigit(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static class IdleTimeOutFormatter
    extends JFormattedTextField.AbstractFormatter {
        private IdleTimeOutIntStringFilter fIdleTimeOutIntStringFilter = new IdleTimeOutIntStringFilter();

        private IdleTimeOutFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            if ((string = string.trim()).isEmpty()) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MAX_VALUE;
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null || object instanceof DefaultValue || object == ParallelPreferencePanel.EMPTY_VALUE) {
                return ParallelPreferencePanel.EMPTY_VALUE;
            }
            if (object.equals(Integer.MAX_VALUE)) {
                return ParallelPreferencePanel.INF;
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(object);
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return this.fIdleTimeOutIntStringFilter;
        }
    }
}

