/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.desk;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mde.cmdhist.CmdHistory;
import com.mathworks.mlservices.MLLicenseChecker;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileType;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileTypeFinder;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.toolbox.distcomp.ui.desk.JobMonitorDesktopClient;
import com.mathworks.util.Predicate;
import java.util.ResourceBundle;

public class RunBatchJobActionProvider
implements ActionProvider {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    private static final ActionDefinition RUN_AS_BATCH = new ActionDefinition("runAsBatchJob", CoreMenuSection.OPEN.getSection(), RESOURCE.getString("RunAsBatchJob.MenuItem.Label"));
    private static final String BATCH_UI_HELPER_FCN = "parallel.internal.ui.runAsBatchJob";
    private static boolean sHasDCTLicense = false;

    private static void initialize() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                sHasDCTLicense = MLLicenseChecker.hasLicense((String)"Distrib_Computing_Toolbox");
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return sHasDCTLicense && fileSystemEntry != null && !fileSystemEntry.isFolder() && MLFileUtils.isMatlabCodeFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.setActionPosition(actionRegistry.getAction(CoreActionID.RUN).getDefinition(), RUN_AS_BATCH);
        ActionConfiguration actionConfiguration = actionRegistry.defineAction(RUN_AS_BATCH);
        actionConfiguration.setEnabled((Predicate)new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                FileSystemEntry fileSystemEntry = (FileSystemEntry)actionInput.getSelection().get(0);
                return fileSystemEntry != null && !fileSystemEntry.isFolder() && MFileTypeFinder.findMFileType((FileSystemEntry)fileSystemEntry).equals((Object)MFileType.SCRIPT);
            }
        });
        actionConfiguration.setVisibleOnContextMenu((Predicate)new Predicate<ActionInput>(){

            public boolean accept(ActionInput actionInput) {
                FileSystemEntry fileSystemEntry = (FileSystemEntry)actionInput.getSelection().get(0);
                return fileSystemEntry != null && !fileSystemEntry.isFolder() && MFileTypeFinder.findMFileType((FileSystemEntry)fileSystemEntry).equals((Object)MFileType.SCRIPT) || MFileTypeFinder.findMFileType((FileSystemEntry)fileSystemEntry).equals((Object)MFileType.FUNCTION);
            }
        });
        actionConfiguration.setCode(SelectionMode.EXPLICIT_SINGLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileSystemEntry fileSystemEntry = (FileSystemEntry)actionInput.getSelection().get(0);
                RunBatchJobActionProvider.runAsBatchJobInMatlab(fileSystemEntry);
                return Status.COMPLETED;
            }
        });
    }

    private static void runAsBatchJobInMatlab(final FileSystemEntry fileSystemEntry) {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                assert (fileSystemEntry != null) : "The filesystementry should never be null.";
                return 5.feval((String)RunBatchJobActionProvider.BATCH_UI_HELPER_FCN, (Object[])new Object[]{fileSystemEntry.getName()}, (int)3);
            }

            public void runOnAWTEventDispatchThread(Object object) {
                String string = (String)((Object[])object)[0];
                String string2 = (String)((Object[])object)[1];
                CmdHistory.getInstance().add((Object)string2);
                JobMonitorDesktopClient.getInstance().updateJobMonitor(string);
            }

            protected void handleException(Exception exception, boolean bl) {
            }
        }.start();
    }

    static {
        RunBatchJobActionProvider.initialize();
    }
}

