/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.jidesoft.swing.JideSplitPane;
import com.mathworks.mlwidgets.prefs.ConfirmationDialogPrefsPanel;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import com.mathworks.toolbox.distcomp.ui.model.SessionInfoProvider;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.profile.ActionProvider;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileTablePanel;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileToolstripPanel;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileView;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import com.mathworks.toolbox.distcomp.ui.profile.model.ValidationManager;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.toolbox.distcomp.ui.widget.TablePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public final class ProfileManagerUI
extends MJFrame
implements PropertyChangeListener {
    private final ProfileManager fProfileManager;
    private final ValidationManager fValidationManager;
    private final SessionInfoProvider fClientSessionInfoProvider;
    private Selection<Profile> fNavigationPanelSelection;
    private AbstractStyleGuidePanel fNavigationPanel;
    private AbstractStyleGuidePanel fDocumentPanel;
    private AbstractStyleGuidePanel fProfileToolstripPanel;
    private Map<Profile, ProfileView> fProfileSimpleViewMap;
    private ProfileTablePanel fProfilesTablePanel;
    private ActionProvider fActionProvider;
    private JComponent fLoadingGlassPane;
    private static final int UI_HEIGHT = 500;
    private static final int UI_WIDTH = 800;
    private static final String PROFILE_UI_QE_NAME = "ProfileManager";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");
    private static final ResourceBundle sResDeskLocalized = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_desk_localized");
    private static final String PRODUCT_NAME = "Parallel Computing Toolbox";
    private static final String DELETE_ACTION_KEY = "delete";

    public ProfileManagerUI(ProfileManager profileManager, ValidationManager validationManager, SessionInfoProvider sessionInfoProvider) {
        this.fProfileManager = profileManager;
        this.fValidationManager = validationManager;
        this.fClientSessionInfoProvider = sessionInfoProvider;
        this.fProfileSimpleViewMap = new HashMap<Profile, ProfileView>();
        this.fNavigationPanelSelection = new Selection<Object>(null);
        if (!this.fProfileManager.getProfiles().isEmpty()) {
            this.fNavigationPanelSelection.setSelection(this.fProfileManager.getProfiles().get(0));
        }
        this.createProfilesTablePanel();
        this.createNavigationSection();
        this.createDocumentSection();
        this.createToolstripSection();
        this.createLoadingGlassPane();
        this.addListeners();
        JideSplitPane jideSplitPane = new JideSplitPane();
        jideSplitPane.addPane((Component)((Object)this.fNavigationPanel));
        jideSplitPane.addPane((Component)((Object)this.fDocumentPanel));
        jideSplitPane.setShowGripper(true);
        jideSplitPane.setProportionalLayout(true);
        jideSplitPane.setProportions(new double[]{0.25});
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel.addLine((JComponent)((Object)this.fProfileToolstripPanel));
        styleGuideEmptyPanel.addLine((JComponent)jideSplitPane, 8);
        this.setContentPane((Container)((Object)styleGuideEmptyPanel));
        this.setSize(800, 500);
        this.setTitle(sRes.getString("ProfileManager.Dialog.Title"));
        this.setName(PROFILE_UI_QE_NAME);
        if (!this.fProfileManager.isInitialized()) {
            final Component component = this.getGlassPane();
            this.setGlassPane(this.fLoadingGlassPane);
            this.fLoadingGlassPane.setVisible(true);
            this.fProfileManager.addPropertyChangeListener("Initialized", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ProfileManagerUI.this.setGlassPane(component);
                }
            });
        }
    }

    private void createDocumentSection() {
        this.fDocumentPanel = new StyleGuideEmptyPanel();
        if (this.fNavigationPanelSelection.getSelection() != null) {
            this.updateDocumentPanel(this.fNavigationPanelSelection.getSelection());
        }
    }

    private void updateDocumentPanel(Object object) {
        if (object != null) {
            Object object2;
            Profile profile = (Profile)object;
            if (!this.fProfileSimpleViewMap.containsKey(profile)) {
                object2 = new ProfileView(profile, this.fProfileManager, this.fValidationManager);
                this.fProfileManager.addPropertyChangeListener((PropertyChangeListener)object2);
                this.fProfileSimpleViewMap.put(profile, (ProfileView)object2);
            }
            object2 = (JComponent)((Object)this.fProfileSimpleViewMap.get(profile));
            this.fDocumentPanel.removeAll();
            this.fDocumentPanel.addLine((JComponent)object2, 8);
        } else {
            this.fDocumentPanel.removeAll();
        }
        this.fDocumentPanel.validate();
        this.fDocumentPanel.repaint();
    }

    public void editSelection() {
        Profile profile = this.fNavigationPanelSelection.getSelection();
        if (this.fProfileSimpleViewMap.containsKey(profile)) {
            ProfileView profileView = this.fProfileSimpleViewMap.get(profile);
            profileView.startEditing();
        }
    }

    private void cancelIfEditing() {
        Profile profile = this.fNavigationPanelSelection.getSelection();
        if (this.fProfileSimpleViewMap.containsKey(profile)) {
            ProfileView profileView = this.fProfileSimpleViewMap.get(profile);
            profileView.cancelEditing();
        }
    }

    private void cancelIfValidating() {
        this.fValidationManager.stopValidate();
    }

    private void createNavigationSection() {
        this.fNavigationPanel = new StyleGuideEmptyPanel();
        this.fNavigationPanel.addLine((JComponent)((Object)this.fProfilesTablePanel), 8);
    }

    private void createToolstripSection() {
        this.fProfileToolstripPanel = new ProfileToolstripPanel(this.fProfileManager, this.fActionProvider);
    }

    private void createProfilesTablePanel() {
        this.fProfilesTablePanel = new ProfileTablePanel(this.fProfileManager, this.fNavigationPanelSelection);
        this.fActionProvider = new ActionProvider(this);
        MJMenuItem mJMenuItem = new MJMenuItem((Action)this.fActionProvider.createSetDefaultProfile());
        mJMenuItem.setName("SetDefaultMenuItem");
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)this.fActionProvider.createValidate());
        mJMenuItem2.setName("ValidateMenuItem");
        MJMenuItem mJMenuItem3 = new MJMenuItem((Action)this.fActionProvider.createEdit());
        mJMenuItem3.setName("EditMenuItem");
        MJMenuItem mJMenuItem4 = new MJMenuItem((Action)this.fActionProvider.getDuplicateAction());
        mJMenuItem4.setName("DuplicateMenuItem");
        MJAbstractAction mJAbstractAction = this.fActionProvider.getDeleteAction();
        MJMenuItem mJMenuItem5 = new MJMenuItem((Action)mJAbstractAction);
        mJMenuItem5.setName("DeleteMenuItem");
        MJMenuItem mJMenuItem6 = new MJMenuItem((Action)this.fActionProvider.createRename());
        mJMenuItem6.setName("RenameMenuItem");
        MJMenuItem mJMenuItem7 = new MJMenuItem((Action)this.fActionProvider.createExportAction((Component)((Object)this)));
        mJMenuItem7.setName("ExportMenuItem");
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        mJPopupMenu.add((JMenuItem)mJMenuItem2);
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((JMenuItem)mJMenuItem3);
        mJPopupMenu.add((JMenuItem)mJMenuItem4);
        mJPopupMenu.add((JMenuItem)mJMenuItem5);
        mJPopupMenu.add((JMenuItem)mJMenuItem6);
        mJPopupMenu.add((JMenuItem)mJMenuItem7);
        this.fProfilesTablePanel.setContextMenu((JPopupMenu)mJPopupMenu);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.fProfilesTablePanel.getTable().getInputMap().put(keyStroke, DELETE_ACTION_KEY);
        this.fProfilesTablePanel.getTable().getActionMap().put(DELETE_ACTION_KEY, (Action)mJAbstractAction);
    }

    private void addListeners() {
        this.fProfileManager.addPropertyChangeListener(this);
        this.fNavigationPanelSelection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                final Profile profile = selectionEvent.getNewSelection();
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProfileManagerUI.this.updateDocumentPanel(profile);
                    }
                });
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                ProfileManagerUI.this.cancelIfEditing();
                ProfileManagerUI.this.cancelIfValidating();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("Initialized")) {
            this.fNavigationPanelSelection.setSelection(this.fProfileManager.getProfiles().get(0));
        } else if (propertyChangeEvent.getPropertyName().equals("ProfileAdded")) {
            this.cancelIfEditing();
            this.fNavigationPanelSelection.setSelection((Profile)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("ProfileRemoved")) {
            if (this.fProfileSimpleViewMap.containsKey(propertyChangeEvent.getNewValue())) {
                JComponent jComponent = (JComponent)((Object)this.fProfileSimpleViewMap.remove(propertyChangeEvent.getNewValue()));
                this.fProfileManager.removePropertyChangeListener((PropertyChangeListener)((Object)jComponent));
                ((Destroyable)((Object)jComponent)).destroy();
                this.fNavigationPanelSelection.setSelection((Profile)this.fProfilesTablePanel.getTableSelection());
            } else {
                this.cancelIfEditing();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("ErrorOccurred")) {
            String string = (String)propertyChangeEvent.getNewValue();
            this.showErrorDialog(string);
        }
    }

    private void showErrorDialog(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MJOptionPane mJOptionPane = new MJOptionPane(string, 0, -1){

                    public int getMaxCharactersPerLineCount() {
                        return 100;
                    }
                };
                mJOptionPane.setName("ErrorPane");
                JDialog jDialog = mJOptionPane.createDialog((Component)((Object)ProfileManagerUI.this), sRes.getString("ProfileManager.ErrorDialog.Title"));
                jDialog.setVisible(true);
                jDialog.dispose();
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    private void createLoadingGlassPane() {
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel(){

            @Override
            protected int getTopInset() {
                return 5;
            }
        };
        styleGuidePanel.setOpaque(false);
        JLabel jLabel = new JLabel(sRes.getString("ProfileManager.LoadingProfile"), ParallelIcon.BUSY.getIcon(), 10);
        styleGuidePanel.addLine(jLabel);
        styleGuidePanel.setBorder(BorderFactory.createEtchedBorder());
        this.fLoadingGlassPane = new JPanel();
        this.fLoadingGlassPane.setOpaque(false);
        this.fLoadingGlassPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.fLoadingGlassPane.add((Component)((Object)styleGuidePanel), gridBagConstraints);
        this.fLoadingGlassPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
    }

    public ProfileManager getProfileManager() {
        return this.fProfileManager;
    }

    public ValidationManager getValidationManager() {
        return this.fValidationManager;
    }

    public SessionInfoProvider getSessionInfoProvider() {
        return this.fClientSessionInfoProvider;
    }

    public Selection<Profile> getNavigationPanelSelection() {
        return this.fNavigationPanelSelection;
    }

    public TablePanel getProfilesTablePanel() {
        return this.fProfilesTablePanel;
    }

    public static ConfirmationDialogPrefsPanel.DialogItem[] getDialogItems() {
        return new ConfirmationDialogPrefsPanel.DialogItem[]{new ConfirmationDialogPrefsPanel.DialogItem(sResDeskLocalized.getString("preference.confirmDialog.MDCSRequired"), "PCT_MDCSRequired", PRODUCT_NAME, true), new ConfirmationDialogPrefsPanel.DialogItem(sResDeskLocalized.getString("preference.confirmDialog.deleteProfile"), "PCT_DeleteProfile", PRODUCT_NAME, true)};
    }
}

