/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile.model;

import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.services.settings.SettingNotFoundException;
import com.mathworks.services.settings.SettingPath;
import com.mathworks.toolbox.distcomp.ui.PackageInfo;
import com.mathworks.toolbox.distcomp.ui.model.PropertyChangeSupportAdaptor;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileNamesProvider;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;

public class SettingsProfileNamesProvider
extends PropertyChangeSupportAdaptor
implements ProfileNamesProvider {
    private static final SettingPath PARALLEL_PROFILES = new SettingPath(new String[]{"parallel", "profiles"});

    public SettingsProfileNamesProvider() {
        try {
            PARALLEL_PROFILES.addListener((SettingListener)new SettingAdapter(){

                public void settingAdded(SettingChangeEvent settingChangeEvent) {
                    if (settingChangeEvent.getParent().equals((Object)PARALLEL_PROFILES)) {
                        SettingsProfileNamesProvider.this.firePropertyChange("ProfileNameAdded", null, settingChangeEvent.getChildName());
                    }
                }

                public void settingRemoved(SettingChangeEvent settingChangeEvent) {
                    SettingsProfileNamesProvider.this.firePropertyChange("ProfileNameRemoved", null, settingChangeEvent.getChildName());
                }
            });
        }
        catch (SettingNotFoundException settingNotFoundException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to add listener to the profiles settings node.", settingNotFoundException);
        }
    }

    @Override
    public String[] getProfileNames() {
        String[] stringArray;
        try {
            stringArray = PARALLEL_PROFILES.getChildNames();
        }
        catch (SettingNotFoundException settingNotFoundException) {
            return null;
        }
        return stringArray;
    }
}

