/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.remote;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerOrLocalShellSender;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.EmptyCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.UsernamePasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.remote.AbstractCredentialUI;
import com.mathworks.toolbox.distcomp.ui.remote.EmptyCredentialUI;
import com.mathworks.toolbox.distcomp.ui.remote.IdentityFileCredentialUI;
import com.mathworks.toolbox.distcomp.ui.remote.PasswordCredentialUI;
import com.mathworks.toolbox.distcomp.ui.remote.PeerSCCredentialUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;

public class ParameterPanel
extends StyleGuidePanel {
    public static final String PARAMETERMAP_CHANGED_PROPERTY = "ParameterMapChanged";
    private ParameterSet fParameterSet;
    private JComboBox fCredentialParameterCombobox;
    private AbstractStyleGuidePanel fCredentialUIContainer;
    private AbstractCredentialUI fCredentialUI;
    private static final CredentialParameter SC_CREDENTIAL = PeerOrLocalShellSender.PEER_OR_LOCAL_PARAMETER_SET.getCredentialParameter();
    private static final CredentialDescription SC_CREDENTIAL_DESCRIPTION = PeerOrLocalShellSender.PEER_OR_LOCAL_PARAMETER_SET.hasCredentialParameter() ? PeerOrLocalShellSender.PEER_OR_LOCAL_PARAMETER_SET.getCredentialParameter().getDefaultCredentialDescription() : null;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");
    private static final ResourceBundle sResNoTranslation = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui_notranslation");
    static final Map<CredentialParameter, String> sMapCredentialParameterToDisplayText;
    static final Map<CredentialDescription, Class<? extends AbstractCredentialUI>> sMapCredentialDescriptionToUI;

    public ParameterPanel(ParameterSet parameterSet) {
        this.fParameterSet = parameterSet;
        MJLabel mJLabel = new MJLabel(sRes.getString("remote.communicationpanel.protocol.label"));
        this.createCredentialParameterCombobox();
        this.createCredentiallDescriptionUISection();
        this.addLine(new JComponent[][]{{mJLabel, this.fCredentialParameterCombobox}});
        this.addLine((JComponent)((Object)this.fCredentialUIContainer));
        this.addLine((JComponent)((Object)new StyleGuideEmptyPanel()), 8);
        this.setName("ParameterPanel");
        this.fCredentialParameterCombobox.setName("ParameterPanel.CredentialParameterCombobox");
    }

    private void createCredentiallDescriptionUISection() {
        this.fCredentialUIContainer = new StyleGuideEmptyPanel();
        this.fCredentialUI = (AbstractCredentialUI)((Object)this.fCredentialParameterCombobox.getSelectedItem());
        this.fCredentialUIContainer.addLine((JComponent)((Object)this.fCredentialUI), 8);
    }

    private void createCredentialParameterCombobox() {
        this.fCredentialParameterCombobox = new MJComboBox();
        this.addCredentiaUIToCombobox();
        this.fCredentialParameterCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParameterPanel.this.updateCredentialDescriptionUISection();
                ParameterPanel.this.firePropertyChange(ParameterPanel.PARAMETERMAP_CHANGED_PROPERTY, null, ParameterPanel.this.getParameterMap());
            }
        });
        this.fCredentialParameterCombobox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = ((AbstractCredentialUI)((Object)object)).getLabel().isEmpty() ? sMapCredentialParameterToDisplayText.get(ParameterPanel.this.fParameterSet.getCredentialParameter()) : sMapCredentialParameterToDisplayText.get(ParameterPanel.this.fParameterSet.getCredentialParameter()) + " - " + ((AbstractCredentialUI)((Object)object)).getLabel();
                jLabel.setText(string);
                return jLabel;
            }
        });
    }

    private void updateCredentialDescriptionUISection() {
        AbstractCredentialUI abstractCredentialUI = (AbstractCredentialUI)((Object)this.fCredentialParameterCombobox.getSelectedItem());
        this.fCredentialUIContainer.removeAll();
        this.fCredentialUI = abstractCredentialUI;
        this.fCredentialUIContainer.addLine((JComponent)((Object)this.fCredentialUI), 8);
        this.fCredentialUIContainer.revalidate();
        this.fCredentialUIContainer.repaint();
    }

    public ParameterMap getParameterMap() {
        ParameterMap parameterMap = new ParameterMap();
        if (this.fParameterSet.hasCredentialParameter()) {
            Credential credential = this.fCredentialUI.getCredential();
            parameterMap.put(this.fParameterSet.getCredentialParameter(), credential);
        }
        return parameterMap;
    }

    public void setParameterSet(ParameterSet parameterSet) {
        this.fParameterSet = parameterSet;
        this.updateCredentialParameterComobox();
        this.updateCredentialDescriptionUISection();
    }

    private void updateCredentialParameterComobox() {
        ActionListener[] actionListenerArray = this.removeAllItemsFromCombobox();
        this.addCredentiaUIToCombobox();
        for (ActionListener actionListener : actionListenerArray) {
            this.fCredentialParameterCombobox.addActionListener(actionListener);
        }
    }

    private void addCredentiaUIToCombobox() {
        if (this.fParameterSet.hasCredentialParameter()) {
            for (CredentialDescription credentialDescription : this.fParameterSet.getCredentialParameter().getPossibleCredentialDescriptions()) {
                AbstractCredentialUI abstractCredentialUI;
                block12: {
                    abstractCredentialUI = null;
                    try {
                        abstractCredentialUI = sMapCredentialDescriptionToUI.get(credentialDescription).newInstance();
                        abstractCredentialUI.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                if (propertyChangeEvent.getPropertyName().equals(AbstractCredentialUI.CREDENTIAL_CHANGED_PROPERTY)) {
                                    ParameterPanel.this.firePropertyChange(ParameterPanel.PARAMETERMAP_CHANGED_PROPERTY, null, ParameterPanel.this.getParameterMap());
                                }
                            }
                        });
                    }
                    catch (InstantiationException instantiationException) {
                        assert (false) : "Unable to instantiate the UI for " + credentialDescription.getClass();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if ($assertionsDisabled) break block12;
                        throw new AssertionError((Object)("Unable to access the UI for " + credentialDescription.getClass()));
                    }
                }
                this.fCredentialParameterCombobox.addItem(abstractCredentialUI);
            }
        } else {
            try {
                this.fCredentialParameterCombobox.addItem(sMapCredentialDescriptionToUI.get(SC_CREDENTIAL_DESCRIPTION).newInstance());
            }
            catch (InstantiationException instantiationException) {
                assert (false) : "Unable to instantiate the UI ";
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false) : "Unable to instantiate the UI ";
            }
        }
    }

    private ActionListener[] removeAllItemsFromCombobox() {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.fCredentialParameterCombobox.getActionListeners()) {
            this.fCredentialParameterCombobox.removeActionListener(actionListener);
        }
        for (int i = 0; i < this.fCredentialParameterCombobox.getItemCount(); ++i) {
            AbstractCredentialUI abstractCredentialUI = (AbstractCredentialUI)((Object)this.fCredentialParameterCombobox.getItemAt(i));
            for (PropertyChangeListener propertyChangeListener : abstractCredentialUI.getPropertyChangeListeners()) {
                abstractCredentialUI.removePropertyChangeListener(propertyChangeListener);
            }
        }
        this.fCredentialParameterCombobox.removeAllItems();
        return actionListenerArray;
    }

    public static ParameterMap showDialog(String string, ParameterSet parameterSet) {
        assert (SwingUtilities.isEventDispatchThread()) : "Need to call showDialog on an event dispatch thread.";
        ParameterPanel parameterPanel = new ParameterPanel(parameterSet);
        MJOptionPane mJOptionPane = new MJOptionPane((Object)parameterPanel, -1, 2, null, null, null);
        final JDialog jDialog = mJOptionPane.createDialog(string);
        jDialog.setName("ParameterPanel.Dialog");
        parameterPanel.addPropertyChangeListener(PARAMETERMAP_CHANGED_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jDialog.pack();
            }
        });
        jDialog.pack();
        jDialog.setVisible(true);
        Object object = mJOptionPane.getValue();
        ParameterMap parameterMap = null;
        if ((Integer)object == 0) {
            parameterMap = parameterPanel.getParameterMap();
        }
        return parameterMap;
    }

    static {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        hashMap.put(SC_CREDENTIAL, sResNoTranslation.getString("remote.credentialparameter.sc"));
        hashMap.put(SshParameter.SSH_CREDENTIAL, sResNoTranslation.getString("remote.credentialparameter.ssh"));
        sMapCredentialParameterToDisplayText = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        hashMap.put(PasswordCredentialDescription.INSTANCE, PasswordCredentialUI.class);
        hashMap.put(UsernamePasswordCredentialDescription.INSTANCE, PasswordCredentialUI.class);
        hashMap.put(IdentityFileCredentialDescription.INSTANCE, IdentityFileCredentialUI.class);
        hashMap.put(EmptyCredentialDescription.INSTANCE, EmptyCredentialUI.class);
        hashMap.put(SC_CREDENTIAL_DESCRIPTION, PeerSCCredentialUI.class);
        sMapCredentialDescriptionToUI = Collections.unmodifiableMap(hashMap);
    }
}

