/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJComboBox;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;

public final class BooleanView
extends ConfigurablePropertyView {
    private static final String USE_DEFAULT = sRes.getString("ConfigurableView.Common.UseDefaultLabel");
    private static final String TRUE = sRes.getString("BooleanView.Combobox.TrueLabel");
    private static final String FALSE = sRes.getString("BooleanView.Combobox.FalseLabel");
    private final JComboBox fBooleanCombobox;

    public BooleanView(Property property, String string) {
        super(property);
        this.fBooleanCombobox = this.createComboBox(string);
        this.updateUI(this.getProperty().getValue());
        this.addLine(this.fBooleanCombobox, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    private JComboBox createComboBox(String string) {
        MJComboBox mJComboBox = new MJComboBox((Object[])new String[]{USE_DEFAULT, TRUE, FALSE});
        int n = (int)mJComboBox.getPreferredSize().getHeight();
        mJComboBox.setMinimumSize(new Dimension(250, n));
        mJComboBox.setMaximumSize(new Dimension(250, n));
        mJComboBox.setSize(new Dimension(250, n));
        mJComboBox.setPreferredSize(new Dimension(250, n));
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BooleanView.this.commitEdit();
            }
        });
        mJComboBox.setName(string);
        return mJComboBox;
    }

    @Override
    public void commitEdit() {
        Property property = this.getProperty();
        if (this.fBooleanCombobox.getSelectedItem().equals(TRUE)) {
            property.setValue(true);
        } else if (this.fBooleanCombobox.getSelectedItem().equals(FALSE)) {
            property.setValue(false);
        } else if (this.fBooleanCombobox.getSelectedItem().equals(USE_DEFAULT)) {
            property.unsetValue();
        } else assert (false) : "Unknown selection " + this.fBooleanCombobox.getSelectedItem();
    }

    @Override
    public void updateUI(Object object) {
        ActionListener[] actionListenerArray;
        for (ActionListener actionListener : actionListenerArray = this.fBooleanCombobox.getActionListeners()) {
            this.fBooleanCombobox.removeActionListener(actionListener);
        }
        if (object instanceof DefaultValue) {
            this.fBooleanCombobox.setSelectedItem(USE_DEFAULT);
        } else {
            assert (object instanceof Boolean) : "BooleanValue can only handle Booleans.";
            this.fBooleanCombobox.setSelectedItem((Boolean)object != false ? TRUE : FALSE);
        }
        for (ActionListener actionListener : actionListenerArray) {
            this.fBooleanCombobox.addActionListener(actionListener);
        }
    }
}

