/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.DefaultOverlayable;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.distcomp.ui.model.Destroyable;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideRelatedPanel;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;

public abstract class ConfigurablePropertyView
extends StyleGuideRelatedPanel
implements PropertyChangeListener,
Destroyable {
    private Property fProperty;
    private static final Insets OVERLAY_INSETS = new Insets(0, -5, 0, 0);
    static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_ui");

    ConfigurablePropertyView(Property property) {
        assert (property.getPropertyInfo().isConfigurable()) : "The property is not configurable.";
        this.fProperty = property;
        this.fProperty.addPropertyChangeListener(this);
    }

    abstract void updateUI(Object var1);

    abstract void commitEdit();

    final Property getProperty() {
        return this.fProperty;
    }

    final JComponent createDefaultValueDecorator() {
        assert (this.fProperty.getPropertyInfo().hasDefaultString()) : "The property does not have a default string";
        return new MJLabel(MessageFormat.format(sRes.getString("ConfigurableView.Decorator.DefaultLabel"), this.getProperty().getPropertyInfo().getDefaultString()));
    }

    final JComponent addUseDefaultOverlayDecorator(final JComponent jComponent, String string) {
        if (!this.fProperty.getPropertyInfo().hasDefaultString()) {
            return jComponent;
        }
        MJLabel mJLabel = new MJLabel(sRes.getString("ConfigurableView.Common.UseDefaultLabel"));
        Color color = UIDefaultsLookup.getColor((Object)"Label.disabledForeground");
        if (color == null) {
            color = Color.GRAY;
        }
        mJLabel.setForeground(color);
        mJLabel.setName(string + ".OverlayableLabel");
        final DefaultOverlayable defaultOverlayable = new DefaultOverlayable(jComponent, (JComponent)mJLabel, 7);
        defaultOverlayable.setOpaque(false);
        defaultOverlayable.setOverlayLocationInsets(OVERLAY_INSETS);
        jComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ConfigurablePropertyView.this.updateOverlayVisibility(jComponent, defaultOverlayable);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ConfigurablePropertyView.this.updateOverlayVisibility(jComponent, defaultOverlayable);
            }
        });
        mJLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ConfigurablePropertyView.redispatchMouseEvent(jComponent, mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ConfigurablePropertyView.redispatchMouseEvent(jComponent, mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ConfigurablePropertyView.redispatchMouseEvent(jComponent, mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ConfigurablePropertyView.redispatchMouseEvent(jComponent, mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ConfigurablePropertyView.redispatchMouseEvent(jComponent, mouseEvent);
            }
        });
        this.fProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ConfigurablePropertyView.this.updateOverlayVisibility(jComponent, defaultOverlayable);
                    }
                });
            }
        });
        this.updateOverlayVisibility(jComponent, defaultOverlayable);
        return defaultOverlayable;
    }

    static void redispatchMouseEvent(JComponent jComponent, MouseEvent mouseEvent) {
        jComponent.dispatchEvent(new MouseEvent(jComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
    }

    private void updateOverlayVisibility(JComponent jComponent, DefaultOverlayable defaultOverlayable) {
        if (jComponent.hasFocus()) {
            defaultOverlayable.setOverlayVisible(false);
        } else {
            defaultOverlayable.setOverlayVisible(this.fProperty.isDefaultValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        final Object object = propertyChangeEvent.getNewValue();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurablePropertyView.this.updateUI(object);
            }
        });
    }

    @Override
    public void destroy() {
        this.fProperty.removePropertyChangeListener(this);
    }
}

