/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJFormattedTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public final class IntegerView
extends ConfigurablePropertyView {
    private final MJFormattedTextField fIntegerTextField;
    private static final String INF = "inf";
    private static final String EMPTY_VALUE = "";

    public IntegerView(Property property, String string) {
        super(property);
        this.fIntegerTextField = this.createIntegerTextField(string);
        this.updateUI(this.getProperty().getValue());
        JComponent jComponent = this.addUseDefaultOverlayDecorator((JComponent)this.fIntegerTextField, string);
        this.addLine(jComponent, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    private MJFormattedTextField createIntegerTextField(String string) {
        IntegerStringFormatter integerStringFormatter = new IntegerStringFormatter();
        final MJFormattedTextField mJFormattedTextField = new MJFormattedTextField((JFormattedTextField.AbstractFormatter)integerStringFormatter);
        int n = (int)mJFormattedTextField.getPreferredSize().getHeight();
        mJFormattedTextField.setMinimumSize(new Dimension(250, n));
        mJFormattedTextField.setMaximumSize(new Dimension(250, n));
        mJFormattedTextField.setSize(new Dimension(250, n));
        mJFormattedTextField.setPreferredSize(new Dimension(250, n));
        mJFormattedTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IntegerView.this.commitEdit();
                mJFormattedTextField.getParent().requestFocus();
            }
        });
        mJFormattedTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJFormattedTextField, new Runnable(){

            @Override
            public void run() {
                IntegerView.this.commitEdit();
            }
        }));
        mJFormattedTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        mJFormattedTextField.setName(string);
        return mJFormattedTextField;
    }

    @Override
    public void updateUI(Object object) {
        this.fIntegerTextField.setValue(object);
    }

    @Override
    public void commitEdit() {
        block4: {
            try {
                this.fIntegerTextField.commitEdit();
                Object object = this.fIntegerTextField.getValue();
                Property property = this.getProperty();
                if (EMPTY_VALUE.equals(object)) {
                    property.unsetValue();
                } else {
                    property.setValue(object);
                }
            }
            catch (ParseException parseException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)parseException);
            }
        }
    }

    private static class IntStringFilter
    extends DocumentFilter {
        private IntStringFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (IntStringFilter.isDigit(string) && (n == 0 || string2.length() == 0 || IntStringFilter.isDigit(string2))) {
                filterBypass.insertString(n, string, attributeSet);
            } else if (IntegerView.INF.startsWith(string) && (n == 0 || string2.length() == 0)) {
                filterBypass.insertString(n, IntegerView.INF, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = filterBypass.getDocument().getText(0, filterBypass.getDocument().getLength());
            if (IntStringFilter.isDigit(string) && (n == 0 || string2.length() == 0 || IntStringFilter.isDigit(string2))) {
                filterBypass.replace(n, n2, string, attributeSet);
            } else if (IntegerView.INF.startsWith(string) && (n == 0 || string2.length() == 0)) {
                filterBypass.replace(n, n2, IntegerView.INF, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private static boolean isDigit(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private static class IntegerStringFormatter
    extends JFormattedTextField.AbstractFormatter {
        private IntStringFilter fIntStringFilter = new IntStringFilter();

        private IntegerStringFormatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return IntegerView.EMPTY_VALUE;
            }
            if ((string = string.trim()).length() == 0) {
                return IntegerView.EMPTY_VALUE;
            }
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Double.POSITIVE_INFINITY;
            }
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null || object instanceof DefaultValue || object == IntegerView.EMPTY_VALUE) {
                return IntegerView.EMPTY_VALUE;
            }
            if (object.equals(Double.POSITIVE_INFINITY)) {
                return IntegerView.INF;
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            return numberFormat.format(object);
        }

        @Override
        protected DocumentFilter getDocumentFilter() {
            return this.fIntStringFilter;
        }
    }
}

