/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.panel.AbstractStyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuideEmptyPanel;
import com.mathworks.toolbox.distcomp.ui.panel.StyleGuidePanel;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class PropertiesPanel {
    private AbstractStyleGuidePanel fPanel;
    private final Map<Property, JComponent> fPropertyViewMap;
    private static final Font PROPERTY_FONT = new Font("Monospaced", 0, 12);

    public PropertiesPanel(Map<Property, JComponent> map) {
        this.fPropertyViewMap = new LinkedHashMap<Property, JComponent>(map);
        StyleGuidePanel styleGuidePanel = new StyleGuidePanel(){

            @Override
            protected int getVerticalComponentSpacing() {
                return 15;
            }
        };
        JComponent[][] jComponentArray = new JComponent[this.fPropertyViewMap.size()][2];
        int n = 0;
        for (Property property : this.fPropertyViewMap.keySet()) {
            jComponentArray[n][0] = PropertiesPanel.createPropertyLabel(property);
            JComponent jComponent = map.get(property);
            jComponentArray[n][1] = PropertiesPanel.decorateComponent(property, jComponent);
            ++n;
        }
        styleGuidePanel.addLine(jComponentArray, 8, 1);
        this.fPanel = new StyleGuideEmptyPanel();
        this.fPanel.addLine((JComponent)((Object)styleGuidePanel));
        this.fPanel.addLine(new JPanel(), 8);
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    public void commitEdit() {
        for (JComponent jComponent : this.fPropertyViewMap.values()) {
            if (!(jComponent instanceof ConfigurablePropertyView)) continue;
            ((ConfigurablePropertyView)((Object)jComponent)).commitEdit();
        }
    }

    private static JComponent createPropertyLabel(Property property) {
        MJLabel mJLabel = new MJLabel(property.getPropertyInfo().getName());
        mJLabel.setFont(PROPERTY_FONT);
        String string = property.getPropertyInfo().getDescription();
        if (string == null || string.isEmpty()) {
            return mJLabel;
        }
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
        mJMultilineLabel.setBackground(styleGuideEmptyPanel.getBackground());
        mJMultilineLabel.setMaxWidth(100);
        mJMultilineLabel.setSize(mJMultilineLabel.getPreferredSize());
        mJMultilineLabel.setMinimumSize(mJMultilineLabel.getPreferredSize());
        mJMultilineLabel.setMaximumSize(mJMultilineLabel.getPreferredSize());
        styleGuideEmptyPanel.addLine((JComponent)mJMultilineLabel);
        styleGuideEmptyPanel.addLine((JComponent)mJLabel);
        styleGuideEmptyPanel.addLine(new JPanel(), 8);
        return styleGuideEmptyPanel;
    }

    private static JComponent decorateComponent(Property property, JComponent jComponent) {
        String string = property.getPropertyInfo().getDescription();
        StyleGuideEmptyPanel styleGuideEmptyPanel = new StyleGuideEmptyPanel();
        JPanel jPanel = new JPanel();
        jPanel.setMaximumSize(new Dimension(100, 1));
        jPanel.setMinimumSize(new Dimension(100, 1));
        jPanel.setPreferredSize(new Dimension(100, 1));
        jPanel.setSize(100, 1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setMaximumSize(new Dimension(10, 1));
        jPanel2.setMinimumSize(new Dimension(10, 1));
        jPanel2.setPreferredSize(new Dimension(10, 1));
        jPanel2.setSize(10, 1);
        styleGuideEmptyPanel.addLine((JComponent[][])new JComponent[][]{{jPanel, jComponent, jPanel2}}, 0, 1);
        if (string == null || string.isEmpty()) {
            return styleGuideEmptyPanel;
        }
        StyleGuideEmptyPanel styleGuideEmptyPanel2 = new StyleGuideEmptyPanel();
        styleGuideEmptyPanel2.addLine((JComponent)((Object)styleGuideEmptyPanel));
        styleGuideEmptyPanel2.addLine(new JPanel(), 8);
        return styleGuideEmptyPanel2;
    }
}

