/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class StringView
extends ConfigurablePropertyView {
    private boolean fTrimWhiteSpaces;
    private final MJTextField fStringTextField;

    public StringView(Property property, String string) {
        this(property, false, string);
    }

    public StringView(Property property, boolean bl, String string) {
        super(property);
        this.fTrimWhiteSpaces = bl;
        this.fStringTextField = this.createStringTextField(string);
        this.updateUI(this.getProperty().getValue());
        JComponent jComponent = this.addUseDefaultOverlayDecorator((JComponent)this.fStringTextField, string);
        this.addLine(jComponent, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    private MJTextField createStringTextField(String string) {
        final MJTextField mJTextField = new MJTextField();
        int n = (int)mJTextField.getPreferredSize().getHeight();
        mJTextField.setMinimumSize(new Dimension(250, n));
        mJTextField.setMaximumSize(new Dimension(250, n));
        mJTextField.setSize(new Dimension(250, n));
        mJTextField.setPreferredSize(new Dimension(250, n));
        mJTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringView.this.commitEdit();
                mJTextField.getParent().requestFocus();
            }
        });
        mJTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJTextField, new Runnable(){

            @Override
            public void run() {
                StringView.this.commitEdit();
            }
        }));
        mJTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        mJTextField.setName(string);
        return mJTextField;
    }

    @Override
    public void commitEdit() {
        Property property = this.getProperty();
        String string = this.fStringTextField.getText();
        if (this.fTrimWhiteSpaces) {
            string = string.trim();
        }
        if (string.isEmpty()) {
            property.unsetValue();
        } else if (string.equals("''")) {
            property.setValue("");
        } else {
            Object object = property.getValue();
            property.setValue(string);
            if (object.equals(string)) {
                this.updateUI(string);
            }
        }
    }

    @Override
    public void updateUI(Object object) {
        String string;
        if (object instanceof DefaultValue) {
            string = "";
        } else if (object.equals("")) {
            string = "''";
        } else {
            string = (String)object;
            if (this.fTrimWhiteSpaces) {
                string = string.trim();
            }
        }
        this.fStringTextField.setText(string);
    }
}

