/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.toolbox.distcomp.util.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ProcessorUtil {
    private static final int DEFAULT_PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    private static Integer sProcessorCount;
    private static final String JRE_CMD;
    private static final String TOOLBOX_ROOT_SYS_PROP = "com.mathworks.toolbox.distcomp.toolboxroot";
    private static final String MDCE_BASE;
    private static final String JAR_REL;
    private static final String DISTCOMP_JAR;
    private static final String SERVICES_JAR = "services.jar";
    private static final String MVM_JAR = "mvm.jar";
    private static final String NATIVE_PROCESSOR_UTIL_CLASS = "com.mathworks.toolbox.distcomp.util.NativeProcessorUtil";
    private static final long TIMEOUT_MSEC = 10000L;
    private static final Level ERROR_LEVEL;
    private static final Level INFO_LEVEL;
    private static final String FAIL_MSG_PREFIX = "ProcessorUtil.getNumberOfProcessors() failed: ";
    private static final int NUM_TRIES_ALLOWED = 2;
    private static final int WAIT_BETWEEN_TRIES_MSEC = 1000;

    public static synchronized int getNumberOfProcessors() {
        if (sProcessorCount == null) {
            sProcessorCount = ProcessorUtil.callProcessorUtilMain();
        }
        return sProcessorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int callProcessorUtilMain() {
        ProcessorUtil.log(INFO_LEVEL, "Initial calling ProcessorUtil.getNumberOfProcessors()...");
        if (MDCE_BASE == null) {
            return ProcessorUtil.logFailureAndGetDefaultValue("System property \"com.mathworks.toolbox.distcomp.toolboxroot\" not set");
        }
        String string = MDCE_BASE + JAR_REL;
        String string2 = string + DISTCOMP_JAR;
        if (!new File(string2).exists()) {
            return ProcessorUtil.logFailureAndGetDefaultValue("The jar \"" + string2 + "\" does not exist.");
        }
        String string3 = string + SERVICES_JAR;
        if (!new File(string3).exists()) {
            return ProcessorUtil.logFailureAndGetDefaultValue("The jar \"" + string3 + "\" does not exist.");
        }
        String string4 = string + MVM_JAR;
        if (!new File(string3).exists()) {
            return ProcessorUtil.logFailureAndGetDefaultValue("The jar \"" + string4 + "\" does not exist.");
        }
        String string5 = string2 + File.pathSeparator + string3 + File.pathSeparator + string4;
        String[] stringArray = new String[]{JRE_CMD, "-cp", string5, NATIVE_PROCESSOR_UTIL_CLASS};
        Exception exception = null;
        boolean bl = false;
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(ProcessorUtil.class.getSimpleName() + " processExecutor-"), (Logger)ProcessorUtil.getLogger()));
        for (int i = 0; i < 2; ++i) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(stringArray);
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(process.getInputStream()));
                final Process process2 = process;
                Callable<Integer> callable = new Callable<Integer>(){

                    @Override
                    public Integer call() throws InterruptedException {
                        process2.waitFor();
                        return process2.exitValue();
                    }
                };
                Future<Integer> future = executorService.submit(callable);
                int n = future.get(10000L, TimeUnit.MILLISECONDS);
                if (n <= 0) {
                    int n2 = dataInputStream.readInt();
                    ProcessorUtil.log(INFO_LEVEL, "ProcessorUtil successful, returning " + n2);
                    int n3 = n2;
                    return n3;
                }
                bl = true;
                ProcessorUtil.waitBetweenTries();
                continue;
            }
            catch (Exception exception2) {
                exception = exception2;
                ProcessorUtil.waitBetweenTries();
                continue;
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
        executorService.shutdown();
        if (bl) {
            return ProcessorUtil.logFailureAndGetDefaultValue("com.mathworks.toolbox.distcomp.util.NativeProcessorUtil.main() failed.");
        }
        if (exception instanceof TimeoutException) {
            return ProcessorUtil.logFailureAndGetDefaultValue("Timed out.");
        }
        return ProcessorUtil.logFailureAndGetDefaultValue("Unexpected failure", exception);
    }

    private static void waitBetweenTries() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static int logFailureAndGetDefaultValue(String string) {
        assert (string != null) : "message must not be null.";
        ProcessorUtil.log(ERROR_LEVEL, FAIL_MSG_PREFIX + string);
        return DEFAULT_PROCESSOR_COUNT;
    }

    private static int logFailureAndGetDefaultValue(String string, Throwable throwable) {
        assert (string != null) : "message must not be null.";
        assert (throwable != null) : "error must not be null.";
        ProcessorUtil.log(ERROR_LEVEL, FAIL_MSG_PREFIX + string, throwable);
        return DEFAULT_PROCESSOR_COUNT;
    }

    private static void log(Level level, String string) {
        assert (level != null) : "level must not be null.";
        assert (string != null) : "message must not be null.";
        ProcessorUtil.log(new LogRecord(level, string));
    }

    private static void log(Level level, String string, Throwable throwable) {
        assert (level != null) : "level must not be null.";
        assert (string != null) : "message must not be null.";
        assert (throwable != null) : "error must not be null.";
        LogRecord logRecord = new LogRecord(level, string);
        logRecord.setThrown(throwable);
        ProcessorUtil.log(logRecord);
    }

    private static void log(LogRecord logRecord) {
        Logger logger = ProcessorUtil.getLogger();
        if (logger == null) {
            return;
        }
        logRecord.setSourceClassName(ProcessorUtil.class.getName());
        logger.log(logRecord);
    }

    private static Logger getLogger() {
        boolean bl;
        Logger logger = PackageInfo.LOGGER;
        boolean bl2 = bl = logger.getHandlers().length > 0;
        while (logger != null && !bl) {
            bl = logger.getHandlers().length > 0;
            logger = logger.getUseParentHandlers() ? logger.getParent() : null;
        }
        return bl ? PackageInfo.LOGGER : LogManager.getLogManager().getLogger("net.jini");
    }

    static {
        JRE_CMD = "" + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        MDCE_BASE = System.getProperty(TOOLBOX_ROOT_SYS_PROP);
        JAR_REL = File.separator + ".." + File.separator + ".." + File.separator + "java" + File.separator + "jar" + File.separator;
        DISTCOMP_JAR = "toolbox" + File.separator + "distcomp.jar";
        ERROR_LEVEL = DistcompLevel.ONE;
        INFO_LEVEL = DistcompLevel.THREE;
    }
}

