/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class RunCallableOnce<V>
implements Callable<V>,
Runnable {
    private final AtomicBoolean fHasBeenRun;
    private Callable<V> fObjectToCall;
    private Exception fException;
    private V fResult;
    private final Object fRunMethodLock = new Object();

    public RunCallableOnce(Callable<V> callable) {
        assert (callable != null) : "RunCallableOnce cannot be passed a null object";
        this.fHasBeenRun = new AtomicBoolean(false);
        this.fObjectToCall = callable;
    }

    public RunCallableOnce(final Runnable runnable) {
        this(new Callable<V>(){

            @Override
            public V call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    @Override
    public V call() throws Exception {
        return this.runMethod();
    }

    @Override
    public void run() {
        try {
            this.runMethod();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasBeenRun() {
        return this.fHasBeenRun.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V runMethod() throws Exception {
        Object object = this.fRunMethodLock;
        synchronized (object) {
            if (!this.fHasBeenRun.get()) {
                return this.runMethodOnce();
            }
            if (this.fException != null) {
                throw this.fException;
            }
            return this.fResult;
        }
    }

    private V runMethodOnce() throws Exception {
        assert (!this.fHasBeenRun.get()) : "Attempt to run the same code twice";
        assert (this.fObjectToCall != null) : "RunCallableOnce cannot be passed a null object";
        this.fHasBeenRun.set(true);
        try {
            V v = this.fResult = this.fObjectToCall.call();
            return v;
        }
        catch (Exception exception) {
            this.fException = exception;
            throw exception;
        }
        finally {
            this.fObjectToCall = null;
        }
    }
}

