/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerProxy;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.ExporterFactory;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccess;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessProxy;
import com.mathworks.toolbox.distcomp.workunit.DistcompAccessRemote;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import java.rmi.server.ExportException;
import net.jini.id.Uuid;

public abstract class DistcompAccessImpl
implements DistcompAccessRemote {
    private static final int MAX_DISRUPTIONS_OF_READ = 20;
    protected long fMinTransferUsingDataStore;
    protected DistcompAccessProxy fProxy;
    protected WorkUnitStorage fStorage;
    private String fPersistenceDirName;
    private final ExporterFactory fExporterFactory;

    protected DistcompAccessImpl(long l, WorkUnitStorage workUnitStorage, String string, JobManagerProxy jobManagerProxy, ExporterFactory exporterFactory) throws ExportException, DistcompProxy.SerializeProxyException {
        this.fMinTransferUsingDataStore = l;
        this.fStorage = workUnitStorage;
        this.fPersistenceDirName = string;
        this.fExporterFactory = exporterFactory;
        DistcompAccess distcompAccess = this.exportAccessObject();
        this.fProxy = this.createProxy(distcompAccess, jobManagerProxy);
    }

    protected Object accessInvocation(AccessInvocation accessInvocation) throws MJSException {
        return accessInvocation.invoke();
    }

    protected abstract DistcompAccessProxy createProxy(DistcompAccess var1, JobManagerProxy var2) throws DistcompProxy.SerializeProxyException;

    private DistcompAccess exportAccessObject() throws ExportException {
        Exporter exporter = this.fExporterFactory.createExporter();
        return (DistcompAccess)((Object)exporter.export(this));
    }

    public DistcompAccess getProxy() {
        return this.fProxy;
    }

    protected abstract class AccessInvocationSmallReturn
    extends AccessInvocation {
        protected AccessInvocationSmallReturn(Uuid[] uuidArray) {
            super(uuidArray);
        }

        @Override
        protected abstract Object getReturnValue();
    }

    protected abstract class AccessInvocationWithoutReturn
    extends AccessInvocation {
        protected AccessInvocationWithoutReturn(Uuid[] uuidArray) {
            super(uuidArray);
        }

        @Override
        protected Object getReturnValue() {
            return null;
        }
    }

    protected abstract class AccessInvocation {
        protected Uuid[] iTargetIDs;

        protected AccessInvocation(Uuid[] uuidArray) {
            this.iTargetIDs = uuidArray;
        }

        protected Object invoke() throws MJSException {
            boolean bl = false;
            for (int i = 0; i < this.iTargetIDs.length; ++i) {
                try {
                    WorkUnitImpl workUnitImpl = DistcompAccessImpl.this.fStorage.readWorkUnit(this.iTargetIDs[i]);
                    this.invoke(workUnitImpl, i);
                    continue;
                }
                catch (WorkUnitNotFoundException workUnitNotFoundException) {
                    bl = true;
                }
            }
            if (bl) {
                throw new WorkUnitNotFoundException();
            }
            return this.getReturnValue();
        }

        protected abstract void invoke(WorkUnit var1, int var2) throws MJSException;

        protected abstract Object getReturnValue();
    }
}

