/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.jobmanager.WorkUnitTimeoutChecker;
import com.mathworks.toolbox.distcomp.jobmanager.WorkerPool;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteArrayItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.TransferableData;
import com.mathworks.toolbox.distcomp.storage.DataStorage;
import com.mathworks.toolbox.distcomp.storage.LargeStorageItem;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.TaskStorage;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.workunit.AlreadyRerunningException;
import com.mathworks.toolbox.distcomp.workunit.FailedTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.JobAndTaskIdentifier;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.LargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.NoRerunsLeftException;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.Task;
import com.mathworks.toolbox.distcomp.workunit.TaskAttemptIdentifier;
import com.mathworks.toolbox.distcomp.workunit.TaskDispatchInProgressException;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskLargeDataAccessor;
import com.mathworks.toolbox.distcomp.workunit.TaskStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.messages.CancelMessage;
import com.mathworks.toolbox.distcomp.workunit.messages.DelayedLocalizedCancelMessage;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.jini.id.Uuid;

public class TaskImpl
extends WorkUnitImpl
implements Task {
    public static final Charset LOG_ENCODING = Charset.forName("UTF-16LE");
    private static final long serialVersionUID = 7931717541524176485L;
    private Uuid fJobID;
    private int fNumOutArgs;
    private boolean fCaptureCommandWindowOutput;
    private byte[] fErrorStruct;
    private String fErrorMessage;
    private String fErrorIdentifier;
    private Worker fWorker;
    private String[] fAutoAttachedFileList;
    private LargeStorageItem fInputDataItem = new LargeStorageItem(0);
    private String fMLFunctionName;
    private LargeStorageItem fMLFunctionItem = new LargeStorageItem(0);
    private LargeStorageItem fOutputDataItem = new LargeStorageItem(0);
    private LargeStorageItem fCommandWindowOutputItem = new LargeStorageItem(0);
    private LargeStorageItem fLogOutputItem = new LargeStorageItem(0);
    private int fLogLevel = 0;
    private boolean fFinishedAbnormally = false;
    private int fMaximumNumberOfRetries = 1;
    private List<FailedTaskInfo> fFailedAttemptInformation = new ArrayList<FailedTaskInfo>();
    private final LargeDataAccessor fLargeDataAccessor;
    private transient boolean fDispatchInProgress = false;
    private transient boolean fShouldCancelWorkerOnDispatchEnd = false;
    private transient TaskStorage fStorage;
    private transient DataStorage fAppendableDataStorage;
    private transient DataStorage fLargeDataStorage;

    public TaskImpl(Uuid uuid, long l, String string) {
        super(string);
        this.fName = this.getDefaultName();
        this.fNum = l;
        this.fJobID = uuid;
        this.fLargeDataAccessor = new TaskLargeDataAccessor(this.fJobID, this.getID());
    }

    public TaskImpl(Uuid uuid, long l) {
        super(System.getProperty("user.name"));
        this.fName = this.getDefaultName();
        this.fNum = l;
        this.fJobID = uuid;
        this.fLargeDataAccessor = new TaskLargeDataAccessor(this.fJobID, this.getID());
    }

    public TaskImpl(Uuid uuid, long l, TimeProvider timeProvider) {
        super(System.getProperty("user.name"), timeProvider);
        this.fName = this.getDefaultName();
        this.fNum = l;
        this.fJobID = uuid;
        this.fLargeDataAccessor = new TaskLargeDataAccessor(this.fJobID, this.getID());
    }

    private TaskImpl(Uuid uuid, long l, String string, boolean bl, int n, int n2, String string2, int n3, LargeStorageItem largeStorageItem, LargeStorageItem largeStorageItem2) {
        super(string);
        this.fName = this.getDefaultName();
        this.fNum = l;
        this.fJobID = uuid;
        this.fCaptureCommandWindowOutput = bl;
        this.fMaximumNumberOfRetries = n;
        this.fNumOutArgs = n2;
        this.fMLFunctionName = string2;
        this.fLogLevel = n3;
        this.fInputDataItem = largeStorageItem;
        this.fMLFunctionItem = largeStorageItem2;
        this.fLargeDataAccessor = new TaskLargeDataAccessor(this.fJobID, this.getID());
    }

    public TaskImpl deepCopy(Uuid uuid, long l, String string) throws StorageException {
        Uuid uuid2 = this.fLargeDataStorage.copyData(this.fInputDataItem.getDataID());
        Uuid uuid3 = this.fLargeDataStorage.copyData(this.fMLFunctionItem.getDataID());
        LargeStorageItem largeStorageItem = new LargeStorageItem(uuid2, this.fInputDataItem.getNumBytes());
        LargeStorageItem largeStorageItem2 = new LargeStorageItem(uuid3, this.fMLFunctionItem.getNumBytes());
        TaskImpl taskImpl = new TaskImpl(uuid, l, string, this.fCaptureCommandWindowOutput, this.fMaximumNumberOfRetries, this.fNumOutArgs, this.fMLFunctionName, this.fLogLevel, largeStorageItem, largeStorageItem2);
        taskImpl.fFailedAttemptInformation.addAll(this.fFailedAttemptInformation);
        taskImpl.resetLock();
        taskImpl.setTaskStorage(this.fStorage);
        taskImpl.setLargeDataStorage(this.fLargeDataStorage);
        taskImpl.setAppendableDataStorage(this.fAppendableDataStorage);
        taskImpl.setPendingModificationListener(this.getPendingModificationListener());
        taskImpl.setAuthorisedUsers(this.getAuthorisedUsers());
        return taskImpl;
    }

    public static TaskImpl create(ObjectInputStream objectInputStream, long l, int n) throws IOException, ClassNotFoundException {
        TaskImpl taskImpl = (TaskImpl)objectInputStream.readObject();
        taskImpl.fNum = l;
        taskImpl.fState = n;
        return taskImpl;
    }

    void setTaskStorage(TaskStorage taskStorage) {
        this.setWorkUnitStorage(taskStorage);
        this.fStorage = taskStorage;
    }

    void setAppendableDataStorage(DataStorage dataStorage) {
        this.fAppendableDataStorage = dataStorage;
        for (FailedTaskInfo failedTaskInfo : this.fFailedAttemptInformation) {
            failedTaskInfo.setCommandWindowOutputStorage(dataStorage);
        }
    }

    void setLargeDataStorage(DataStorage dataStorage) {
        this.fLargeDataStorage = dataStorage;
    }

    @Override
    public boolean isCaptureCommandWindowOutput() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return TaskImpl.this.fCaptureCommandWindowOutput;
            }
        });
    }

    @Override
    public int getNumOutArgs() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fNumOutArgs;
            }
        });
    }

    public int getInputDataSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fInputDataItem.getNumBytes();
            }
        });
    }

    public int getMLFunctionSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fMLFunctionItem.getNumBytes();
            }
        });
    }

    public int getOutputDataSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fOutputDataItem.getNumBytes();
            }
        });
    }

    public int getCommandWindowOutputSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fCommandWindowOutputItem.getNumBytes();
            }
        });
    }

    public int getLogOutputSize() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fLogOutputItem.getNumBytes();
            }
        });
    }

    public byte[] getInputData() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fInputDataItem, TaskImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getInputData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fInputDataItem, outputStream, TaskImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    @Override
    public String getMLFunctionName() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return TaskImpl.this.fMLFunctionName;
            }
        });
    }

    public byte[] getMLFunction() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fMLFunctionItem, TaskImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getMLFunction(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fMLFunctionItem, outputStream, TaskImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getOutputData() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fOutputDataItem, TaskImpl.this.fLargeDataStorage);
            }
        });
    }

    public void getOutputData(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fOutputDataItem, outputStream, TaskImpl.this.fLargeDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getCommandWindowOutput() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fCommandWindowOutputItem, TaskImpl.this.fAppendableDataStorage);
            }
        });
    }

    public void getCommandWindowOutput(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fCommandWindowOutputItem, outputStream, TaskImpl.this.fAppendableDataStorage, n);
                return null;
            }
        });
    }

    public byte[] getLogOutput() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<byte[]>(){

            @Override
            public byte[] invoke() throws MJSException {
                return TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fLogOutputItem, TaskImpl.this.fAppendableDataStorage);
            }
        });
    }

    public void getLogOutput(final OutputStream outputStream, final int n) throws MJSException {
        this.invokeWithReadLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLargeDataAccessor.readLargeData(TaskImpl.this.fLogOutputItem, outputStream, TaskImpl.this.fAppendableDataStorage, n);
                return null;
            }
        });
    }

    @Override
    public byte[] getErrorStruct() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<byte[]>(){

            @Override
            public byte[] invoke() {
                return TaskImpl.this.fErrorStruct;
            }
        });
    }

    @Override
    public String getErrorMessage() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return TaskImpl.this.fErrorMessage;
            }
        });
    }

    @Override
    public String getErrorIdentifier() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return TaskImpl.this.fErrorIdentifier;
            }
        });
    }

    @Override
    public Worker getWorker() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Worker>(){

            @Override
            public Worker invoke() {
                return TaskImpl.this.fWorker;
            }
        });
    }

    @Override
    public Uuid getJob() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Uuid>(){

            @Override
            public Uuid invoke() {
                return TaskImpl.this.fJobID;
            }
        });
    }

    @Override
    public TaskInfo getWorkUnitInfo() throws MJSException {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<TaskInfo>(){

            @Override
            public TaskInfo invoke() {
                return new TaskInfo(TaskImpl.this.fName, TaskImpl.this.fTimeout, TaskImpl.this.fNum, TaskImpl.this.fState, TaskImpl.this.fCreateTime, TaskImpl.this.fStartTime, TaskImpl.this.fFinishTime, TaskImpl.this.getRunningDuration(), TaskImpl.this.fCaptureCommandWindowOutput, TaskImpl.this.fMaximumNumberOfRetries, TaskImpl.this.fNumOutArgs, TaskImpl.this.fErrorStruct, TaskImpl.this.fErrorMessage, TaskImpl.this.fErrorIdentifier, TaskImpl.this.fWorker, TaskImpl.this.fMLFunctionName, TaskImpl.this.fJobID, TaskImpl.this.fLogLevel, TaskImpl.getListenerInfosFromMap(TaskImpl.this.fListenerInfoToNumEvents));
            }
        });
    }

    @Override
    public int getLogLevel() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fLogLevel;
            }
        });
    }

    @Override
    public int getMaximumNumberOfRetries() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fMaximumNumberOfRetries;
            }
        });
    }

    @Override
    public int getAttemptedNumberOfRetries() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return TaskImpl.this.fFailedAttemptInformation.size();
            }
        });
    }

    @Override
    public FailedTaskInfo[] getFailedAttemptInformation() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<FailedTaskInfo[]>(){

            @Override
            public FailedTaskInfo[] invoke() {
                return TaskImpl.this.fFailedAttemptInformation.toArray(new FailedTaskInfo[TaskImpl.this.fFailedAttemptInformation.size()]);
            }
        });
    }

    @Override
    public String[] getAutoAttachedFileList() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<String[]>(){

            @Override
            public String[] invoke() {
                return TaskImpl.this.fAutoAttachedFileList;
            }
        });
    }

    public void setAuthorisedUsers(final String[] stringArray) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.setWorkUnitAuthorisedUsers(stringArray);
                return null;
            }
        });
    }

    @Override
    public void setAutoAttachedFileList(final String[] stringArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("AutoAttachedFileList");
                TaskImpl.access$2102(TaskImpl.this, stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length));
                return null;
            }
        });
    }

    @Override
    public void setCaptureCommandWindowOutput(final boolean bl) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("CaptureCommandWindowOutput");
                TaskImpl.this.fCaptureCommandWindowOutput = bl;
                return null;
            }
        });
    }

    public void setUserName(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.setWorkUnitUserName(string);
                return null;
            }
        });
    }

    @Override
    public void setNumOutArgs(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("NumberOfOutputArguments");
                TaskImpl.this.fNumOutArgs = n;
                return null;
            }
        });
    }

    public void setInputData(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("InputArguments");
                TaskImpl.this.fInputDataItem = TaskImpl.this.fLargeDataAccessor.writeLargeData(TaskImpl.this.fInputDataItem, transferableData, TaskImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    @Override
    public void setMLFunctionName(final String string) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("FunctionName");
                TaskImpl.this.fMLFunctionName = string;
                return null;
            }
        });
    }

    public void setMLFunction(final TransferableData transferableData) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("Function");
                TaskImpl.this.fMLFunctionItem = TaskImpl.this.fLargeDataAccessor.writeLargeData(TaskImpl.this.fMLFunctionItem, transferableData, TaskImpl.this.fLargeDataStorage);
                return null;
            }
        });
    }

    public void setErrorMessage(final String string) throws TaskStateException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.fErrorMessage = string;
                return null;
            }
        });
    }

    public void setErrorIdentifier(final String string) throws TaskStateException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.fErrorIdentifier = string;
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfoSmallItems(WorkUnitInfo workUnitInfo) throws MJSException {
        final TaskInfo taskInfo = (TaskInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("TaskInfoSmallItems");
                TaskImpl.this.doSetName(taskInfo.getName());
                TaskImpl.this.fTimeout = taskInfo.getTimeout();
                TaskImpl.this.fCaptureCommandWindowOutput = taskInfo.isCaptureCommandWindowOutput();
                TaskImpl.this.fMaximumNumberOfRetries = taskInfo.getMaximumNumberOfRetries();
                TaskImpl.this.fFailedAttemptInformation = new ArrayList();
                TaskImpl.this.fNumOutArgs = taskInfo.getNumOutArgs();
                TaskImpl.this.fLogLevel = taskInfo.getLogLevel();
                TaskImpl.this.fMLFunctionName = taskInfo.getMLFunctionName();
                TaskImpl.this.fListenerInfoToNumEvents = TaskImpl.createListenerInfosMap(taskInfo.getListenerInfo());
                return null;
            }
        });
    }

    @Override
    public void setWorkUnitInfo(WorkUnitInfo workUnitInfo) throws MJSException {
        final TaskInfo taskInfo = (TaskInfo)workUnitInfo;
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("TaskInfo");
                TaskImpl.this.doSetName(taskInfo.getName());
                TaskImpl.this.fTimeout = taskInfo.getTimeout();
                TaskImpl.this.fCaptureCommandWindowOutput = taskInfo.isCaptureCommandWindowOutput();
                TaskImpl.this.fMaximumNumberOfRetries = taskInfo.getMaximumNumberOfRetries();
                TaskImpl.this.fFailedAttemptInformation = new ArrayList();
                TaskImpl.this.fNumOutArgs = taskInfo.getNumOutArgs();
                TaskImpl.this.fLogLevel = taskInfo.getLogLevel();
                TaskImpl.this.fInputDataItem = TaskImpl.this.fLargeDataAccessor.writeLargeData(TaskImpl.this.fInputDataItem, (TransferableData)taskInfo.getInputData(), TaskImpl.this.fLargeDataStorage);
                TaskImpl.this.fMLFunctionItem = TaskImpl.this.fLargeDataAccessor.writeLargeData(TaskImpl.this.fMLFunctionItem, (TransferableData)taskInfo.getMLFunction(), TaskImpl.this.fLargeDataStorage);
                TaskImpl.this.fMLFunctionName = taskInfo.getMLFunctionName();
                TaskImpl.this.fListenerInfoToNumEvents = TaskImpl.createListenerInfosMap(taskInfo.getListenerInfo());
                return null;
            }
        });
    }

    @Override
    public void setLogLevel(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("LogLevel");
                TaskImpl.this.fLogLevel = n;
                return null;
            }
        });
    }

    @Override
    public void addToLogOutput(final String string) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fLogOutputItem = TaskImpl.this.fLargeDataAccessor.appendToLargeData(TaskImpl.this.fLogOutputItem, new ByteArrayItem(string.getBytes(LOG_ENCODING)), TaskImpl.this.fAppendableDataStorage);
                return null;
            }
        });
    }

    @Override
    public void writeCommandWindowOutput(final byte[] byArray) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.fCommandWindowOutputItem = TaskImpl.this.fLargeDataAccessor.appendToLargeData(TaskImpl.this.fCommandWindowOutputItem, new ByteArrayItem(byArray), TaskImpl.this.fAppendableDataStorage);
                return null;
            }
        });
    }

    @Override
    public void setMaximumNumberOfRetries(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                TaskImpl.this.checkStateBeforeSet("MaximumNumberOfRetries");
                TaskImpl.this.fMaximumNumberOfRetries = n;
                return null;
            }
        });
    }

    @Override
    public void submitResult(final TransferableData transferableData, final byte[] byArray, final String string, final String string2, final TransferableData transferableData2) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (TaskImpl.this.fState == 0) {
                    TaskImpl.this.startTaskRunning();
                }
                if (TaskImpl.this.fState == 2) {
                    TaskImpl.this.fOutputDataItem = TaskImpl.this.fLargeDataAccessor.writeLargeData(TaskImpl.this.fOutputDataItem, transferableData, TaskImpl.this.fLargeDataStorage);
                    TaskImpl.access$1102(TaskImpl.this, byArray == null ? null : Arrays.copyOf(byArray, byArray.length));
                    TaskImpl.this.fErrorMessage = string;
                    TaskImpl.this.fErrorIdentifier = string2;
                    if (TaskImpl.this.fErrorMessage != null && !TaskImpl.this.fErrorMessage.isEmpty() || TaskImpl.this.fErrorIdentifier != null && !TaskImpl.this.fErrorIdentifier.isEmpty()) {
                        TaskImpl.this.fFinishedAbnormally = true;
                    }
                    TaskImpl.this.fCommandWindowOutputItem = TaskImpl.this.fLargeDataAccessor.appendToLargeData(TaskImpl.this.fCommandWindowOutputItem, transferableData2, TaskImpl.this.fAppendableDataStorage);
                    TaskImpl.this.finishTaskNormally();
                }
                return null;
            }
        });
        this.notifyJobOfCompletion();
    }

    public boolean isFinishedAbnormally() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return TaskImpl.this.fState == 3 && TaskImpl.this.fFinishedAbnormally;
            }
        });
    }

    private boolean isFinished() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return TaskImpl.this.fState == 3;
            }
        });
    }

    public void dispatchBegun(final Worker worker) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdate<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (TaskImpl.this.fState != 0) {
                    throw new InvalidStateForDispatchException();
                }
                if (TaskImpl.this.fMLFunctionItem.getNumBytes() <= 0) {
                    throw new DispatchWithoutTaskInfoException();
                }
                TaskImpl.this.fDispatchInProgress = true;
                TaskImpl.this.fWorker = worker;
                return null;
            }
        });
    }

    public void dispatchFailed() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdateNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.fDispatchInProgress = false;
                return null;
            }
        });
    }

    public void dispatchSucceeded() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                if (TaskImpl.this.fShouldCancelWorkerOnDispatchEnd) {
                    WorkerPool.instance().cancelTaskOnWorker(new WorkerTaskInfo(TaskImpl.this.fWorker, new JobAndTaskIdentifier(TaskImpl.this.getJob(), TaskImpl.this.getID())));
                } else if (TaskImpl.this.fState == 0) {
                    TaskImpl.this.startTaskRunning();
                }
                return null;
            }
        });
    }

    @Override
    public String workUnitTypeForPrinting() {
        return "task";
    }

    @Override
    public void cancel(CancelMessage cancelMessage) throws MJSException {
        boolean bl = true;
        this.cancelAndNotifyJob(cancelMessage, bl);
    }

    public void cancelAndNotifyJob(CancelMessage cancelMessage, boolean bl) throws MJSException {
        this.cancelWithoutNotifyingJob(cancelMessage, bl);
        this.notifyJobOfCompletion();
    }

    public void cancelWithoutNotifyingJob(final CancelMessage cancelMessage, final boolean bl) {
        boolean bl2 = this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                boolean bl2 = TaskImpl.this.isTaskRunningOnWorker();
                if (TaskImpl.this.fDispatchInProgress && !bl2) {
                    TaskImpl.this.fShouldCancelWorkerOnDispatchEnd = bl;
                }
                TaskImpl.this.finishTaskAbnormally(cancelMessage);
                return bl2;
            }
        });
        if (bl && bl2) {
            WorkerPool.instance().cancelTaskOnWorker(new WorkerTaskInfo(this.fWorker, new JobAndTaskIdentifier(this.getJob(), this.getID())));
        }
    }

    @Override
    public void destroy() throws MJSException {
        boolean bl = true;
        this.destroyAndNotifyJob(bl);
    }

    public void destroyAndNotifyJob(boolean bl) throws MJSException {
        this.destroyWithoutNotifyingJob(bl);
        this.notifyJobOfCompletion();
    }

    public void destroyWithoutNotifyingJob(boolean bl) throws MJSException {
        boolean bl2 = this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdate<Boolean>(){

            @Override
            public Boolean invoke() throws MJSException {
                boolean bl = TaskImpl.this.isTaskRunningOnWorker();
                TaskImpl.this.finishTaskAbnormally(new TaskDestroyedMessage());
                TaskImpl.this.fStorage.removeTask(TaskImpl.this.getID());
                return bl;
            }
        });
        if (bl && bl2) {
            WorkerPool.instance().cancelTaskOnWorker(new WorkerTaskInfo(this.fWorker, new JobAndTaskIdentifier(this.getJob(), this.getID())));
        }
    }

    public WorkerTaskInfo getWorkerTaskInfo() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<WorkerTaskInfo>(){

            @Override
            public WorkerTaskInfo invoke() {
                return new WorkerTaskInfo(TaskImpl.this.fWorker, new JobAndTaskIdentifier(TaskImpl.this.getJob(), new TaskAttemptIdentifier(TaskImpl.this.getID(), TaskImpl.this.fFailedAttemptInformation.size())));
            }
        });
    }

    @Override
    public void rerunOrCancel(CancelMessage cancelMessage) throws MJSException {
        this.rerunOrCancel(cancelMessage, true);
    }

    public void rerunOrCancel(CancelMessage cancelMessage, boolean bl) throws MJSException {
        JobImpl jobImpl;
        if (this.isFinished()) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " is being rerun or cancelled");
        assert (!this.fShouldCancelWorkerOnDispatchEnd) : "Rerunning a task with cancel on dispatch end will result in an infinite loop";
        Uuid uuid = this.getJob();
        try {
            jobImpl = (JobImpl)this.fStorage.readWorkUnit(uuid);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            this.cancelWithoutNotifyingJob(new NoJobFoundMessage(workUnitNotFoundException, cancelMessage), bl);
            return;
        }
        try {
            Collection<WorkerTaskInfo> collection = jobImpl.rerunTask(this, cancelMessage);
            if (WorkerPool.instance() != null) {
                for (WorkerTaskInfo workerTaskInfo : collection) {
                    WorkerPool.instance().removeTaskFromWorker(workerTaskInfo);
                }
            }
        }
        catch (AlreadyRerunningException alreadyRerunningException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " is already being rerun");
        }
        catch (NoRerunsLeftException noRerunsLeftException) {
            this.cancelAndNotifyJob(new TaskNoRerunsLeftMessage(noRerunsLeftException, cancelMessage), bl);
        }
        catch (WorkUnitStateException workUnitStateException) {
            this.cancelAndNotifyJob(new TaskIncorrectStateToRerunMessage(workUnitStateException, cancelMessage), bl);
        }
        catch (MJSException mJSException) {
            this.cancelAndNotifyJob(new TaskRerunFailedMessage(mJSException, cancelMessage), bl);
        }
    }

    public void checkTaskCanRerun() throws AlreadyRerunningException, NoRerunsLeftException {
        if (this.getState() == 0) {
            throw new AlreadyRerunningException((BaseMsgID)new mjs.TaskAlreadyRerunning());
        }
        if (!this.anyRerunsLeft()) {
            throw new NoRerunsLeftException((BaseMsgID)new mjs.NoRerunAttemptsLeft());
        }
    }

    private boolean anyRerunsLeft() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                return TaskImpl.this.fFailedAttemptInformation.size() < TaskImpl.this.fMaximumNumberOfRetries;
            }
        });
    }

    public void prepareToRerun() {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.stopTaskRunning();
                TaskImpl.this.storeAndResetTaskInfo();
                return null;
            }
        });
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "rerun: " + this.workUnitTypeForPrinting() + " " + this.fNum + " has been successfully prepared to rerun");
    }

    private void storeAndResetTaskInfo() {
        this.switchToFinishedStateForRerun();
        FailedTaskInfo failedTaskInfo = new FailedTaskInfo(this.fStartTime, this.fCommandWindowOutputItem, this.fErrorStruct, this.fErrorMessage, this.fErrorIdentifier, this.fWorker, this.fLargeDataAccessor);
        failedTaskInfo.setCommandWindowOutputStorage(this.fAppendableDataStorage);
        this.fFailedAttemptInformation.add(failedTaskInfo);
        this.resetWorkUnitInfoForRerun();
    }

    private void switchToFinishedStateForRerun() {
        this.fState = 3;
        this.fFinishTime = System.currentTimeMillis();
    }

    @Override
    protected void resetWorkUnitInfoForRerun() {
        super.resetWorkUnitInfoForRerun();
        this.fErrorIdentifier = null;
        this.fErrorMessage = null;
        this.fCommandWindowOutputItem = new LargeStorageItem(0);
        this.fWorker = null;
    }

    @Override
    protected void checkStateBeforeSet(String string) throws WorkUnitStateException {
        if (this.fDispatchInProgress) {
            throw new TaskDispatchInProgressException(string);
        }
        super.checkStateBeforeSet(string);
    }

    @Override
    protected String getDefaultName() {
        return "Task" + this.fNum;
    }

    private void notifyJobOfCompletion() throws MJSException {
        try {
            JobImpl jobImpl = (JobImpl)this.fStorage.readWorkUnit(this.fJobID);
            jobImpl.taskCompleted(this);
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            // empty catch block
        }
    }

    private boolean isTaskRunningOnWorker() {
        return this.fState == 2 && this.fWorker != null;
    }

    private void finishTaskAbnormally(CancelMessage cancelMessage) {
        if (this.fState != 3) {
            this.finishTask();
            this.fErrorIdentifier = "distcomp:task:Cancelled";
            this.fErrorMessage = cancelMessage.getLocalizedMessage();
            this.fFinishedAbnormally = true;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, this.workUnitTypeForPrinting() + " " + this.fNum + " has been cancelled, because: " + cancelMessage.getMessage());
        }
    }

    private void finishTaskNormally() {
        this.finishTask();
        PackageInfo.LOGGER.log(DistcompLevel.TWO, this.workUnitTypeForPrinting() + " " + this.fNum + " has finished");
    }

    private void finishTask() {
        this.stopTaskRunning();
        this.switchToFinishedState();
    }

    private void startTaskRunning() {
        this.fDispatchInProgress = false;
        this.switchToRunningState();
        WorkUnitTimeoutChecker.instance().addWorkUnit(this.getID(), this.fTimeout);
        PackageInfo.LOGGER.log(DistcompLevel.TWO, this.workUnitTypeForPrinting() + " " + this.fNum + " has started running");
    }

    private void stopTaskRunning() {
        WorkUnitTimeoutChecker.instance().removeWorkUnit(this.getID());
    }

    @Override
    public String toString() {
        return this.fName + " (" + this.getDefaultName() + "): " + this.getID() + ", of job with id: " + this.fJobID;
    }

    static /* synthetic */ String[] access$2102(TaskImpl taskImpl, String[] stringArray) {
        taskImpl.fAutoAttachedFileList = stringArray;
        return stringArray;
    }

    static /* synthetic */ byte[] access$1102(TaskImpl taskImpl, byte[] byArray) {
        taskImpl.fErrorStruct = byArray;
        return byArray;
    }

    private static class TaskRerunFailedMessage
    extends DelayedLocalizedCancelMessage {
        TaskRerunFailedMessage(MJSException mJSException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.TaskRerunFailed(mJSException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.TaskRerunFailed(mJSException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class TaskIncorrectStateToRerunMessage
    extends DelayedLocalizedCancelMessage {
        TaskIncorrectStateToRerunMessage(WorkUnitStateException workUnitStateException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.TaskIncorrectStateToRerun(workUnitStateException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.TaskIncorrectStateToRerun(workUnitStateException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class TaskNoRerunsLeftMessage
    extends DelayedLocalizedCancelMessage {
        TaskNoRerunsLeftMessage(NoRerunsLeftException noRerunsLeftException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.TaskNoRerunsLeft(noRerunsLeftException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.TaskNoRerunsLeft(noRerunsLeftException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class NoJobFoundMessage
    extends DelayedLocalizedCancelMessage {
        NoJobFoundMessage(WorkUnitNotFoundException workUnitNotFoundException, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.NoJobFound(workUnitNotFoundException.getMessage(), cancelMessage.getMessage()), (BaseMsgID)new mjs.NoJobFound(workUnitNotFoundException.getLocalizedMessage(), cancelMessage.getLocalizedMessage()));
        }
    }

    private static class TaskDestroyedMessage
    extends SimpleCancelMessage {
        TaskDestroyedMessage() {
            super((BaseMsgID)new mjs.TaskDestroyed());
        }
    }

    private static class DispatchWithoutTaskInfoException
    extends TaskStateException {
        private DispatchWithoutTaskInfoException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.CannotDispatchWithoutTaskInfo();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.CannotDispatchWithoutTaskInfo();
        }
    }

    private static class InvalidStateForDispatchException
    extends TaskStateException {
        private InvalidStateForDispatchException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new mjs.IncorrectTaskStateForDispatch();
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new mjs.IncorrectTaskStateForDispatch();
        }
    }
}

