/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices.ws_client_core.webproxy;

import com.mathworks.mlwebservices.ws_client_core.webproxy.ProxyServerCredentialsProviderAdapter;
import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;

final class ClientProxyConfigurationVisitor
implements ProxyConfigurationVisitor {
    private final MathWorksWebServiceClient client;
    private final URL url;

    ClientProxyConfigurationVisitor(MathWorksWebServiceClient mathWorksWebServiceClient, URL uRL) {
        this.client = mathWorksWebServiceClient;
        this.url = uRL;
    }

    public void visit(PropertiesProxyConfiguration propertiesProxyConfiguration) {
        Proxy proxy = propertiesProxyConfiguration.findProxyForURL(this.url);
        if (ClientProxyConfigurationVisitor.isProxy(proxy)) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            String string = inetSocketAddress.getHostName();
            int n = inetSocketAddress.getPort();
            PasswordAuthentication passwordAuthentication = propertiesProxyConfiguration.getPasswordAuthentication();
            if (passwordAuthentication.getUserName() == null) {
                this.client.setProxyConfiguration(string, n);
            } else {
                this.client.setProxyConfiguration(string, n, passwordAuthentication.getUserName(), String.valueOf(passwordAuthentication.getPassword()));
            }
        } else {
            this.client.clearProxySettings();
        }
    }

    public void visit(SystemProxyConfiguration systemProxyConfiguration) {
        Proxy proxy = systemProxyConfiguration.findProxyForURL(this.url);
        if (ClientProxyConfigurationVisitor.isProxy(proxy)) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            String string = inetSocketAddress.getHostName();
            int n = inetSocketAddress.getPort();
            this.client.setProxyConfiguration(string, n, (ProxyServerCredentialsProvider)new ProxyServerCredentialsProviderAdapter(inetSocketAddress, this.url));
        } else {
            this.client.clearProxySettings();
        }
    }

    private static boolean isProxy(Proxy proxy) {
        return !proxy.equals(Proxy.NO_PROXY);
    }
}

