/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.accessories;

import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.CustomizablePopupMenu;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.accessories.CollapseToolstripAction;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.accessories.Resources;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.accessories.TSUtilities;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSToolPath;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ToolstripContextMenu {
    private static boolean sIsListenerInstalled = false;
    private static Component sPressedComponent;

    private ToolstripContextMenu() {
    }

    public static void install(Toolstrip toolstrip) {
        toolstrip.getComponent().addMouseListener(new MouseAdapter(){});
        if (!sIsListenerInstalled) {
            Toolkit.getDefaultToolkit().addAWTEventListener(new ContextEventListener(), 16L);
            sIsListenerInstalled = true;
        }
    }

    public static void uninstall(Toolstrip toolstrip) {
    }

    private static void populateMenu(JPopupMenu jPopupMenu, Component component, MouseEvent mouseEvent, ToolInfo toolInfo, boolean bl, boolean bl2) {
        ToolstripContextMenu.addActions(jPopupMenu, toolInfo, bl, bl2);
        ToolstripContextMenu.getAncestorContributions(jPopupMenu, component, mouseEvent);
        Boolean bl3 = (Boolean)jPopupMenu.getClientProperty("retain-overlays");
        if (bl3 == null || !bl3.booleanValue()) {
            jPopupMenu.addPopupMenuListener(new PopupCloser(component));
        }
    }

    private static void getAncestorContributions(JPopupMenu jPopupMenu, Component component, MouseEvent mouseEvent) {
        do {
            TSContextMenuContributor tSContextMenuContributor;
            if (component instanceof TSContextMenuContributor) {
                ((TSContextMenuContributor)((Object)component)).contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
            }
            if (!(component instanceof JComponent) || (tSContextMenuContributor = (TSContextMenuContributor)((JComponent)component).getClientProperty("toolstrip-context-menu-contributor")) == null) continue;
            tSContextMenuContributor.contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
        } while ((component = component.getParent()) != null);
    }

    private static ToolInfo getToolInfo(Component component, Point point) {
        ToolInfo toolInfo = new ToolInfo();
        if (component instanceof PopupList) {
            PopupList popupList = (PopupList)component;
            int n = popupList.locationToIndex(point);
            if (n >= 0) {
                ListItem listItem = (ListItem)popupList.getModel().getElementAt(n);
                toolInfo.iToolPath = (TSToolPath)listItem.getAttributes().getAttribute(TSFactory.TOOL_PATH_ATTRIBUTE);
            }
            toolInfo.iComponent = (JComponent)component;
        } else {
            if (component instanceof JComponent) {
                toolInfo.iComponent = (JComponent)component;
            }
            for (Component component2 = component; toolInfo.iToolPath == null && component2 != null; component2 = component2.getParent()) {
                if (component2 instanceof JComponent) {
                    Item item;
                    toolInfo.iToolPath = (TSToolPath)((JComponent)component2).getClientProperty("tool path");
                    if (toolInfo.iToolPath == null && (item = (Item)((JComponent)component2).getClientProperty("item")) != null) {
                        toolInfo.iToolPath = (TSToolPath)item.getAction().getValue("tool path");
                    }
                    if (toolInfo.iToolPath != null && ((JComponent)component2).getClientProperty("not quick access eligible") != null) {
                        toolInfo.iToolPath = null;
                        break;
                    }
                }
                if (toolInfo.iToolPath != null || ToolstripContextMenu.isToolComponent(component2)) break;
            }
        }
        toolInfo.iToolstrip = TSRobot.getToolstripFor(component);
        toolInfo.iQuickAccessBar = toolInfo.iToolstrip != null ? TSRobot.getQuickAccessToolBar(toolInfo.iToolstrip) : TSRobot.getQuickAccessToolBarAncestor(component);
        return toolInfo;
    }

    private static boolean isToolComponent(Component component) {
        if (component instanceof JComponent) {
            Boolean bl = (Boolean)((JComponent)component).getClientProperty("tool component");
            return bl != null && bl != false;
        }
        return false;
    }

    private static boolean quickAccessActionAvailable(ToolInfo toolInfo) {
        return toolInfo.iToolPath != null;
    }

    private static boolean collapseActionAvailable(ToolInfo toolInfo) {
        if (toolInfo.iToolstrip == null || toolInfo.iComponent == null || !SwingUtilities.isDescendingFrom(toolInfo.iComponent, toolInfo.iToolstrip.getComponent()) && !SwingUtilities.isDescendingFrom(toolInfo.iComponent, ((DefaultToolstrip)toolInfo.iToolstrip).getContentPanel()) && toolInfo.iComponent != ((DefaultToolstrip)toolInfo.iToolstrip).getContentPanel()) {
            return false;
        }
        return toolInfo.iQuickAccessBar == null || toolInfo.iComponent != toolInfo.iQuickAccessBar.getComponent() && !SwingUtilities.isDescendingFrom(toolInfo.iComponent, (Component)toolInfo.iQuickAccessBar.getComponent());
    }

    private static void addActions(JPopupMenu jPopupMenu, ToolInfo toolInfo, boolean bl, boolean bl2) {
        if (bl) {
            ToolstripContextMenu.addQuickAccessActions(jPopupMenu, toolInfo);
            if (bl2) {
                jPopupMenu.addSeparator();
            }
        }
        if (bl2) {
            jPopupMenu.add((Action)((Object)new CollapseToolstripAction(toolInfo.iToolstrip)));
        }
    }

    private static void addQuickAccessActions(JPopupMenu jPopupMenu, ToolInfo toolInfo) {
        if (SwingUtilities.isDescendingFrom(toolInfo.iComponent, (Component)toolInfo.iQuickAccessBar.getComponent())) {
            jPopupMenu.add((Action)((Object)new RemoveFromQuickAccessAction(toolInfo.iQuickAccessBar, toolInfo.iToolPath)));
            if ((toolInfo.iComponent instanceof MJButton || toolInfo.iComponent instanceof MJToggleButton) && ((AbstractButton)toolInfo.iComponent).getIcon() != null) {
                jPopupMenu.add((Action)((Object)new ToggleLabelVisibilityAction(toolInfo.iQuickAccessBar, toolInfo.iToolPath)));
            }
        } else {
            jPopupMenu.add((Action)((Object)new AddToQuickAccessAction(toolInfo.iQuickAccessBar, toolInfo.iToolPath)));
        }
    }

    private static class ToggleLabelVisibilityAction
    extends MJAbstractAction {
        private final QuickAccessConfiguration iQuickConfig;
        private final TSToolPath iToolPath;

        ToggleLabelVisibilityAction(QuickAccessToolBar quickAccessToolBar, TSToolPath tSToolPath) {
            this.setComponentName("ToggleLabelVisibility");
            this.iQuickConfig = quickAccessToolBar.getConfiguration();
            this.iToolPath = tSToolPath;
            this.setName(Resources.getString(this.iQuickConfig.isLabelVisible(tSToolPath) ? "menuitem.HideLabel" : "menuitem.ShowLabel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iQuickConfig.setLabelVisible(this.iToolPath, !this.iQuickConfig.isLabelVisible(this.iToolPath));
        }
    }

    private static class RemoveFromQuickAccessAction
    extends MJAbstractAction {
        private final QuickAccessConfiguration iQuickConfig;
        private final TSToolPath iToolPath;

        RemoveFromQuickAccessAction(QuickAccessToolBar quickAccessToolBar, TSToolPath tSToolPath) {
            super(Resources.getString("menuitem.RemoveFromQuickAccess"));
            this.setComponentName("RemoveFromQuickAccess");
            this.iQuickConfig = quickAccessToolBar.getConfiguration();
            this.iToolPath = tSToolPath;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iQuickConfig.removeTool(this.iToolPath);
        }
    }

    private static class AddToQuickAccessAction
    extends MJAbstractAction {
        private final QuickAccessConfiguration iQuickConfig;
        private final TSToolPath iToolPath;
        private final int iGrowthEnd;

        AddToQuickAccessAction(QuickAccessToolBar quickAccessToolBar, TSToolPath tSToolPath) {
            super(Resources.getString("menuitem.AddToQuickAccess"));
            this.setComponentName("AddToQuickAccess");
            this.iQuickConfig = quickAccessToolBar.getConfiguration();
            this.iToolPath = tSToolPath;
            this.iGrowthEnd = quickAccessToolBar.getGrowthEnd();
            this.setEnabled(!this.iQuickConfig.containsTool(tSToolPath));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iGrowthEnd == 2) {
                this.iQuickConfig.insertTool(0, this.iToolPath);
            } else {
                this.iQuickConfig.addTool(this.iToolPath);
            }
        }
    }

    private static class PopupCloser
    implements PopupMenuListener {
        private Component iComponent;
        private boolean iWasCanceled;

        private PopupCloser(Component component) {
            this.iComponent = component;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.iWasCanceled = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            OverlayManager overlayManager;
            if (!this.iWasCanceled && (overlayManager = OverlayManagers.get((Component)this.iComponent)) != null) {
                overlayManager.removePopups();
            }
            ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.iWasCanceled = true;
        }
    }

    private static class ContextEventListener
    implements AWTEventListener {
        private ContextEventListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof MouseEvent) {
                final MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (aWTEvent.getID() == 501) {
                    sPressedComponent = mouseEvent.getComponent();
                }
                boolean bl = mouseEvent.isPopupTrigger() && mouseEvent.getID() != 504 && mouseEvent.getID() != 505;
                final Component component = mouseEvent.getComponent();
                if (bl && component == sPressedComponent) {
                    final ToolInfo toolInfo = ToolstripContextMenu.getToolInfo(component, mouseEvent.getPoint());
                    final boolean bl2 = ToolstripContextMenu.quickAccessActionAvailable(toolInfo);
                    final boolean bl3 = ToolstripContextMenu.collapseActionAvailable(toolInfo);
                    if (toolInfo.iToolstrip != null && toolInfo.iQuickAccessBar != null || toolInfo.iQuickAccessBar != null) {
                        if (component instanceof CustomizablePopupMenu) {
                            if (bl2 || bl3) {
                                ((CustomizablePopupMenu)component).setCustomizer(new PopupMenuCustomizer(){

                                    public void customize(JPopupMenu jPopupMenu) {
                                        jPopupMenu.addSeparator();
                                        ToolstripContextMenu.populateMenu(jPopupMenu, component, mouseEvent, toolInfo, bl2, bl3);
                                    }
                                });
                            }
                        } else if (!(component instanceof JMenuItem)) {
                            MJPopupMenu mJPopupMenu = new MJPopupMenu();
                            mJPopupMenu.setName("ToolstripContextMenu");
                            ToolstripContextMenu.populateMenu((JPopupMenu)mJPopupMenu, component, mouseEvent, toolInfo, bl2, bl3);
                            if (mJPopupMenu.getComponentCount() > 0) {
                                TSUtilities.showPopupMenu(mouseEvent, component, mJPopupMenu);
                            }
                        }
                    }
                }
            }
            if (aWTEvent.getID() == 502) {
                sPressedComponent = null;
            }
        }
    }

    private static class ToolInfo {
        private Toolstrip iToolstrip;
        private QuickAccessToolBar iQuickAccessBar;
        private TSToolPath iToolPath;
        private JComponent iComponent;

        private ToolInfo() {
        }
    }
}

