/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.PopupMenuCustomizer;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.components.gallery.GalleryOptions;
import com.mathworks.toolstrip.components.gallery.model.Category;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.FavoriteAction;
import com.mathworks.toolstrip.components.gallery.popupview.GallerySelectionModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

abstract class CategoryContentPanel
extends MJPanel
implements TSContextMenuContributor {
    protected final Category fCategory;
    protected final GalleryModel fModel;
    protected final GallerySelectionModel fSelectionModel;
    protected final GalleryOptions fOptions;
    protected final PopupMenuCustomizer fMenuCustomizer;
    protected Runnable fFavoritesAnimation;

    CategoryContentPanel(Category category, GalleryModel galleryModel, GallerySelectionModel gallerySelectionModel, GalleryOptions galleryOptions, PopupMenuCustomizer popupMenuCustomizer, Runnable runnable) {
        this.fCategory = category;
        this.fModel = galleryModel;
        this.fSelectionModel = gallerySelectionModel;
        this.fOptions = galleryOptions;
        this.fMenuCustomizer = popupMenuCustomizer;
        this.fFavoritesAnimation = runnable;
    }

    abstract void setActionListener(ActionListener var1);

    abstract void setCloseListener(ActionListener var1);

    abstract Item getItemAtPoint(Point var1);

    void setDragEnabled(boolean bl) {
    }

    public abstract void dispose();

    abstract Component getComponentForItem(Item var1);

    abstract Item getNextItem(Item var1);

    abstract Item getPreviousItem(Item var1);

    @Override
    public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)this));
        Item item = this.getItemAtPoint(point);
        if (item != null) {
            TSContextMenuContributor tSContextMenuContributor;
            Object object;
            if (this.fOptions.supportFavorites()) {
                object = new FavoriteAction(item, this.fModel, this.fFavoritesAnimation);
                object.putValue("SmallIcon", null);
                object.setComponentName("Favorite_");
                jPopupMenu.insert((Action)object, 0);
            }
            if ((object = item.getAction()) != null && (tSContextMenuContributor = (TSContextMenuContributor)object.getValue("toolstrip-context-menu-contributor")) != null) {
                tSContextMenuContributor.contributeToToolsripContextMenu(jPopupMenu, mouseEvent);
            }
        }
        if (this.fMenuCustomizer != null) {
            this.fMenuCustomizer.customize(jPopupMenu);
        }
        jPopupMenu.putClientProperty("retain-overlays", true);
    }
}

