/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.impl;

import com.mathworks.desktop.client.ClientCollectionListener;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.impl.ToolstripSectionComponentWrapper;
import com.mathworks.toolstrip.plaf.IconifiedSectionButton;
import com.mathworks.toolstrip.plaf.ToolstripTabContentUI;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JPanel;

public class ToolstripTabContentPanel
extends JPanel {
    private ToolstripTab fTab;
    private boolean fUIInstalled;

    public ToolstripTabContentPanel(ToolstripTab toolstripTab) {
        this.fTab = toolstripTab;
        for (ToolstripSection toolstripSection : toolstripTab.getModel()) {
            this.add(new ToolstripSectionComponentWrapper(toolstripTab, toolstripSection));
        }
        toolstripTab.getModel().addClientCollectionListener((ClientCollectionListener)new ClientCollectionListener<ToolstripSection>(){

            public void clientAdded(ClientCollectionListener.Added<ToolstripSection> added) {
                ToolstripTabContentPanel.this.add((Component)new ToolstripSectionComponentWrapper(ToolstripTabContentPanel.this.fTab, (ToolstripSection)added.getClient()), added.getIndex());
                this.refresh();
            }

            public void clientRemoved(ClientCollectionListener.Removed<ToolstripSection> removed) {
                ToolstripTabContentPanel.this.remove(removed.getIndex());
                this.refresh();
            }

            public void clientMoved(ClientCollectionListener.Moved<ToolstripSection> moved) {
                Component component = ToolstripTabContentPanel.this.getComponent(moved.getIndex());
                ToolstripTabContentPanel.this.remove(moved.getIndex());
                ToolstripTabContentPanel.this.add(component, moved.getDstIndex());
                this.refresh();
            }

            private void refresh() {
                ToolstripTabContentPanel.this.revalidate();
                ToolstripTabContentPanel.this.repaint();
            }
        });
    }

    public ToolstripSectionComponentWrapper getSectionComponent(int n) {
        return (ToolstripSectionComponentWrapper)this.getComponent(n);
    }

    public ToolstripTab getTab() {
        return this.fTab;
    }

    public boolean isSectionIconified(int n) {
        ToolstripSectionComponentWrapper toolstripSectionComponentWrapper = this.getSectionComponent(n);
        return ToolstripTabContentPanel.isSectionIconified(toolstripSectionComponentWrapper);
    }

    private static boolean isSectionIconified(Container container) {
        for (Component component : container.getComponents()) {
            if (component instanceof IconifiedSectionButton) {
                return true;
            }
            if (!(component instanceof Container) || !ToolstripTabContentPanel.isSectionIconified((Container)component)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ToolstripTabContentUI getUI() {
        return (ToolstripTabContentUI)this.ui;
    }

    @Override
    public void updateUI() {
        if (!this.fUIInstalled) {
            super.updateUI();
            this.fUIInstalled = true;
        }
    }

    @Override
    public String getUIClassID() {
        return "Toolstrip.ToolstripTabContentUI";
    }
}

