/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.sections;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mathworks.desktop.attr.AttributeChangeEvent;
import com.mathworks.desktop.client.BasicClient;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripSectionLayout;
import com.mathworks.toolstrip.ToolstripSectionLayoutPolicy;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSPriority;
import com.mathworks.toolstrip.components.VerticalAlignment;
import com.mathworks.toolstrip.components.gallery.view.GalleryView;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.sections.ColumnTSComponent;
import com.mathworks.toolstrip.sections.IconifiedSectionLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FlowToolstripSection
extends BasicClient
implements ToolstripSection {
    private static final int HORIZONTAL_GAP_BETWEEN_COMPONENTS = 3;
    private final List<TSComponent> fComponents = Lists.newArrayList();
    private ToolstripSectionLayoutPolicy fLayoutPolicy;
    private GalleryView fGallery;
    private int fCurrentNumberOfColumns;

    public FlowToolstripSection(@NotNull String string) {
        super(string);
    }

    public FlowToolstripSection(@NotNull String string, @NotNull String string2) {
        super(string);
        this.setAttribute(TITLE, string2);
    }

    public FlowToolstripSection(@NotNull String string, @NotNull String string2, int n) {
        super(string);
        this.setAttribute(TITLE, string2);
        this.setAttribute(PRIORITY, n);
    }

    public FlowToolstripSection add(@NotNull TSComponent tSComponent) {
        return this.add(this.fComponents.size(), tSComponent);
    }

    public FlowToolstripSection add(int n, @NotNull TSComponent tSComponent) {
        if (tSComponent instanceof GalleryView) {
            if (this.fGallery == null) {
                this.fGallery = (GalleryView)tSComponent;
                this.fCurrentNumberOfColumns = this.fGallery.getNumberOfColumnsInGalleryView();
            } else {
                throw new IllegalArgumentException("Only one GalleyView is allowed in a section.");
            }
        }
        this.fComponents.add(n, tSComponent);
        this.fLayoutPolicy = null;
        return this;
    }

    public FlowToolstripSection add(@NotNull TSComponent tSComponent, @NotNull TSPriority tSPriority) {
        ((JComponent)((Object)tSComponent)).putClientProperty("toolstripPriority", (Object)tSPriority);
        return this.add(tSComponent);
    }

    public FlowToolstripSection add(int n, @NotNull TSComponent tSComponent, @NotNull TSPriority tSPriority) {
        ((JComponent)((Object)tSComponent)).putClientProperty("toolstripPriority", (Object)tSPriority);
        return this.add(n, tSComponent);
    }

    public FlowToolstripSection remove(TSComponent tSComponent) {
        this.fComponents.remove(tSComponent);
        this.fLayoutPolicy = null;
        return this;
    }

    public ImmutableList<TSComponent> getComponents() {
        return ImmutableList.copyOf(this.fComponents);
    }

    protected void processAttributeChange(AttributeChangeEvent attributeChangeEvent) {
        if (attributeChangeEvent.getAttribute() == TITLE && attributeChangeEvent.getNewValue() == null) {
            throw new NullPointerException("TITLE cannot be null");
        }
    }

    @Override
    public ToolstripSectionLayoutPolicy getLayoutPolicy() {
        if (this.fLayoutPolicy == null) {
            this.fLayoutPolicy = this.createLayoutPolicy();
        }
        return this.fLayoutPolicy;
    }

    private ToolstripSectionLayoutPolicy createLayoutPolicy() {
        return new ToolstripSectionLayoutPolicy(){

            @Override
            public Iterator<ToolstripSectionLayout> iterator() {
                return new Iterator<ToolstripSectionLayout>(){
                    private State fState = State.UNCONSTRAINED;
                    private List<TSComponent> fComps;
                    private MixedSectionLayout fPrevLayout;

                    @Override
                    public boolean hasNext() {
                        return this.fState != null;
                    }

                    @Override
                    public ToolstripSectionLayout next() {
                        ToolstripSectionLayout toolstripSectionLayout = null;
                        if (this.fState != null) {
                            switch (this.fState) {
                                case UNCONSTRAINED: {
                                    this.fComps = new ArrayList<TSComponent>(FlowToolstripSection.this.fComponents);
                                    this.collapseHorizontalOnly();
                                    toolstripSectionLayout = new MixedSectionLayout(this.fComps, LayoutMode.VERTICAL_LAYOUT, FlowToolstripSection.this.getComponent());
                                    if (FlowToolstripSection.this.fGallery != null) {
                                        ((MixedSectionLayout)toolstripSectionLayout).setAllowedColumnsForGallery(FlowToolstripSection.this.fGallery.getNumberOfColumnsInGalleryView());
                                    }
                                    this.fState = this.fState.next();
                                    break;
                                }
                                case COLLAPSING_LOW: {
                                    toolstripSectionLayout = this.collapse(TSPriority.LOW);
                                    if (toolstripSectionLayout != null) {
                                        if (FlowToolstripSection.this.fGallery != null) {
                                            ((MixedSectionLayout)toolstripSectionLayout).setAllowedColumnsForGallery(FlowToolstripSection.this.fGallery.getNumberOfColumnsInGalleryView());
                                        }
                                        this.fPrevLayout = (MixedSectionLayout)toolstripSectionLayout;
                                        break;
                                    }
                                    this.fState = this.fState.next();
                                    return this.next();
                                }
                                case COLLAPSING_NORMAL: {
                                    toolstripSectionLayout = this.collapse(TSPriority.NORMAL);
                                    if (toolstripSectionLayout != null) {
                                        if (FlowToolstripSection.this.fGallery != null) {
                                            ((MixedSectionLayout)toolstripSectionLayout).setAllowedColumnsForGallery(FlowToolstripSection.this.fGallery.getNumberOfColumnsInGalleryView());
                                        }
                                        this.fPrevLayout = (MixedSectionLayout)toolstripSectionLayout;
                                        break;
                                    }
                                    this.fState = this.fState.next();
                                    return this.next();
                                }
                                case GALLERY_SHRINKING: {
                                    if (FlowToolstripSection.this.fGallery == null) {
                                        this.fState = this.fState.next();
                                        toolstripSectionLayout = this.next();
                                        break;
                                    }
                                    if (FlowToolstripSection.this.fCurrentNumberOfColumns > FlowToolstripSection.this.fGallery.getMinimumCols()) {
                                        MixedSectionLayout mixedSectionLayout = new MixedSectionLayout(FlowToolstripSection.this.getComponent());
                                        mixedSectionLayout.setAllowedColumnsForGallery(--FlowToolstripSection.this.fCurrentNumberOfColumns);
                                        for (TSComponent tSComponent : this.fComps) {
                                            if (this.fPrevLayout != null) {
                                                mixedSectionLayout.add(tSComponent, this.fPrevLayout.modeFor(tSComponent));
                                                continue;
                                            }
                                            mixedSectionLayout.add(tSComponent, tSComponent.getSupportedLayoutMode());
                                            this.fPrevLayout = mixedSectionLayout;
                                        }
                                        return mixedSectionLayout;
                                    }
                                    this.fState = this.fState.next();
                                    return this.next();
                                }
                                case NO_LABELS_LOW: {
                                    MixedSectionLayout mixedSectionLayout = new MixedSectionLayout(FlowToolstripSection.this.getComponent());
                                    if (this.fPrevLayout != null) {
                                        mixedSectionLayout.setAllowedColumnsForGallery(this.fPrevLayout.getAllowedColumnsForGallery());
                                    } else {
                                        this.fPrevLayout = mixedSectionLayout;
                                    }
                                    boolean bl = this.stripLabels(mixedSectionLayout, TSPriority.LOW);
                                    if (bl) {
                                        toolstripSectionLayout = mixedSectionLayout;
                                        this.fPrevLayout = mixedSectionLayout;
                                        break;
                                    }
                                    this.fState = this.fState.next();
                                    return this.next();
                                }
                                case NO_LABELS_NORMAL: {
                                    boolean bl;
                                    MixedSectionLayout mixedSectionLayout = new MixedSectionLayout(FlowToolstripSection.this.getComponent());
                                    if (this.fPrevLayout != null) {
                                        mixedSectionLayout.setAllowedColumnsForGallery(this.fPrevLayout.getAllowedColumnsForGallery());
                                    }
                                    if (bl = this.stripLabels(mixedSectionLayout, TSPriority.NORMAL)) {
                                        toolstripSectionLayout = mixedSectionLayout;
                                        this.fPrevLayout = mixedSectionLayout;
                                        break;
                                    }
                                    this.fState = this.fState.next();
                                    return this.next();
                                }
                                case ICONIFIED: {
                                    toolstripSectionLayout = new IconifiedSectionLayout(FlowToolstripSection.this);
                                    this.fState = this.fState.next();
                                }
                            }
                        }
                        return toolstripSectionLayout;
                    }

                    private void collapseHorizontalOnly() {
                        Object object;
                        ArrayList arrayList = Lists.newArrayList();
                        int n = this.fComps.size();
                        while (--n >= 0) {
                            boolean bl;
                            TSComponent tSComponent = this.fComps.get(n);
                            object = LAFUtil.getPriority(tSComponent);
                            boolean bl2 = bl = object != TSPriority.TOP && this.isHorizontalOnly(tSComponent);
                            if (bl && !arrayList.isEmpty() && tSComponent.canBeGroupedWith((TSComponent)arrayList.get(0)) && this.isHorizontalOnly((TSComponent)arrayList.get(0))) {
                                arrayList.add(0, tSComponent);
                                if (arrayList.size() != 3) continue;
                                this.move(arrayList);
                                arrayList.clear();
                                continue;
                            }
                            this.move(arrayList);
                            arrayList.clear();
                            if (!bl) continue;
                            arrayList.add(tSComponent);
                        }
                        this.move(arrayList);
                        int n2 = this.fComps.size();
                        for (n = 0; n < n2; ++n) {
                            object = this.fComps.get(n);
                            if (!this.isHorizontalOnly((TSComponent)object)) continue;
                            this.fComps.set(n, new ColumnTSComponent(new TSComponent[]{object}).setAlignment(VerticalAlignment.CENTER));
                        }
                    }

                    private boolean isHorizontalOnly(TSComponent tSComponent) {
                        LayoutMode layoutMode = tSComponent.getSupportedLayoutMode();
                        return layoutMode.hasProperty(LayoutMode.Property.HORIZONTAL) && !layoutMode.hasProperty(LayoutMode.Property.VERTICAL);
                    }

                    private ToolstripSectionLayout collapse(TSPriority tSPriority) {
                        ArrayList arrayList = Lists.newArrayList();
                        int n = this.fComps.size();
                        while (--n >= 0) {
                            TSComponent tSComponent = this.fComps.get(n);
                            TSPriority object = LAFUtil.getPriority(tSComponent);
                            if (object == tSPriority && !arrayList.isEmpty() && tSComponent.canBeGroupedWith((TSComponent)arrayList.get(0))) {
                                arrayList.add(0, tSComponent);
                                if (arrayList.size() != 3) continue;
                                break;
                            }
                            if (arrayList.size() > 1) break;
                            arrayList.clear();
                            if (object != tSPriority) continue;
                            arrayList.add(tSComponent);
                        }
                        if (arrayList.size() > 1) {
                            this.move(arrayList);
                            MixedSectionLayout mixedSectionLayout = new MixedSectionLayout(FlowToolstripSection.this.getComponent());
                            for (TSComponent tSComponent : this.fComps) {
                                mixedSectionLayout.add(tSComponent, LayoutMode.VERTICAL_LAYOUT);
                            }
                            return mixedSectionLayout;
                        }
                        return null;
                    }

                    private void move(List<TSComponent> list) {
                        if (list.size() <= 1) {
                            return;
                        }
                        int n = this.fComps.indexOf(list.get(0));
                        for (TSComponent tSComponent : list) {
                            this.fComps.remove(tSComponent);
                        }
                        this.fComps.add(n, new ColumnTSComponent(list));
                    }

                    private boolean stripLabels(MixedSectionLayout mixedSectionLayout, TSPriority tSPriority) {
                        boolean bl = false;
                        int n = this.fComps.size();
                        while (--n >= 0) {
                            TSComponent tSComponent = this.fComps.get(n);
                            LayoutMode layoutMode = this.fPrevLayout.modeFor(tSComponent);
                            if (!bl && LAFUtil.getPriority(tSComponent).ordinal() <= tSPriority.ordinal()) {
                                if (layoutMode == null || !layoutMode.hasProperty(LayoutMode.Property.NO_LABEL)) {
                                    bl = true;
                                }
                                mixedSectionLayout.add(0, tSComponent, LayoutMode.VERTICAL_NO_LABELS_LAYOUT);
                                continue;
                            }
                            if (layoutMode != null) {
                                mixedSectionLayout.add(0, tSComponent, layoutMode);
                                continue;
                            }
                            mixedSectionLayout.add(0, tSComponent, LayoutMode.VERTICAL_LAYOUT);
                        }
                        return bl;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @NotNull
    protected JComponent createComponent() {
        return new TSPanel();
    }

    public String toString() {
        return "Section[" + this.getName() + "]";
    }

    private static class MixedSectionLayout
    implements ToolstripSectionLayout {
        private final List<TSComponent> fComponents = Lists.newArrayList();
        private final List<LayoutMode> fLayoutModes = Lists.newArrayList();
        private final JComponent fContent;
        private int allowedColumnsForGallery;

        private MixedSectionLayout(JComponent jComponent) {
            this.fContent = jComponent;
        }

        public void setAllowedColumnsForGallery(int n) {
            this.allowedColumnsForGallery = n;
        }

        public int getAllowedColumnsForGallery() {
            return this.allowedColumnsForGallery;
        }

        private MixedSectionLayout(Collection<TSComponent> collection, LayoutMode layoutMode, JComponent jComponent) {
            this(jComponent);
            for (TSComponent tSComponent : collection) {
                this.add(tSComponent, layoutMode);
            }
        }

        public void add(TSComponent tSComponent, LayoutMode layoutMode) {
            this.add(-1, tSComponent, layoutMode);
        }

        public void add(int n, TSComponent tSComponent, LayoutMode layoutMode) {
            this.fComponents.add(n < 0 ? this.fComponents.size() : n, tSComponent);
            this.fLayoutModes.add(n < 0 ? this.fLayoutModes.size() : n, layoutMode);
        }

        public LayoutMode modeFor(TSComponent tSComponent) {
            int n = this.fComponents.indexOf(tSComponent);
            return n < 0 ? null : this.fLayoutModes.get(n);
        }

        private LayoutMode getConvertedModeAt(int n) {
            TSComponent tSComponent = this.fComponents.get(n);
            LayoutMode layoutMode = tSComponent.getSupportedLayoutMode();
            LayoutMode layoutMode2 = this.fLayoutModes.get(n);
            return layoutMode2.mask(layoutMode);
        }

        @Override
        public int getPreferredWidth(ToolstripTab toolstripTab, int n, int n2) {
            int n3 = 0;
            int n4 = this.fComponents.size();
            for (int i = 0; i < n4; ++i) {
                TSComponent tSComponent = this.fComponents.get(i);
                int n5 = this.getComponentWidth(tSComponent, this.getConvertedModeAt(i), n2);
                n3 += n5;
            }
            return n3 += 3 * (n4 - 1);
        }

        @Override
        public JComponent layout(ToolstripTab toolstripTab, int n, int n2) {
            this.fContent.removeAll();
            this.fContent.setLayout(null);
            int n3 = 0;
            int n4 = 0;
            Rectangle rectangle = new Rectangle();
            int n5 = this.fComponents.size();
            for (int i = 0; i < n5; ++i) {
                TSComponent tSComponent = this.fComponents.get(i);
                JComponent jComponent = (JComponent)((Object)tSComponent);
                this.fContent.add(jComponent);
                LayoutMode layoutMode = this.getConvertedModeAt(i);
                int n6 = this.getComponentWidth(tSComponent, layoutMode, n2);
                LAFUtil.setLayoutMode(tSComponent, layoutMode);
                jComponent.setBounds(n3, n4, n6, n2);
                rectangle.add(jComponent.getBounds());
                n3 += n6 + 3;
            }
            this.fContent.setPreferredSize(new Dimension(rectangle.x + rectangle.width, n2));
            return this.fContent;
        }

        private int getComponentWidth(TSComponent tSComponent, LayoutMode layoutMode, int n) {
            if (tSComponent instanceof GalleryView) {
                return ((GalleryView)tSComponent).getPreferredWidth(this.allowedColumnsForGallery, n);
            }
            return tSComponent.getPreferredWidth(layoutMode, n);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("MixedSectionLayout:\n");
            int n = this.fComponents.size();
            for (int i = 0; i < n; ++i) {
                TSComponent tSComponent = this.fComponents.get(i);
                stringBuilder.append(i).append(". ").append(tSComponent).append(" -> ").append(this.fLayoutModes.get(i)).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    private static enum State {
        UNCONSTRAINED,
        COLLAPSING_LOW,
        COLLAPSING_NORMAL,
        GALLERY_SHRINKING,
        NO_LABELS_LOW,
        NO_LABELS_NORMAL,
        ICONIFIED;


        State next() {
            State[] stateArray = State.values();
            int n = this.ordinal() + 1;
            return n >= stateArray.length ? null : stateArray[n];
        }
    }
}

