/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.filter.BoyerMooreCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.SingleCharacterCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.StartsWithCaseInsensitiveTextSearchStrategy;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMatcherEditor<E>
extends AbstractMatcherEditor<E> {
    public static final int CONTAINS = 0;
    public static final int STARTS_WITH = 1;
    public static final Object IDENTICAL_STRATEGY = new IdenticalStrategyFactory();
    public static final Object NORMALIZED_STRATEGY = new NormalizedStrategyFactory();
    private final TextFilterator<? super E> filterator;
    private int mode = 0;
    private TextSearchStrategy.Factory strategy = (TextSearchStrategy.Factory)IDENTICAL_STRATEGY;

    public TextMatcherEditor() {
        this(null);
    }

    public TextMatcherEditor(TextFilterator<? super E> filterator) {
        this.filterator = filterator;
    }

    public TextFilterator<? super E> getFilterator() {
        return this.filterator;
    }

    public void setMode(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("mode must be either TextMatcherEditor.CONTAINS or TextMatcherEditor.STARTS_WITH");
        }
        if (mode == this.mode) {
            return;
        }
        this.mode = mode;
        TextMatcher<E> currentTextMatcher = this.getCurrentTextMatcher();
        if (currentTextMatcher == null) {
            return;
        }
        if (mode == 1) {
            this.fireConstrained(currentTextMatcher.newMode(mode));
        } else {
            this.fireRelaxed(currentTextMatcher.newMode(mode));
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setStrategy(Object strategy) {
        if (strategy == this.strategy) {
            return;
        }
        if (!(strategy instanceof TextSearchStrategy.Factory)) {
            throw new IllegalArgumentException();
        }
        this.strategy = (TextSearchStrategy.Factory)strategy;
        TextMatcher<E> currentTextMatcher = this.getCurrentTextMatcher();
        if (currentTextMatcher == null) {
            return;
        }
        this.fireChanged(currentTextMatcher.newStrategy(strategy));
    }

    public Object getStrategy() {
        return this.strategy;
    }

    protected TextMatcher<E> getCurrentTextMatcher() {
        Matcher currentMatcher = this.getMatcher();
        if (currentMatcher instanceof TextMatcher) {
            return (TextMatcher)currentMatcher;
        }
        return null;
    }

    public void setFilterText(String[] newFilters) {
        SearchTerm[] searchTerms = new SearchTerm[newFilters.length];
        for (int i = 0; i < searchTerms.length; ++i) {
            searchTerms[i] = new SearchTerm(newFilters[i]);
        }
        this.setTextMatcher(new TextMatcher<E>(searchTerms, this.getFilterator(), this.getMode(), this.getStrategy()));
    }

    protected void setTextMatcher(TextMatcher<E> newMatcher) {
        TextMatcher<E> oldMatcher = this.getCurrentTextMatcher();
        if (newMatcher.equals(oldMatcher)) {
            return;
        }
        if (newMatcher.getSearchTerms().length == 0) {
            if (!this.isCurrentlyMatchingAll()) {
                this.fireMatchAll();
            }
            return;
        }
        if (this.isCurrentlyMatchingAll()) {
            this.fireConstrained(newMatcher);
        } else if (TextMatchers.isMatcherRelaxed(oldMatcher, newMatcher)) {
            this.fireRelaxed(newMatcher);
        } else if (TextMatchers.isMatcherConstrained(oldMatcher, newMatcher)) {
            this.fireConstrained(newMatcher);
        } else {
            this.fireChanged(newMatcher);
        }
    }

    private static class NormalizedStrategyFactory
    extends IdenticalStrategyFactory {
        private NormalizedStrategyFactory() {
        }

        public TextSearchStrategy create(int mode, String filter) {
            TextSearchStrategy result = super.create(mode, filter);
            result.setCharacterMap(GlazedListsImpl.getLatinDiacriticsStripper());
            return result;
        }
    }

    private static class IdenticalStrategyFactory
    implements TextSearchStrategy.Factory {
        private IdenticalStrategyFactory() {
        }

        public TextSearchStrategy create(int mode, String filter) {
            if (mode == 0) {
                if (filter.length() == 1) {
                    return new SingleCharacterCaseInsensitiveTextSearchStrategy();
                }
                return new BoyerMooreCaseInsensitiveTextSearchStrategy();
            }
            if (mode == 1) {
                return new StartsWithCaseInsensitiveTextSearchStrategy();
            }
            throw new IllegalArgumentException("unrecognized mode: " + mode);
        }
    }
}

