/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.CheckableTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.AbstractMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.swt.CheckWrapped;
import ca.odell.glazedlists.swt.CheckableWrapperList;
import ca.odell.glazedlists.swt.EventTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TableCheckFilterList<S, E>
extends TransformedList<S, E>
implements SelectionListener {
    private CheckMatcherEditor<S> checkMatcherEditor = new CheckMatcherEditor();
    private Table table;
    private CheckableTableFormat checkableTableFormat;

    public TableCheckFilterList(EventList<S> source, Table table, TableFormat tableFormat) {
        super(new FilterList(tableFormat instanceof CheckableTableFormat ? source : new CheckableWrapperList((EventList)source), Matchers.trueMatcher()));
        this.table = table;
        this.checkableTableFormat = tableFormat instanceof CheckableTableFormat ? (CheckableTableFormat)tableFormat : null;
        table.addSelectionListener((SelectionListener)this);
        FilterList filteredSource = (FilterList)this.source;
        filteredSource.setMatcherEditor(this.checkMatcherEditor);
        source.addListEventListener(this);
    }

    private void setChecked(Object element, boolean checked) {
        if (this.checkableTableFormat != null) {
            this.checkableTableFormat.setChecked(element, checked);
        } else {
            ((CheckWrapped)element).setChecked(checked);
        }
    }

    private void setChecked(int index, boolean checked) {
        this.setChecked(this.source.get(this.getSourceIndex(index)), checked);
    }

    private boolean getChecked(Object element) {
        if (this.checkableTableFormat != null) {
            return this.checkableTableFormat.getChecked(element);
        }
        return ((CheckWrapped)element).getChecked();
    }

    private boolean getChecked(int index) {
        return this.getChecked(this.source.get(this.getSourceIndex(index)));
    }

    public List getAllChecked() {
        ArrayList<E> result = new ArrayList<E>();
        for (int i = 0; i < this.size(); ++i) {
            if (!this.getChecked(i)) continue;
            result.add(this.get(i));
        }
        return result;
    }

    public void setCheckedOnly(boolean checkedOnly) {
        ((CheckMatcherEditor)this.checkMatcherEditor).setCheckedOnly(checkedOnly);
    }

    public boolean getCheckedOnly() {
        return ((CheckMatcherEditor)this.checkMatcherEditor).getCheckedOnly();
    }

    @Override
    public E get(int index) {
        if (this.checkableTableFormat != null) {
            return super.get(index);
        }
        CheckWrapped checkWrapped = (CheckWrapped)super.get(index);
        return checkWrapped.getWrapped();
    }

    @Override
    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent e) {
        if (e.detail == 32) {
            this.getReadWriteLock().writeLock().lock();
            try {
                this.updateItemChecked((TableItem)e.item);
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.detail == 32) {
            this.getReadWriteLock().writeLock().lock();
            try {
                this.updateItemChecked((TableItem)e.item);
            }
            finally {
                this.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    private void updateItemChecked(TableItem updated) {
        if (updated == null) {
            return;
        }
        int index = this.table.indexOf(updated);
        boolean checked = updated.getChecked();
        this.setChecked(index, checked);
        int sourceIndex = this.getSourceIndex(index);
        this.source.set(sourceIndex, this.source.get(sourceIndex));
    }

    @Override
    public void addListEventListener(ListEventListener listChangeListener) {
        super.addListEventListener(listChangeListener);
        if (listChangeListener instanceof EventTableViewer) {
            super.addListEventListener(new TableChecker());
        }
    }

    @Override
    public void dispose() {
        if (this.source instanceof CheckableWrapperList) {
            ((CheckableWrapperList)this.source).dispose();
        }
        super.dispose();
    }

    private class TableChecker
    implements ListEventListener {
        public TableChecker() {
            for (int i = 0; i < TableCheckFilterList.this.size(); ++i) {
                boolean checked = TableCheckFilterList.this.getChecked(i);
                TableCheckFilterList.this.table.getItem(i).setChecked(checked);
            }
        }

        public void listChanged(ListEvent listChanges) {
            while (listChanges.next()) {
                int changeIndex = listChanges.getIndex();
                int changeType = listChanges.getType();
                if (changeType != 2 && changeType != 1) continue;
                boolean checked = TableCheckFilterList.this.getChecked(changeIndex);
                TableCheckFilterList.this.table.getItem(changeIndex).setChecked(checked);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckMatcherEditor<T>
    extends AbstractMatcherEditor<T> {
        private boolean checkedOnly = false;

        private CheckMatcherEditor() {
        }

        private void setCheckedOnly(boolean checkedOnly) {
            if (checkedOnly == this.checkedOnly) {
                return;
            }
            if (checkedOnly) {
                this.fireConstrained(new CheckMatcher());
            } else {
                this.fireMatchAll();
            }
        }

        private boolean getCheckedOnly() {
            return this.checkedOnly;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CheckMatcher<V>
        implements Matcher<V> {
            private CheckMatcher() {
            }

            @Override
            public boolean matches(V element) {
                return TableCheckFilterList.this.getChecked(element);
            }
        }
    }
}

