/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class BufferedImageContainer {
    private int fTileX;
    private int fTileY;
    private int fTileWidth;
    private int fTileHeight;
    private BufferedImage fImg;
    private boolean fNext;
    private int fImgWidth;
    private int fImgHeight;
    private Rectangle fImageClip;
    int fMaxBufferSize;

    public BufferedImageContainer(Rectangle rectangle, int n, int n2, int n3) {
        this.fImgWidth = n;
        this.fImgHeight = n2;
        this.fTileWidth = (int)rectangle.getWidth();
        this.fTileHeight = (int)rectangle.getHeight();
        this.fNext = true;
        this.fImg = null;
        this.fTileX = (int)rectangle.getX();
        this.fTileY = (int)((double)n2 - (rectangle.getY() + rectangle.getHeight()));
        this.fMaxBufferSize = n3;
        this.fImageClip = new Rectangle(this.fTileX, this.fTileY, (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public boolean advance() {
        this.fTileX += this.fTileWidth;
        if (this.fTileX >= this.fImgWidth) {
            this.fTileX = 0;
            this.fTileY += this.fTileHeight;
            if (this.fTileY >= this.fImgHeight) {
                this.fTileY = 0;
            }
        }
        this.fNext = this.fTileX != 0 || this.fTileY != 0;
        return this.fNext;
    }

    public boolean isNextTileInClipRegion() {
        Rectangle rectangle = new Rectangle(this.fTileX, this.fTileY, this.fMaxBufferSize, this.fMaxBufferSize);
        boolean bl = rectangle.contains(this.fImageClip) || this.fImageClip.contains(rectangle) || this.fImageClip.intersects(rectangle);
        return bl;
    }

    public int adjustWidth(int n, int n2) {
        this.fTileWidth = Math.min(n2, n);
        this.fTileWidth = Math.min(this.fTileWidth, this.fImgWidth - this.fTileX);
        return this.fTileWidth;
    }

    public int adjustHeight(int n, int n2) {
        this.fTileHeight = Math.min(n2, n);
        this.fTileHeight = Math.min(this.fTileHeight, this.fImgHeight - this.fTileY);
        return this.fTileHeight;
    }

    public boolean next() {
        return this.fNext;
    }

    public int getX() {
        return this.fTileX;
    }

    public int getY() {
        return this.fTileY;
    }

    public int getWidth() {
        return this.fTileWidth;
    }

    public int getHeight() {
        return this.fTileHeight;
    }

    public int getImageWidth() {
        return this.fImgWidth;
    }

    public int getImageHeight() {
        return this.fImgHeight;
    }

    public BufferedImage getImage() {
        return this.fImg;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.fImg = bufferedImage;
    }
}

